/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.JarSigningData;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.util.LambdaExceptionUtils;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.NeoforgeModuleAccess;
import org.jetbrains.annotations.Nullable;

public class TILLoaderJarModuleDataProvider
implements SecureJar.ModuleDataProvider {
    final JarContents contents;
    final JarMetadata metadata;
    final JarSigningData signingData;
    URI uri;

    private static URI computeLoaderURI() {
        ResolvedModuleAccess module = NeoforgeModuleAccess.findResolvedModuleIn("theimpossiblebootstrap", IModuleLayerManager.Layer.BOOT);
        if (Objects.isNull(module)) {
            TILRef.logError("Failed to find ResolvedModule {} in BOOT layer!", "theimpossiblebootstrap");
        }
        URI uri = Objects.nonNull(module) ? module.reference().location() : null;
        TILRef.logInfo("Called computeLoaderURI on TILLoaderJarModuleDataProvider and returning URI is {}", uri);
        return uri;
    }

    public static SecureJar.ModuleDataProvider get(JarContents contents, JarMetadata metadata, JarSigningData signingData) {
        return new TILLoaderJarModuleDataProvider(contents, metadata, signingData);
    }

    TILLoaderJarModuleDataProvider(JarContents contents, JarMetadata metadata, JarSigningData signingData) {
        this.contents = contents;
        this.metadata = metadata;
        this.signingData = signingData;
    }

    public ModuleDescriptor descriptor() {
        return this.metadata.descriptor();
    }

    public Optional<URI> findFile(String name) {
        return this.contents.findFile(name);
    }

    public Manifest getManifest() {
        return this.contents.getManifest();
    }

    public String name() {
        return this.metadata.name();
    }

    public Optional<InputStream> open(String name) {
        return this.findFile(name).map(Paths::get).map(LambdaExceptionUtils.rethrowFunction(x$0 -> Files.newInputStream(x$0, new OpenOption[0])));
    }

    @Nullable
    public URI uri() {
        if (Objects.isNull(this.uri)) {
            this.uri = TILLoaderJarModuleDataProvider.computeLoaderURI();
        }
        return this.uri;
    }

    @Nullable
    public CodeSigner[] verifyAndGetSigners(String className, byte[] bytes) {
        return (CodeSigner[])Hacks.invokeDirect(this.signingData, "verifyAndGetSigners", this.getManifest(), className, bytes);
    }
}

