/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ConfigurationAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleLayerAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ModuleSystemAccessor;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ResolvedModuleAccess;
import mods.thecomputerizer.theimpossiblelibrary.api.core.modules.ServicesCatalogAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.EnvironmentAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.JarMetadataAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.LauncherAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.LayerInfoAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModFileAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleClassLoaderAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.ModuleLayerHandlerAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.SecureJarAccess;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.modules.SecureJarProviderAccess;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NeoforgeModuleAccess {
    public static String calculateLayerName(ModuleLayerAccess layer) {
        if (Objects.nonNull(layer.getLayerName())) {
            return layer.getLayerName();
        }
        Set<IModuleLayerManager.Layer> completedLayers = NeoforgeModuleAccess.getModuleLayerHandler().completedLayers().keySet();
        return NeoforgeModuleAccess.calculateLayerName(layer, completedLayers.toArray(new IModuleLayerManager.Layer[0]));
    }

    public static String calculateLayerName(ModuleLayerAccess moduleLayer, IModuleLayerManager.Layer ... validLayers) {
        if (Objects.nonNull(moduleLayer.getLayerName())) {
            return moduleLayer.getLayerName();
        }
        String name = "UNKNOWN-LAYER";
        for (IModuleLayerManager.Layer layer : validLayers) {
            ModuleLayerAccess validLayer = NeoforgeModuleAccess.getModuleLayer(layer);
            if (!Objects.nonNull(validLayer) || moduleLayer.access() != validLayer.access()) continue;
            name = layer.name();
            break;
        }
        moduleLayer.setLayerName(name);
        return name;
    }

    public static void combineModules(IModuleLayerManager.Layer layer, URI combinedLocation, String combinedName, String base, String ... others) {
        ModuleClassLoaderAccess loader = NeoforgeModuleAccess.getModuleClassLoader(layer);
        if (!base.equals(combinedName)) {
            loader.renameModule(base, combinedName);
        }
        loader.combineModules(combinedLocation, combinedName, others);
    }

    static Object defaultLogger() {
        return NeoForgeCoreLoader.getLogger();
    }

    public static String findConfigurationLayerName(ConfigurationAccess configuration) {
        Set<IModuleLayerManager.Layer> potentialLayers = NeoforgeModuleAccess.getModuleLayerHandler().completedLayers().keySet();
        for (IModuleLayerManager.Layer potentialLayer : potentialLayers) {
            if (NeoforgeModuleAccess.getModuleClassLoader(potentialLayer).configuration().access() != configuration.access()) continue;
            return potentialLayer.name();
        }
        return "UNKNOWN LAYER";
    }

    @IndirectCallers
    public static IModuleLayerManager.Layer findMatchingLayer(ClassLoader loader) {
        for (IModuleLayerManager.Layer layer : IModuleLayerManager.Layer.values()) {
            if (NeoforgeModuleAccess.getModuleClassLoader(layer).unwrap() != loader) continue;
            return layer;
        }
        return null;
    }

    @IndirectCallers
    public static ModuleAccess findModuleInAnyLayer(String moduleName) {
        return NeoforgeModuleAccess.findModuleInLayers(moduleName, IModuleLayerManager.Layer.BOOT, IModuleLayerManager.Layer.SERVICE, IModuleLayerManager.Layer.PLUGIN, IModuleLayerManager.Layer.GAME);
    }

    public static ModuleAccess findModuleInLayers(String moduleName, IModuleLayerManager.Layer ... layers) {
        for (IModuleLayerManager.Layer layer : layers) {
            ModuleAccess module = NeoforgeModuleAccess.findModuleInLayer(moduleName, layer);
            if (!Objects.nonNull(module)) continue;
            return module;
        }
        Logger logger = ModuleSystemAccessor.getAsLogger(NeoforgeModuleAccess.defaultLogger());
        logger.error("Failed to find module {} in the following layers: {}", (Object)moduleName, (Object)Arrays.toString(layers));
        return null;
    }

    public static ModuleAccess findModuleInLayer(String moduleName, IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getModuleLayer(layer).getModule(moduleName);
    }

    @IndirectCallers
    public static ModuleAccess findModuleInLayerNoError(String moduleName, IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getModuleLayer(layer).getModule(moduleName, false);
    }

    public static ResolvedModuleAccess findResolvedModuleIn(String moduleName, IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getModuleClassLoader(layer).configuration().getModule(moduleName);
    }

    public static EnvironmentAccess getEnvironment() {
        return NeoforgeModuleAccess.getLauncher().environment();
    }

    public static EnvironmentAccess getEnvironment(Object accessorOrLogger) {
        return NeoforgeModuleAccess.getLauncher(accessorOrLogger).environment();
    }

    @IndirectCallers
    public static EnvironmentAccess getEnvironment(Object environment, Object accessorOrLogger) {
        return new EnvironmentAccess(environment, accessorOrLogger);
    }

    public static JarMetadataAccess getJarMetadata(Object jarMetadata, Object accessorOrLogger) {
        return new JarMetadataAccess(jarMetadata, accessorOrLogger);
    }

    public static LauncherAccess getLauncher() {
        return NeoforgeModuleAccess.getLauncher(NeoforgeModuleAccess.defaultLogger());
    }

    public static LauncherAccess getLauncher(Object accessorOrLogger) {
        return new LauncherAccess(accessorOrLogger);
    }

    @IndirectCallers
    public static IModuleLayerManager.Layer getLayerFromName(String layerName) {
        return IModuleLayerManager.Layer.valueOf((String)layerName);
    }

    @IndirectCallers
    public static ClassLoader getLayerClassLoader(IModuleLayerManager.Layer layer, Object accessorOrLogger) {
        return NeoforgeModuleAccess.getLayerInfo(layer, accessorOrLogger).getClassLoader();
    }

    @IndirectCallers
    public static LayerInfoAccess getLayerInfo(IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getLayerInfo(layer, NeoforgeModuleAccess.defaultLogger());
    }

    public static LayerInfoAccess getLayerInfo(IModuleLayerManager.Layer layer, Object accessorOrLogger) {
        LayerInfoAccess layerInfo = NeoforgeModuleAccess.getModuleLayerHandler(accessorOrLogger).getLayerInfo(layer);
        layerInfo.setLayer(layer);
        return layerInfo;
    }

    public static LayerInfoAccess getLayerInfo(Object layerInfo, Object accessorOrLogger) {
        return new LayerInfoAccess(layerInfo, accessorOrLogger);
    }

    public static ModFileAccess getModFile(Object modFile, Object accessorOrLogger) {
        return new ModFileAccess(modFile, accessorOrLogger);
    }

    public static ModuleAccess getModule(Object module) {
        return ModuleSystemAccessor.getModule(module, NeoforgeModuleAccess.defaultLogger());
    }

    public static ModuleClassLoaderAccess getModuleClassLoader(@Nullable IModuleLayerManager.Layer layer) {
        if (Objects.isNull(layer)) {
            throw new NullPointerException("Tried to get ModuleClassLoader from null Layer!");
        }
        return NeoforgeModuleAccess.getLayerInfo(layer, NeoforgeModuleAccess.defaultLogger()).getModuleClassLoader();
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess getModuleClassLoader(@Nullable IModuleLayerManager.Layer layer, Object accessorOrLogger) {
        if (Objects.isNull(layer)) {
            throw new NullPointerException("Tried to get ModuleClassLoader from null Layer!");
        }
        return NeoforgeModuleAccess.getLayerInfo(layer, accessorOrLogger).getModuleClassLoader();
    }

    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader) {
        return new ModuleClassLoaderAccess((ModuleClassLoader)loader, NeoforgeModuleAccess.defaultLogger());
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader, IModuleLayerManager.Layer layer) {
        ModuleClassLoaderAccess moduleClassLoader = NeoforgeModuleAccess.getModuleClassLoader(loader);
        moduleClassLoader.setLayer(layer);
        return moduleClassLoader;
    }

    @IndirectCallers
    public static ModuleClassLoaderAccess getModuleClassLoader(ClassLoader loader, Object accessorOrLogger) {
        return new ModuleClassLoaderAccess((ModuleClassLoader)loader, accessorOrLogger);
    }

    public static ModuleLayerAccess getModuleLayer(Object moduleLayer) {
        return ModuleSystemAccessor.getModuleLayer(moduleLayer, NeoforgeModuleAccess.defaultLogger());
    }

    public static ModuleLayerAccess getModuleLayer(IModuleLayerManager.Layer layer) {
        return NeoforgeModuleAccess.getModuleLayer(layer, NeoforgeModuleAccess.defaultLogger());
    }

    public static ModuleLayerAccess getModuleLayer(IModuleLayerManager.Layer layer, Object accessorOrLogger) {
        return NeoforgeModuleAccess.getModuleLayerHandler(accessorOrLogger).getModuleLayer(layer);
    }

    public static ModuleLayerHandlerAccess getModuleLayerHandler() {
        return NeoforgeModuleAccess.getEnvironment().getModuleLayerHandler();
    }

    public static ModuleLayerHandlerAccess getModuleLayerHandler(Object accessorOrLogger) {
        return NeoforgeModuleAccess.getEnvironment(accessorOrLogger).getModuleLayerHandler();
    }

    @IndirectCallers
    public static ModuleLayerHandlerAccess getModuleLayerHandler(Object moduleLayerHandler, Object accessorOrLogger) {
        return new ModuleLayerHandlerAccess(moduleLayerHandler, accessorOrLogger);
    }

    @IndirectCallers
    public static String getModuleLayerName(ModuleAccess module) {
        return NeoforgeModuleAccess.calculateLayerName(module.getLayer());
    }

    public static SecureJarAccess getSecureJar(Object secureJar, Object accessorOrLogger) {
        return new SecureJarAccess(secureJar, accessorOrLogger);
    }

    public static SecureJarProviderAccess getSecureJarProvider(Object provider) {
        return NeoforgeModuleAccess.getSecureJarProvider(provider, NeoforgeModuleAccess.defaultLogger());
    }

    public static SecureJarProviderAccess getSecureJarProvider(Object provider, Object accessorOrLogger) {
        return new SecureJarProviderAccess(provider, accessorOrLogger);
    }

    public static void moveModule(IModuleLayerManager.Layer layer, IModuleLayerManager.Layer targetLayer, String moduleName, boolean moveClasses) {
        NeoforgeModuleAccess.moveModule(NeoforgeModuleAccess.getModuleClassLoader(layer), NeoforgeModuleAccess.getModuleClassLoader(targetLayer), moduleName, moveClasses);
    }

    public static void moveModule(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ResolvedModuleAccess module, boolean moveClasses) {
        if (Objects.nonNull(module)) {
            NeoforgeModuleAccess.moveModule(sourceLoader, targetLoader, module.name(), moveClasses);
        } else {
            sourceLoader.logger().error("Cannot move null module from {} to {}", (Object)sourceLoader, (Object)targetLoader);
        }
    }

    public static void moveModule(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, String moduleName, boolean moveClasses) {
        ModuleLayerAccess sourceLayer = sourceLoader.getModuleLayer();
        ModuleAccess module = sourceLayer.removeModuleAndReturn(moduleName);
        if (Objects.isNull(module)) {
            sourceLoader.logOrPrintError("Unable to move module " + moduleName + "! Cannot find module in source layer " + sourceLayer.getLayerName());
            return;
        }
        NeoforgeModuleAccess.moveModuleToLayer(sourceLoader, targetLoader, module, moveClasses);
    }

    private static void moveModuleClassesTo(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ModuleAccess module) {
        if (sourceLoader.access() != targetLoader.access()) {
            sourceLoader.moveModuleClassesTo(module, targetLoader);
        } else {
            sourceLoader.logger().info("Skipping movement of already present module {}", (Object)module.getName());
        }
    }

    public static void moveModuleToLayer(ModuleClassLoaderAccess sourceLoader, ModuleClassLoaderAccess targetLoader, ModuleAccess module, boolean moveClasses) {
        ModuleLayerAccess targetLayer = targetLoader.getModuleLayer();
        ServicesCatalogAccess targetServices = targetLayer.getServicesCatalog();
        if (moveClasses) {
            sourceLoader.logger().info("Moving classes");
            NeoforgeModuleAccess.moveModuleClassesTo(sourceLoader, targetLoader, module);
        }
        sourceLoader.moveModuleTo(targetLoader, module.getName());
        targetServices.registerModule(module);
        module.setLayer(targetLayer);
        module.setLoader(targetLoader);
        targetLayer.addModule(module);
    }

    @IndirectCallers
    public static void printConfigurationGraph(ConfigurationAccess configuration) {
        NeoforgeModuleAccess.printConfigurationGraph(configuration, true);
    }

    public static void printConfigurationGraph(ConfigurationAccess configuration, boolean printParents) {
        configuration.printGraph(NeoforgeModuleAccess.findConfigurationLayerName(configuration));
        if (printParents) {
            for (Object parent : configuration.parents()) {
                NeoforgeModuleAccess.printConfigurationGraph(ModuleSystemAccessor.getConfiguration(parent, configuration), true);
            }
        }
    }

    @IndirectCallers
    public static void removeResolvedModules(Collection<IModuleLayerManager.Layer> layers, String ... moduleNames) {
        for (IModuleLayerManager.Layer layer : layers) {
            NeoforgeModuleAccess.removeResolvedModules(layer, moduleNames);
        }
    }

    public static void removeResolvedModules(IModuleLayerManager.Layer layer, String ... moduleNames) {
        for (String moduleName : moduleNames) {
            NeoforgeModuleAccess.removeResolvedModule(layer, moduleName);
        }
    }

    public static void removeResolvedModule(IModuleLayerManager.Layer layer, String moduleName) {
        NeoforgeModuleAccess.getModuleClassLoader(layer).removeModuleFully(moduleName);
    }

    public static void renameModule(IModuleLayerManager.Layer layer, String name, String newName) {
        ModuleClassLoaderAccess loader = NeoforgeModuleAccess.getModuleClassLoader(layer);
        Logger logger = loader.logger();
        if (Objects.isNull(name) || Objects.isNull(newName)) {
            logger.error("Tried to rename {} module {} to {}", (Object)layer, (Object)name, (Object)newName);
            return;
        }
        if (name.equals(newName)) {
            logger.info("{} module name is already equal to {}", (Object)layer, (Object)newName);
            return;
        }
        loader.renameModule(name, newName);
    }
}

