/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.m6.network;

import java.util.Collection;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m6.network.MessageWrapper1_20_6;
import mods.thecomputerizer.theimpossiblelibrary.shared.v20.m6.network.Network1_20_6;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;

public class NetworkNeoForge1_20_6
extends Network1_20_6<Object, Object> {
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        TILRef.logInfo("Registering packet payloads", new Object[0]);
        PayloadRegistrar registrar = event.registrar("theimpossiblelibrary").executesOn(HandlerThread.NETWORK);
        NetworkNeoForge1_20_6.registerPayload(registrar, (CustomPacketPayload.Type)GenericUtils.cast(MessageWrapper1_20_6.Client.TYPE), true);
        NetworkNeoForge1_20_6.registerPayload(registrar, (CustomPacketPayload.Type)GenericUtils.cast(MessageWrapper1_20_6.Server.TYPE), false);
    }

    static <M extends MessageWrapper1_20_6<IPayloadContext>> void registerPayload(PayloadRegistrar registrar, CustomPacketPayload.Type<M> type, boolean client) {
        IPayloadHandler<M> handler = NetworkNeoForge1_20_6.registerPayloadHandler();
        if (client) {
            registrar.playToClient(type, MessageWrapper1_20_6.streamCodec(PacketFlow.CLIENTBOUND), handler);
        } else {
            registrar.playToServer(type, MessageWrapper1_20_6.streamCodec(PacketFlow.SERVERBOUND), handler);
        }
    }

    static <M extends MessageWrapper1_20_6<IPayloadContext>> IPayloadHandler<M> registerPayloadHandler() {
        return (msg, ctx) -> {
            MessageWrapperAPI reply = msg.handle(ctx);
            if (reply instanceof MessageWrapper1_20_6) {
                MessageWrapper1_20_6 neoReply = (MessageWrapper1_20_6)reply;
                ctx.reply((CustomPacketPayload)neoReply);
            }
        };
    }

    @Override
    public Object getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_SERVER", "PLAY_TO_SERVER" -> PacketFlow.SERVERBOUND;
            default -> PacketFlow.CLIENTBOUND;
        };
    }

    @Override
    public String getNameFromDir(Object dir) {
        return dir == PacketFlow.CLIENTBOUND ? "PLAY_TO_CLIENT" : "PLAY_TO_SERVER";
    }

    @Override
    public Object getDirToClient() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public Object getDirToClientLogin() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public Object getDirToServer() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public Object getDirToServerLogin() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public Object getNetwork() {
        return null;
    }

    @Override
    @Nullable
    public Object getOppositeDir(Object dir) {
        return ((PacketFlow)dir).getOpposite();
    }

    @Override
    public boolean isDirToClient(Object dir) {
        return dir == PacketFlow.CLIENTBOUND;
    }

    @Override
    public boolean isDirLogin(Object dir) {
        return dir == PacketFlow.SERVERBOUND;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<Object> dir, int id) {
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)((MessageWrapper1_20_6)message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        PacketDistributor.sendToServer((CustomPacketPayload)((MessageWrapper1_20_6)message), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(Object dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_6.getPayloadInstance(dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessage(dir, message);
        }
        return wrapper;
    }

    @Override
    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(Object dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_6.getPayloadInstance(dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        }
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(Object dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = (MessageWrapperAPI)GenericUtils.cast(MessageWrapper1_20_6.getPayloadInstance(dir));
        if (Objects.nonNull(wrapper)) {
            wrapper.setMessages(dir, messages);
        }
        return wrapper;
    }
}

