/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.registry.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.FutureCreativeTab;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class FutureCreativeTabNeoForge1_20
extends FutureCreativeTab<CreativeModeTab> {
    private final List<ItemStack> suppliedItems = new ArrayList<ItemStack>();

    public FutureCreativeTabNeoForge1_20(ResourceLocationAPI<?> registryName) {
        super(registryName);
    }

    protected abstract boolean canEventAccept(Object var1, ItemStack var2);

    protected abstract Consumer<ItemStack> eventEntryAcceptor(Object var1);

    @Override
    public void register(@Nullable Object arg) {
        if (Objects.isNull(arg) || Objects.isNull(this.registryName)) {
            TILRef.logError("Cannot register future creative tab with null arg or registryName!", new Object[0]);
            return;
        }
        ResourceLocation name = (ResourceLocation)this.registryName.unwrap();
        this.register(arg, Registries.CREATIVE_MODE_TAB, name, () -> {
            CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).title((Component)TextHelper.getTranslated("itemGroup." + name.getPath(), new Object[0]).getAsComponent());
            if (Objects.nonNull(this.iconSupplier)) {
                builder.icon(() -> (ItemStack)this.iconSupplier.get());
            }
            this.wrapped = builder.displayItems((args, output) -> {
                for (ItemStack stack : this.suppliedItems) {
                    output.accept(stack);
                }
            }).build();
            this.registered = true;
            return (CreativeModeTab)this.wrapped;
        });
    }

    protected abstract <T> void register(Object var1, ResourceKey<? extends Registry<T>> var2, ResourceLocation var3, Supplier<T> var4);

    @Override
    public void supply(@Nullable Object arg, List<Supplier<ItemStackAPI<?>>> stackSuppliers) {
        if (Objects.isNull(arg)) {
            TILRef.logError("Cannot supply future creative tab with null arg!", new Object[0]);
            return;
        }
        Consumer<ItemStack> acceptor = this.eventEntryAcceptor(arg);
        for (Supplier<ItemStackAPI<?>> supplier : stackSuppliers) {
            ItemStack stack = (ItemStack)supplier.get().unwrap();
            if (this.canEventAccept(arg, stack)) {
                acceptor.accept(stack);
            }
            if (this.suppliedItems.contains(stack)) continue;
            this.suppliedItems.add(stack);
        }
        stackSuppliers.clear();
    }
}

