/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v20.m6.server;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class WrappedCommand1_20_6 {
    private static final Map<String, CommandAPI> BY_NAME = new HashMap<String, CommandAPI>();
    public static final CustomSuggesterInfo INFO = new CustomSuggesterInfo();

    public static int execute(CommandContext<CommandSourceStack> ctx, CommandAPI wrapped) throws CommandSyntaxException {
        wrapped.prepareExceptionInfo();
        String exKey = wrapped.getExceptionKey();
        exKey = Objects.nonNull(exKey) ? exKey : "";
        Object[] exArgs = wrapped.getExceptionArgs();
        try {
            String[] args = WrappedCommand1_20_6.getArgStack(ctx);
            wrapped.execute(ctx, WrappedCommand1_20_6.rebuildInput(args), args[args.length - 1]);
            return 1;
        }
        catch (Exception ex) {
            TILRef.logError("Caught exception for command {}! Rethrowing as CommandException", wrapped.getRootName(), ex);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)TextHelper.getTranslated(exKey, exArgs).getApplied());
        }
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getArg(CommandAPI command) {
        ArgumentBuilder<CommandSourceStack, ?> arg = WrappedCommand1_20_6.getBuilder(command);
        for (CommandAPI subcmd : command.getSubCommands()) {
            arg.then(WrappedCommand1_20_6.getArg(subcmd));
        }
        if (command.isExecutionNode()) {
            arg.executes(ctx -> WrappedCommand1_20_6.execute((CommandContext<CommandSourceStack>)ctx, command));
        }
        return arg;
    }

    private static String[] getArgStack(CommandContext<?> ctx) {
        String input = ctx.getInput();
        if (!input.contains(" ")) {
            return new String[0];
        }
        return input.substring(input.indexOf(" ") + 1).split(" ");
    }

    private static ArgumentBuilder<CommandSourceStack, ?> getBuilder(CommandAPI command) {
        String name = command.getName();
        return switch (command.getType()) {
            case CommandAPI.ArgType.BOOLEAN -> Commands.argument((String)name, (ArgumentType)BoolArgumentType.bool());
            case CommandAPI.ArgType.DOUBLE -> Commands.argument((String)name, (ArgumentType)DoubleArgumentType.doubleArg());
            case CommandAPI.ArgType.ENTITY -> Commands.argument((String)name, (ArgumentType)EntityArgument.entity());
            case CommandAPI.ArgType.FLOAT -> Commands.argument((String)name, (ArgumentType)FloatArgumentType.floatArg());
            case CommandAPI.ArgType.INTEGER -> Commands.argument((String)name, (ArgumentType)IntegerArgumentType.integer());
            case CommandAPI.ArgType.LITERAL -> Commands.literal((String)name);
            case CommandAPI.ArgType.LONG -> Commands.argument((String)name, (ArgumentType)LongArgumentType.longArg());
            case CommandAPI.ArgType.PLAYER -> Commands.argument((String)name, (ArgumentType)EntityArgument.player());
            default -> Commands.argument((String)name, (ArgumentType)new CustomSuggester(command));
        };
    }

    private static String rebuildInput(String ... args) {
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = 0; i < args.length - 1; ++i) {
            joiner.add(args[i]);
        }
        return joiner.toString();
    }

    public static void register(Object dispatcherObj, CommandAPI wrapped) {
        CommandDispatcher dispatcher = (CommandDispatcher)dispatcherObj;
        LiteralArgumentBuilder root = Commands.literal((String)wrapped.getName());
        for (CommandAPI subcmd : wrapped.getSubCommands()) {
            root.then(WrappedCommand1_20_6.getArg(subcmd));
        }
        if (wrapped.isExecutionNode()) {
            root.executes(ctx -> WrappedCommand1_20_6.execute((CommandContext<CommandSourceStack>)ctx, wrapped));
        }
        dispatcher.register(root);
        BY_NAME.put(wrapped.getName(), wrapped);
    }

    public static void registerArgType() {
        if (CoreAPI.isForge() || CoreAPI.isNeoforge()) {
            Hacks.CallStrategy.STATIC.invoke(ArgumentTypeInfos.class, "registerByClass", CustomSuggester.class, INFO);
        } else {
            String field = TILDev.DEV ? "BY_CLASS" : "field_10921";
            Map byClass = (Map)Hacks.CallStrategy.STATIC_DIRECT.get(ArgumentTypeInfos.class, field);
            byClass.put(CustomSuggester.class, INFO);
        }
    }

    public record CustomSuggester(CommandAPI command) implements ArgumentType<String>
    {
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder builder) {
            MinecraftServerAPI<?> server = ServerHelper.getAPI();
            CommandSenderAPI sender = WrapperHelper.wrapCommandSender(ctx);
            List completions = Objects.nonNull(this.command) ? this.command.getTabCompletions(server, sender, builder.getInput(), builder.getRemaining()) : List.of();
            return SharedSuggestionProvider.suggest(completions, (SuggestionsBuilder)builder);
        }

        public String parse(StringReader reader) {
            return reader.readUnquotedString();
        }
    }

    public static class CustomSuggesterInfo
    implements ArgumentTypeInfo<CustomSuggester, CustomSuggesterTemplate> {
        public void serializeToNetwork(CustomSuggesterTemplate template, FriendlyByteBuf buf) {
            buf.writeUtf(template.command.getName());
        }

        @NotNull
        public CustomSuggesterTemplate deserializeFromNetwork(FriendlyByteBuf buf) {
            return new CustomSuggesterTemplate(BY_NAME.get(buf.readUtf()));
        }

        public void serializeToJson(CustomSuggesterTemplate template, JsonObject json) {
            json.addProperty("commandapi", template.command.getName());
        }

        @NotNull
        public CustomSuggesterTemplate unpack(CustomSuggester suggester) {
            return new CustomSuggesterTemplate(suggester.command);
        }

        public class CustomSuggesterTemplate
        implements ArgumentTypeInfo.Template<CustomSuggester> {
            final CommandAPI command;

            CustomSuggesterTemplate(CommandAPI command) {
                this.command = command;
            }

            @NotNull
            public CustomSuggester instantiate(CommandBuildContext context) {
                return new CustomSuggester(this.command);
            }

            @NotNull
            public CustomSuggesterInfo type() {
                return CustomSuggesterInfo.this;
            }
        }
    }
}

