/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v20.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.Hacks;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;

public abstract class MinecraftServer1_20
extends MinecraftServerAPI<MinecraftServer> {
    private final String saveFieldName;
    private final String levelDirFieldName;

    protected MinecraftServer1_20(String saveFieldName, String levelDirFieldName) {
        this.saveFieldName = saveFieldName;
        this.levelDirFieldName = levelDirFieldName;
    }

    @Override
    public void registerCommand(CommandAPI cmd) {
    }

    @Override
    public void executeCommandLiteral(String command) {
        MinecraftServer server = this.getServer();
        if (Objects.nonNull(server)) {
            server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), command);
        }
    }

    @Override
    @Nullable
    public PlayerAPI<?, ?> getPlayerByUUID(String uuid) {
        ServerPlayer player = this.getServer().getPlayerList().getPlayer(UUID.fromString(uuid));
        return Objects.nonNull(player) ? WrapperHelper.wrapPlayer(player) : null;
    }

    @Override
    public List<PlayerAPI<?, ?>> getPlayers() {
        ArrayList players = new ArrayList();
        for (Object player : this.getServer().getPlayerList().getPlayers()) {
            players.add(WrapperHelper.wrapPlayer(player));
        }
        return players;
    }

    @Override
    @Nullable
    public File getSaveDir() {
        MinecraftServer server = this.getServer();
        if (Objects.isNull(server)) {
            TILRef.logError("Unable to get the save directory as the server did not exist! Was this called from the client side?", new Object[0]);
            return null;
        }
        LevelStorageSource.LevelStorageAccess levelAccess = (LevelStorageSource.LevelStorageAccess)Hacks.getFieldDirect(server, this.saveFieldName);
        if (Objects.isNull(levelAccess)) {
            TILRef.logError("Failed to get LevelSave instance from server", new Object[0]);
            return null;
        }
        LevelStorageSource.LevelDirectory directory = (LevelStorageSource.LevelDirectory)Hacks.getFieldDirect(levelAccess, this.levelDirFieldName);
        if (Objects.isNull(directory)) {
            TILRef.logError("Failed to get path instance from LevelSave", new Object[0]);
            return null;
        }
        return directory.path().toFile();
    }

    @Override
    public abstract MinecraftServer getServer();
}

