/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.io.ByteBufferInputStream;

public class MemoryClassLoader
extends ClassLoader
implements Component,
Classes.Loaders.NotificationListenerOfParentsChange {
    Map<String, ByteBuffer> notLoadedByteCodes;
    Map<String, ByteBuffer> loadedByteCodes;
    Map<Object, Object> clients;
    protected boolean isClosed;
    private boolean markedAsCloseable;
    String instanceId = StaticComponentContainer.Objects.getCurrentId(this);
    ClassLoader[] allParents;

    protected MemoryClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        if (parentClassLoader instanceof MemoryClassLoader) {
            ((MemoryClassLoader)parentClassLoader).register(this);
        }
        this.notLoadedByteCodes = new ConcurrentHashMap<String, ByteBuffer>();
        this.loadedByteCodes = new ConcurrentHashMap<String, ByteBuffer>();
        this.clients = new ConcurrentHashMap<Object, Object>();
        StaticComponentContainer.ClassLoaders.registerNotificationListenerOfParentsChange(this);
        this.computeAllParents();
        DebugSupport.register(this);
    }

    private void computeAllParents() {
        Collection<ClassLoader> allParents = StaticComponentContainer.ClassLoaders.getAllParents(this);
        this.allParents = allParents.toArray(new ClassLoader[allParents.size()]);
    }

    @Override
    public void receive(Classes.Loaders.ChangeParentsContext context) {
        this.computeAllParents();
    }

    public static MemoryClassLoader create(ClassLoader parentClassLoader) {
        return new MemoryClassLoader(parentClassLoader);
    }

    public void addByteCode(String className, ByteBuffer byteCode) {
        try {
            this.addByteCode0(className, byteCode);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute addByteCode on class named {} because {} has been closed", className, this.toString());
        }
    }

    void addByteCode0(String className, ByteBuffer byteCode) {
        this.notLoadedByteCodes.put(className, byteCode);
    }

    public Map.Entry<String, ByteBuffer> getNotLoadedByteCode(String className) {
        try {
            for (Map.Entry<String, ByteBuffer> entry : this.notLoadedByteCodes.entrySet()) {
                if (!entry.getKey().equals(className)) continue;
                return entry;
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute getNotLoadedByteCode on class named {} because {} has been closed", className, this.toString());
        }
        return null;
    }

    public ByteBuffer getByteCodeOf(String className) {
        try {
            return Optional.ofNullable(this.notLoadedByteCodes.get(className)).orElseGet(() -> Optional.ofNullable(this.loadedByteCodes.get(className)).orElseGet(() -> null));
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute getByteCodeOf on class named {} because {} has been closed", className, this.toString());
            return null;
        }
    }

    void addByteCodes(Map<String, ByteBuffer> byteCodes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : byteCodes.entrySet()) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", byteCodes.toString(), this.toString());
        }
    }

    public void addByteCodes(Collection<Map.Entry<String, ByteBuffer>> classes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : classes) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", classes.toString(), this.toString());
        }
    }

    public void addByteCodes(Map.Entry<String, ByteBuffer> ... classes) {
        try {
            for (Map.Entry<String, ByteBuffer> clazz : classes) {
                this.addByteCode0(clazz.getKey(), clazz.getValue());
            }
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute addByteCodes on {} because {} has been closed", classes.toString(), this.toString());
        }
    }

    public boolean hasPackageBeenDefined(String packageName) {
        return StaticComponentContainer.Strings.isEmpty(packageName) || StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, packageName) != null;
    }

    @Override
    protected Package definePackage(String packageName, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Package pkg = null;
        if (StaticComponentContainer.Strings.isNotEmpty(packageName)) {
            try {
                pkg = super.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            }
            catch (IllegalArgumentException exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Package " + packageName + " already defined");
                pkg = StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, packageName);
            }
        }
        return pkg;
    }

    void definePackageOf(Class<?> cls) {
        String pckgName;
        if (cls.getName().contains(".") && StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, pckgName = cls.getName().substring(0, cls.getName().lastIndexOf("."))) == null) {
            StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + pckgName, () -> {
                if (StaticComponentContainer.ClassLoaders.retrieveLoadedPackage(this, pckgName) == null) {
                    this.definePackage(pckgName, null, null, null, null, null, null, null);
                }
            });
        }
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            cls = super.loadClass(className, resolve);
        }
        catch (Throwable exc) {
            if (className.startsWith("java.")) {
                cls = StaticComponentContainer.Driver.getClassByName(className, false, StaticComponentContainer.Classes.getClassLoader(this.getClass()), this.getClass());
            }
            StaticComponentContainer.Driver.throwException(exc);
        }
        this.removeNotLoadedBytecode(className);
        return cls;
    }

    public Class<?> loadOrDefineClass(Class<?> toLoad) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefine(toLoad, this);
    }

    public Class<?> loadOrDefineClass(JavaClass toLoad) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefineByJavaClass(toLoad, this);
    }

    public Class<?> loadOrDefineClass(ByteBuffer byteCode) throws ClassNotFoundException {
        return StaticComponentContainer.ClassLoaders.loadOrDefineByByteCode(byteCode, this);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = StaticComponentContainer.Resources.getAsInputStream(name, this.allParents).getValue();
        if (inputStream == null && name.endsWith(".class")) {
            inputStream = this.getByteCodeAsInputStream(name);
        }
        return inputStream;
    }

    protected InputStream getByteCodeAsInputStream(String classRelativePath) {
        ByteBuffer byteCode;
        if (classRelativePath.endsWith(".class") && (byteCode = this.getByteCode(classRelativePath)) != null) {
            return new ByteBufferInputStream(byteCode);
        }
        return null;
    }

    ByteBuffer getByteCode(String classRelativePath) {
        try {
            String className = classRelativePath.substring(0, classRelativePath.lastIndexOf(".class")).replace("/", ".");
            ByteBuffer byteCode = this.loadedByteCodes.get(className);
            if (byteCode == null) {
                byteCode = this.notLoadedByteCodes.get(className);
            }
            return byteCode;
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute getByteCode on {} because {} has been closed", classRelativePath, this.toString());
            return null;
        }
    }

    protected void addLoadedByteCode(String className, ByteBuffer byteCode) {
        try {
            this.loadedByteCodes.put(className, byteCode);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute addLoadedByteCode on {} because {} has been closed", className, this.toString());
        }
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> cls;
        block7: {
            cls = null;
            try {
                ByteBuffer byteCode = this.notLoadedByteCodes.get(className);
                if (byteCode != null) {
                    try {
                        cls = this._defineClass(className, byteCode, null);
                        this.definePackageOf(cls);
                        break block7;
                    }
                    catch (NoClassDefFoundError exc) {
                        String notFoundClassName = StaticComponentContainer.Classes.retrieveName(exc);
                        this.removeNotLoadedBytecode(className);
                        this.logWarn(className, StaticComponentContainer.Strings.compile("Could not load class {} because class {} could not be found, so it will be removed: {}", className, notFoundClassName, exc.toString()));
                        throw exc;
                    }
                }
                this.logWarn(className, StaticComponentContainer.Strings.compile("Bytecode of class {} not found", className));
            }
            catch (Throwable exc) {
                if (this.isClosed) {
                    this.logWarn(className, StaticComponentContainer.Strings.compile("Could not load class {} because {} has been closed", className, this.toString()));
                }
                throw exc;
            }
        }
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(className);
    }

    protected void logWarn(String className, String message) {
        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> _defineClass(String className, ByteBuffer byteCode, ProtectionDomain protectionDomain) {
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> cls = super.defineClass(className, byteCode, protectionDomain);
            this.addLoadedByteCode(className, byteCode);
            this.removeNotLoadedBytecode(className);
            return cls;
        }
    }

    public void removeNotLoadedBytecode(String className) {
        try {
            this.notLoadedByteCodes.remove(className);
        }
        catch (Throwable exc) {
            if (!this.isClosed) {
                throw exc;
            }
            StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute removeNotLoadedBytecode on class named {} because {} has been closed", className, this.toString());
        }
    }

    Map<String, ByteBuffer> getLoadedBytecodes() {
        return this.loadedByteCodes;
    }

    public Collection<Class<?>> forceBytecodesLoading() {
        HashSet loadedClasses = new HashSet();
        for (Map.Entry<String, ByteBuffer> entry : new HashMap<String, ByteBuffer>(this.notLoadedByteCodes).entrySet()) {
            try {
                loadedClasses.add(this.loadClass(entry.getKey()));
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not load class " + entry.getKey(), exc.getMessage());
            }
        }
        return loadedClasses;
    }

    @Override
    public QueuedTaskExecutor.Task clearInBackground() {
        Map<String, ByteBuffer> notLoadedByteCodes = this.notLoadedByteCodes;
        Map<String, ByteBuffer> loadedByteCodes = this.loadedByteCodes;
        this.notLoadedByteCodes = new HashMap<String, ByteBuffer>();
        this.loadedByteCodes = new HashMap<String, ByteBuffer>();
        return (QueuedTaskExecutor.Task)StaticComponentContainer.BackgroundExecutor.createTask(task -> {
            StaticComponentContainer.IterableObjectHelper.deepClear(notLoadedByteCodes);
            StaticComponentContainer.IterableObjectHelper.deepClear(loadedByteCodes);
        }, 1).submit();
    }

    protected void unregister() {
        StaticComponentContainer.ClassLoaders.unregister(this);
        StaticComponentContainer.ClassLoaders.unregisterNotificationListenerOfParentsChange(this);
        StaticComponentContainer.Cache.classLoaderForConstructors.remove(this, true);
        StaticComponentContainer.Cache.classLoaderForFields.remove(this, true);
        StaticComponentContainer.Cache.classLoaderForMethods.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForFields.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForConstructors.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForMethods.remove(this, true);
        StaticComponentContainer.Cache.bindedFunctionalInterfaces.remove(this, true);
        StaticComponentContainer.Cache.uniqueKeyForExecutableAndMethodHandle.remove(this, true);
    }

    public void register(Object client) {
        Map<Object, Object> clients = this.clients;
        if (!StaticComponentContainer.Synchronizer.execute(this.getOperationId("handleClients"), () -> {
            if (!this.isClosed) {
                clients.put(client, client);
                return true;
            }
            return false;
        }).booleanValue()) {
            throw new IllegalStateException(StaticComponentContainer.Strings.compile("Could not register client {} to {}: it is closed", client, this));
        }
    }

    public boolean unregister(Object client) {
        return this.unregister(client, false, false);
    }

    public boolean unregister(Object client, boolean close) {
        return this.unregister(client, close, false);
    }

    public boolean unregister(Object client, boolean close, boolean markAsCloseable) {
        if (markAsCloseable) {
            this.markedAsCloseable = markAsCloseable;
        }
        Map<Object, Object> clients = this.clients;
        return StaticComponentContainer.Synchronizer.execute(this.getOperationId("handleClients"), () -> {
            if (!this.isClosed) {
                clients.remove(client);
                if (clients.isEmpty() && (close || this.markedAsCloseable)) {
                    this.close();
                    return true;
                }
            }
            return this.isClosed;
        });
    }

    @Override
    public void close() {
        this.closeResources();
    }

    protected QueuedTaskExecutor.Task closeResources() {
        return this.closeResources(MemoryClassLoader.class.getName() + "@" + System.identityHashCode(this), () -> this.isClosed, task -> {
            if (!StaticComponentContainer.Synchronizer.execute(this.getOperationId("handleClients"), () -> {
                int clientSize;
                Map<Object, Object> clients = this.clients;
                if (clients != null && (clientSize = clients.size()) != 0) {
                    StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not close {} because there are {} registered clients", this, clients.size());
                    StaticComponentContainer.BackgroundExecutor.createTask(tsk -> this.close()).submit();
                    return false;
                }
                this.isClosed = true;
                return true;
            }).booleanValue()) {
                return;
            }
            ClassLoader parentClassLoader = StaticComponentContainer.ClassLoaders.getParent(this);
            if (parentClassLoader != null && parentClassLoader instanceof MemoryClassLoader) {
                ((MemoryClassLoader)parentClassLoader).unregister(this, true);
            }
            this.clearInBackground();
            this.notLoadedByteCodes = null;
            this.loadedByteCodes = null;
            StaticComponentContainer.Driver.getLoadedClassesRetriever(this).clear();
            this.unregister();
            DebugSupport.unregister(this);
            this.clients.clear();
            this.clients = null;
            if (this.getClass().equals(MemoryClassLoader.class)) {
                StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "ClassLoader {} successfully closed", this);
            }
        });
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static class DebugSupport
    implements Closeable {
        private static Map<MemoryClassLoader, DebugSupport> INSTANCES;
        private static boolean enabled;
        MemoryClassLoader memoryClassLoader;
        List<StackTraceElement> creationStack;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Map<MemoryClassLoader, DebugSupport> getInstances() {
            if (INSTANCES != null) return INSTANCES;
            Class<DebugSupport> clazz = DebugSupport.class;
            synchronized (DebugSupport.class) {
                if (INSTANCES != null) return INSTANCES;
                INSTANCES = new ConcurrentHashMap<MemoryClassLoader, DebugSupport>();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCES;
            }
        }

        static boolean register(MemoryClassLoader classLoader) {
            if (enabled) {
                return DebugSupport.getInstances().computeIfAbsent(classLoader, DebugSupport::new) == null;
            }
            return enabled;
        }

        static boolean unregister(MemoryClassLoader classLoader) {
            if (enabled) {
                DebugSupport debugSupport = DebugSupport.getInstances().remove(classLoader);
                if (debugSupport != null) {
                    debugSupport.close();
                }
                return debugSupport != null;
            }
            return enabled;
        }

        public static final void enable() {
            enabled = true;
        }

        private DebugSupport(MemoryClassLoader memoryClassLoader) {
            this.memoryClassLoader = memoryClassLoader;
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.creationStack = new ArrayList<StackTraceElement>();
            boolean exitedFromCostructors = false;
            for (int i = 5; i < stackTraceElements.length; ++i) {
                if (exitedFromCostructors) {
                    this.creationStack.add(stackTraceElements[i]);
                    continue;
                }
                if (stackTraceElements[i].getMethodName().equals("<init>")) continue;
                exitedFromCostructors = true;
                this.creationStack.add(stackTraceElements[i]);
            }
            memoryClassLoader.clients = new ConcurrentHashMap<Object, Object>(){
                private static final long serialVersionUID = -1409968440852414035L;

                @Override
                public Object put(Object client, Object clientRef) {
                    super.put(client, StaticComponentContainer.Methods.retrieveExternalCallersInfo());
                    return client;
                }
            };
        }

        private String getInfos() {
            return StaticComponentContainer.Strings.compile("\t{} {} and was created at:\n\n\t\t{}\n\n\t\t\tclients:\n\n\t\t\t\t{}", this.memoryClassLoader, this.memoryClassLoader.isClosed ? "is closed" : "is not closed", String.join((CharSequence)"\n\t\t", this.creationStack.stream().map(sE -> sE.toString()).collect(Collectors.toList())), this.memoryClassLoader.clients.isEmpty() ? "none" : String.join((CharSequence)"\n\n\t\t\t\t", this.memoryClassLoader.clients.entrySet().stream().map(cSE -> cSE.getKey() + " was registered at:\n\n\t\t\t\t\t" + String.join((CharSequence)"\n\t\t\t\t\t", ((List)cSE.getValue()).stream().map(sE -> sE.toString()).collect(Collectors.toList()))).collect(Collectors.toList())));
        }

        public static final void logAllInstancesInfo() {
            if (INSTANCES != null && INSTANCES.size() > 0) {
                StaticComponentContainer.ManagedLoggerRepository.logInfo(MemoryClassLoader.class::getName, "\n\n\nMemory class loaders: {}\n\n{}\n\n", INSTANCES.size(), String.join((CharSequence)"\n\n", INSTANCES.values().stream().map(mCL -> mCL.getInfos()).collect(Collectors.toList())));
            }
        }

        @Override
        public void close() {
            this.creationStack.clear();
            this.creationStack = null;
            this.memoryClassLoader = null;
        }
    }
}

