/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public class Orbit {
    private final double radius;
    private final double speed;
    private final double angle;

    public Orbit(double radius, double speed, double angle) {
        this.radius = radius;
        this.speed = speed;
        this.angle = angle;
    }

    public Vector3 getNextVec(Vector3 curVec, Vector3 centerVec) {
        double curGravity;
        double curDistance = curVec.distance(centerVec);
        double d = curGravity = curDistance < this.radius ? 0.0 : this.speed / (this.radius / curDistance);
        if (curGravity > this.speed) {
            curGravity = (curGravity - this.speed) / 100.0 + this.speed;
        }
        Vector3 dirVec = curVec.cross(centerVec).normalize().mulScalar(this.speed);
        Vector3 gravityVec = centerVec.sub(curVec).normalize().mulScalar(curGravity);
        return curVec.add(dirVec).add(gravityVec);
    }
}

