/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Clickable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Selectable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Tickable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Typeable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.input.KeyStateCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;

public class BasicTypeableWidget
extends TextWidget
implements Clickable,
Selectable,
Tickable,
Typeable {
    protected final int charLimit;
    protected String buffer;
    protected int cursorBlinkCounter;
    protected ColorCache colorOverride;
    protected boolean selected = true;

    public static BasicTypeableWidget from(TextAPI<?> text) {
        return BasicTypeableWidget.from(TextBuffer.of(text), 0.0, 0.0, -1);
    }

    public static BasicTypeableWidget from(TextAPI<?> text, ColorCache color) {
        return BasicTypeableWidget.from(TextBuffer.getBuilder(text).setColor(color).build(), 0.0, 0.0, -1);
    }

    public static BasicTypeableWidget from(TextBuffer buffer) {
        return BasicTypeableWidget.from(buffer, 0.0, 0.0, -1);
    }

    public static BasicTypeableWidget from(TextAPI<?> text, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.of(text), x, y, -1);
    }

    public static BasicTypeableWidget from(TextAPI<?> text, ColorCache color, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.getBuilder(text).setColor(color).build(), x, y, -1);
    }

    public static BasicTypeableWidget from(TextBuffer buffer, double x, double y) {
        return BasicTypeableWidget.from(buffer, x, y, -1);
    }

    public static BasicTypeableWidget from(TextAPI<?> text, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.of(text), x, y, charLimit);
    }

    public static BasicTypeableWidget from(TextAPI<?> text, ColorCache color, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.getBuilder(text).setColor(color).build(), x, y, charLimit);
    }

    public static BasicTypeableWidget from(TextBuffer buffer, double x, double y, int charLimit) {
        return new BasicTypeableWidget(buffer, x, y, charLimit);
    }

    public static BasicTypeableWidget literal(String literal) {
        return BasicTypeableWidget.from(TextBuffer.literal(literal), 0.0, 0.0, -1);
    }

    public static BasicTypeableWidget literal(String literal, ColorCache color) {
        return BasicTypeableWidget.from(TextBuffer.literalBuilder(literal).setColor(color).build(), 0.0, 0.0, -1);
    }

    public static BasicTypeableWidget literal(String literal, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.literal(literal), x, y, -1);
    }

    public static BasicTypeableWidget literal(String literal, ColorCache color, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.literalBuilder(literal).setColor(color).build(), x, y, -1);
    }

    public static BasicTypeableWidget literal(String literal, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.literal(literal), x, y, charLimit);
    }

    public static BasicTypeableWidget literal(String literal, ColorCache color, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.literalBuilder(literal).setColor(color).build(), x, y, charLimit);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args) {
        return BasicTypeableWidget.from(TextBuffer.translated(key, args), 0.0, 0.0, -1);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args, ColorCache color) {
        return BasicTypeableWidget.from(TextBuffer.translatedBuilder(key, args).setColor(color).build(), 0.0, 0.0, -1);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.translated(key, args), x, y, -1);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args, ColorCache color, double x, double y) {
        return BasicTypeableWidget.from(TextBuffer.translatedBuilder(key, args).setColor(color).build(), x, y, -1);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.translated(key, args), x, y, charLimit);
    }

    @IndirectCallers
    public static BasicTypeableWidget translated(String key, Object[] args, ColorCache color, double x, double y, int charLimit) {
        return BasicTypeableWidget.from(TextBuffer.translatedBuilder(key, args).setColor(color).build(), x, y, charLimit);
    }

    public BasicTypeableWidget(TextBuffer text, double x, double y, int charLimit) {
        super(text, x, y);
        this.charLimit = charLimit;
        this.buffer = this.toString();
        this.text.setBlinkerPos(this.buffer.length());
    }

    @Override
    public boolean canBackspace() {
        return this.canInteract(true) && (this.text.isHighlighting() || this.text.getBlinkerPos() > 0);
    }

    @Override
    public boolean canCopy() {
        return this.canInteract(true) && this.text.isHighlighting();
    }

    @Override
    public boolean canCut() {
        return this.canInteract(true) && this.text.isHighlighting();
    }

    public boolean canInteract(boolean checkEmpty) {
        return this.isSelected() && (!checkEmpty || this.isNotEmpty());
    }

    @Override
    public boolean canPaste(@Nullable String text) {
        return this.canInteract(false) && TextHelper.isNotEmpty(text) && (this.charLimit <= 0 || this.charLimit > this.textLength());
    }

    @Override
    public boolean canType(char c) {
        return this.canInteract(false) && this.charLimit <= 0 || this.charLimit > this.textLength();
    }

    @Override
    public BasicTypeableWidget copy() {
        BasicTypeableWidget copy = new BasicTypeableWidget(this.text.copy(), this.x, this.y, this.charLimit);
        copy.copyBasic(this);
        this.cursorBlinkCounter = copy.cursorBlinkCounter;
        this.selected = copy.selected;
        return copy;
    }

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        if (Objects.nonNull(this.text)) {
            ColorCache color = this.text.getColor();
            if (Objects.nonNull(this.colorOverride)) {
                this.text.setColor(this.colorOverride);
            }
            super.draw(ctx, center, mouseX, mouseY);
            this.text.setColor(color);
        }
    }

    @Override
    public void drawSelected(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        this.draw(ctx, center, mouseX, mouseY);
    }

    @Override
    public boolean isActivelyTicking() {
        return this.selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean onBackspace() {
        if (this.canBackspace()) {
            if (!this.text.isHighlighting()) {
                this.text.setHighlightEnd(this.text.getBlinkerPos());
                this.text.setHighlightStart(this.text.getBlinkerPos() - 1);
            }
            this.onTextRemoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(char c) {
        if (this.canType(c)) {
            this.onTextAdded(String.valueOf(c));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String onCopy() {
        return this.canCopy() ? this.text.getHighlighted() : null;
    }

    @Override
    @Nullable
    public String onCut() {
        return this.canCut() ? this.onTextRemoved() : null;
    }

    @Override
    public boolean onKeyPressed(KeyStateCache cache, int keyCode) {
        if (this.canInteract(true) && KeyHelper.isArrow(keyCode)) {
            if (keyCode == KeyHelper.getKeyCode(KeyAPI.Action.LEFT) && this.text.getBlinkerPos() > 0) {
                if (cache.isHoldingCtrl()) {
                    if (cache.isHoldingShift()) {
                        this.text.setHighlightStart(0);
                        this.text.setHighlightEnd(this.text.getBlinkerPos());
                    } else {
                        this.resetHighlight();
                    }
                    this.text.setBlinkerPos(0);
                } else {
                    if (cache.isHoldingShift()) {
                        this.text.decrementHighlight();
                    } else {
                        this.resetHighlight();
                    }
                    this.text.decrementBlinkerPos();
                }
                return true;
            }
            if (keyCode == KeyHelper.getKeyCode(KeyAPI.Action.RIGHT)) {
                int textLength = this.textLength();
                if (this.text.getBlinkerPos() < textLength) {
                    if (cache.isHoldingCtrl()) {
                        if (cache.isHoldingShift()) {
                            this.text.setHighlightStart(this.text.getBlinkerPos());
                            this.text.setHighlightEnd(textLength);
                        } else {
                            this.resetHighlight();
                        }
                        this.text.setBlinkerPos(textLength);
                    } else {
                        if (cache.isHoldingShift()) {
                            this.text.incrementHighlight();
                        } else {
                            this.resetHighlight();
                        }
                        this.text.incrementBlinkerPos();
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onLeftClick(double x, double y) {
        double width = this.getWidth();
        double parentWidth = Objects.nonNull(this.parent) ? this.parent.getWidth() : 0.0;
        double height = this.getHeight();
        Vector3 center = this.getCenter(0.0);
        int pos = this.text.getCharPos(RenderHelper.getContext(), x, y, this.getCenter(0.0), this.getMinX(center.dX(), width, parentWidth), this.getMinY(center.dY(), height), this.getMaxX(center.dX(), width, parentWidth), this.getMaxY(center.dY(), height));
        if (pos != -1) {
            this.selected = true;
            this.text.setBlinkerPos(pos);
            return true;
        }
        this.selected = false;
        this.text.setBlinkerVisible(false);
        return false;
    }

    @Override
    public boolean onPaste(@Nullable String text) {
        if (this.canPaste(text)) {
            this.onTextAdded(String.valueOf(text));
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClick(double x, double y) {
        return false;
    }

    @Override
    public void onScreenClosed() {
        this.cursorBlinkCounter = 0;
        this.selected = false;
    }

    @Override
    public boolean onSelectAll() {
        if (this.canInteract(true)) {
            this.text.setHighlightStart(0);
            this.text.setHighlightEnd(this.textLength());
            return true;
        }
        return false;
    }

    protected void onTextAdded(String text) {
        int pasteLength = text.length();
        int blinkerPos = this.text.getBlinkerPos();
        int newBlinkerPos = this.text.getBlinkerPos() + pasteLength;
        int textLength = this.textLength();
        if (this.text.isHighlighting()) {
            String cut = this.text.getHighlighted();
            int cutLength = cut.length();
            if (cutLength < textLength) {
                int highlightStart = this.text.getHighlightStart();
                if (highlightStart > 0) {
                    text = this.buffer.substring(0, highlightStart) + text;
                }
                if (this.text.getHighlightEnd() < textLength) {
                    text = text + this.buffer.substring(highlightStart + cutLength);
                }
                if (highlightStart != newBlinkerPos) {
                    newBlinkerPos -= newBlinkerPos - highlightStart;
                }
            }
            this.resetHighlight();
        } else {
            if (blinkerPos > 0) {
                text = this.buffer.substring(0, blinkerPos) + text;
            }
            if (blinkerPos < textLength) {
                text = text + this.buffer.substring(blinkerPos);
            }
        }
        this.text.setBlinkerPos(newBlinkerPos);
        this.setText(text);
    }

    protected String onTextRemoved() {
        String cut = this.text.getHighlighted();
        int cutLength = cut.length();
        int textLength = this.textLength();
        String s = "";
        if (cutLength < textLength) {
            if (this.text.getHighlightStart() > 0) {
                s = s + this.buffer.substring(0, this.text.getHighlightStart());
            }
            if (this.text.getHighlightEnd() < textLength) {
                s = s + this.buffer.substring(this.text.getHighlightStart() + cutLength);
            }
        }
        this.text.setBlinkerPos(this.text.getHighlightStart());
        this.setText(s);
        this.resetHighlight();
        return cut;
    }

    @Override
    public void onTick() {
        ++this.cursorBlinkCounter;
        if (this.cursorBlinkCounter == 10) {
            this.text.flipBlinkerVisibility();
            this.setText(this.buffer);
            this.cursorBlinkCounter = 0;
        }
    }

    @Override
    public void playLeftClickSound() {
    }

    @Override
    public void playRightClickSound() {
    }

    public void resetHighlight() {
        this.text.setHighlightEnd(0);
        this.text.setHighlightStart(0);
    }

    @Override
    public BasicTypeableWidget setText(TextBuffer text) {
        String str;
        this.text = text;
        this.buffer = str = String.valueOf(text);
        int blinkerPos = this.text.getBlinkerPos();
        if (blinkerPos > str.length() || blinkerPos < 0) {
            blinkerPos = str.length();
        }
        this.text.setBlinkerPos(blinkerPos);
        return this;
    }

    @Generated
    public int getCharLimit() {
        return this.charLimit;
    }

    @Generated
    public ColorCache getColorOverride() {
        return this.colorOverride;
    }

    @Generated
    public void setColorOverride(ColorCache colorOverride) {
        this.colorOverride = colorOverride;
    }
}

