/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Collection;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.BoundedWidgetGroup;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Hoverable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Scrollable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.Widget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;

public abstract class ScrollableWidgetGroup
extends BoundedWidgetGroup
implements Scrollable {
    protected double scrollOffset;
    protected double scrollSpeed = 0.1;

    protected ScrollableWidgetGroup() {
    }

    @Override
    public void addWidget(Widget widget) {
        super.addWidget(widget);
        this.recalculatePositions();
    }

    @Override
    public void addWidgets(Widget ... widgets) {
        for (Widget widget : widgets) {
            this.widgets.add(widget);
            widget.setParent(this);
        }
        this.recalculatePositions();
    }

    @Override
    public void addWidgets(Collection<Widget> widgets) {
        for (Widget widget : widgets) {
            this.widgets.add(widget);
            widget.setParent(this);
        }
        this.recalculatePositions();
    }

    @Override
    public abstract ScrollableWidgetGroup copy();

    protected void copyScrollable(ScrollableWidgetGroup other) {
        this.copyGroup(other);
        this.scrollOffset = other.scrollOffset;
        this.scrollSpeed = other.scrollSpeed;
    }

    public abstract boolean doesNotRequireHoverToScroll();

    @Override
    public void draw(RenderContext ctx, Vector3 center, double mouseX, double mouseY) {
        super.draw(ctx, center.add(0.0, this.scrollOffset, 0.0, new Vector3()), mouseX, mouseY);
    }

    @Override
    protected boolean drawHoverable(RenderContext ctx, Hoverable hoverable, Vector3 center, double mouseX, double mouseY) {
        if (this.isBounded(center, mouseX = this.getOffsetX(mouseX), (mouseY = this.getOffsetY(mouseY)) + this.scrollOffset) && hoverable.isHovering(mouseX, mouseY) && hoverable.shouldDrawHovered()) {
            hoverable.drawHovered(ctx, center, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public Collection<TextAPI<?>> getHoverLines(double mouseX, double mouseY) {
        return super.getHoverLines(this.getOffsetX(mouseX), this.getOffsetY(mouseY));
    }

    public double getOffsetX(double x) {
        return x;
    }

    public double getOffsetY(double y) {
        return y - this.scrollOffset;
    }

    @Override
    protected Box getRenderBounds(Vector3 center) {
        return super.getRenderBounds(center, 0.0, -this.scrollOffset, 0.0);
    }

    public boolean isHoveringForScroll() {
        double mouseX = RenderHelper.getScaledMouseX();
        double mouseY = RenderHelper.getScaledMouseY();
        double width = this.getWidth();
        double height = this.getHeight();
        double left = this.getLeft();
        double bottom = this.getBottom();
        return mouseX > left && mouseY > bottom && mouseX < left + width && mouseY < bottom + height;
    }

    @Override
    public boolean onLeftClick(double mouseX, double mouseY) {
        return super.onLeftClick(mouseX, this.getOffsetY(mouseY));
    }

    @Override
    public boolean onRightClick(double mouseX, double mouseY) {
        return super.onRightClick(mouseX, this.getOffsetY(mouseY));
    }

    protected abstract void recalculatePositions();

    protected double scroll(double scrollAmount) {
        return this.scrollSpeed * Math.abs(scrollAmount);
    }

    @Override
    public boolean scrollDown(double scroll) {
        double elementsHeight;
        double height;
        if ((this.doesNotRequireHoverToScroll() || this.isHoveringForScroll()) && this.scrollOffset + (height = this.getHeight()) < (elementsHeight = this.getElementsHeight())) {
            this.scrollOffset = Math.min(this.scrollOffset + this.scroll(scroll), elementsHeight - height);
            return true;
        }
        return false;
    }

    @Override
    public boolean scrollUp(double scroll) {
        if ((this.doesNotRequireHoverToScroll() || this.isHoveringForScroll()) && this.scrollOffset > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - this.scroll(scroll), 0.0);
            return true;
        }
        return false;
    }

    @Override
    public void setWidgets(Collection<Widget> widgets) {
        super.setWidgets(widgets);
        this.recalculatePositions();
    }

    @Generated
    public double getScrollOffset() {
        return this.scrollOffset;
    }

    @Generated
    public double getScrollSpeed() {
        return this.scrollSpeed;
    }

    @Generated
    public void setScrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }
}

