/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public final class RenderScale {
    private double displayWidth;
    private double displayHeight;
    private double displayRatio;
    private double displayScaleX;
    private double displayScaleY;
    private double screenWidth;
    private double screenHeight;
    private double screenRatio;
    private double screenScaleX;
    private double screenScaleY;
    private double scaleZ = 1.0;
    private double modScaleX = 1.0;
    private double modScaleY = 1.0;
    private double modScaleZ = 1.0;
    private double transformX;
    private double transformY;
    private double transformZ;
    private Box renderBounds = Box.INFINITE;

    RenderScale(MinecraftWindow window) {
        this.updateResolution(window.getWidth(), window.getHeight(), window.getDisplayWidth(), window.getDisplayHeight());
    }

    public VertexWrapper applyForScreen(VertexWrapper buffer, Vector3 center, double x, double y, double z) {
        return buffer.pos(this.applyXForScreen(center.dX(), x), this.applyYForScreen(center.dY(), y), this.applyZForScreen(center.dZ(), z));
    }

    double applyXForScreen(double centerX, double x) {
        x = Math.max(this.renderBounds.min.dX(), Math.min(centerX + x, this.renderBounds.max.dX()));
        x = (x * this.modScaleX + this.transformX + 1.0) / this.screenScaleX;
        return x;
    }

    double applyYForScreen(double centerY, double y) {
        y = Math.max(this.renderBounds.min.dY(), Math.min(centerY + y, this.renderBounds.max.dY()));
        y = this.screenHeight - (y * this.modScaleY + this.transformY + 1.0) / this.screenScaleY;
        return y;
    }

    double applyZForScreen(double centerZ, double z) {
        return centerZ + z;
    }

    public boolean canDraw(Vector3 center) {
        return this.renderBounds.isInside(center);
    }

    public double getSmallerDimensionScale() {
        return this.screenWidth >= this.screenHeight ? this.screenRatio : this.screenWidth / this.screenHeight;
    }

    public void modScales(double x, double y, double z) {
        this.modScaleX *= x;
        this.modScaleY *= y;
        this.modScaleZ *= z;
    }

    public void modTransforms(double x, double y, double z) {
        this.transformX += x * this.modScaleX;
        this.transformY += y * this.modScaleY;
        this.transformZ += z * this.modScaleZ;
    }

    public double normalizeDisplayX(Number x) {
        return x.doubleValue() * this.displayScaleX - 1.0;
    }

    public double normalizeDisplayY(Number y) {
        return -1.0 + y.doubleValue() * this.displayScaleY;
    }

    public double normalizeX(Number x) {
        return x.doubleValue() * this.screenScaleX - 1.0;
    }

    public double normalizeY(Number y) {
        return 1.0 - y.doubleValue() * this.screenScaleY;
    }

    public void updateResolution(double screenWidth, double screenHeight, double displayWidth, double displayHeight) {
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.displayRatio = displayHeight / displayWidth;
        this.displayScaleX = 1.0 / (displayWidth / 2.0);
        this.displayScaleY = 1.0 / (displayHeight / 2.0);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.screenRatio = screenHeight / screenWidth;
        this.screenScaleX = 1.0 / (screenWidth / 2.0);
        this.screenScaleY = 1.0 / (screenHeight / 2.0);
    }

    @Generated
    public double getDisplayWidth() {
        return this.displayWidth;
    }

    @Generated
    public double getDisplayHeight() {
        return this.displayHeight;
    }

    @Generated
    public double getDisplayRatio() {
        return this.displayRatio;
    }

    @Generated
    public double getDisplayScaleX() {
        return this.displayScaleX;
    }

    @Generated
    public double getDisplayScaleY() {
        return this.displayScaleY;
    }

    @Generated
    public double getScreenWidth() {
        return this.screenWidth;
    }

    @Generated
    public double getScreenHeight() {
        return this.screenHeight;
    }

    @Generated
    public double getScreenRatio() {
        return this.screenRatio;
    }

    @Generated
    public double getScreenScaleX() {
        return this.screenScaleX;
    }

    @Generated
    public double getScreenScaleY() {
        return this.screenScaleY;
    }

    @Generated
    public double getScaleZ() {
        return this.scaleZ;
    }

    @Generated
    public double getModScaleX() {
        return this.modScaleX;
    }

    @Generated
    public double getModScaleY() {
        return this.modScaleY;
    }

    @Generated
    public double getModScaleZ() {
        return this.modScaleZ;
    }

    @Generated
    public double getTransformX() {
        return this.transformX;
    }

    @Generated
    public double getTransformY() {
        return this.transformY;
    }

    @Generated
    public double getTransformZ() {
        return this.transformZ;
    }

    @Generated
    public Box getRenderBounds() {
        return this.renderBounds;
    }

    @Generated
    public void setScaleZ(double scaleZ) {
        this.scaleZ = scaleZ;
    }

    @Generated
    public void setRenderBounds(Box renderBounds) {
        this.renderBounds = renderBounds;
    }
}

