/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget.TextWidget;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.Renderable;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.TextBuffer;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public class RenderableText
extends Renderable {
    private final TextWidget titleWidget = TextWidget.literal("");
    private final TextWidget subtitleWidget = TextWidget.literal("");
    private final List<?> potentialText = this.getParameterAs("titles", new ArrayList());
    private final List<?> potentialSubtext = this.getParameterAs("subtitles", new ArrayList());
    private String text = "";
    private String subtext = "";

    public RenderableText(Map<String, Object> parameters) {
        super(parameters);
    }

    private TextBuffer createSubtitleBuffer(float opacity, int spacing) {
        return new TextBuffer.Builder(TextHelper.getLiteral(this.subtext)).setColor(ColorHelper.getColor(this.getParameterAs("subtitle_color", "white")).withAlpha(opacity)).setLineSpacing(spacing).build();
    }

    private TextBuffer createTitleBuffer(float opacity, int spacing) {
        return new TextBuffer.Builder(TextHelper.getLiteral(this.text)).setColor(ColorHelper.getColor(this.getParameterAs("title_color", "red")).withAlpha(opacity)).setLineSpacing(spacing * 5).build();
    }

    @Override
    public void initializeTimers() {
        super.initializeTimers();
        if (!this.potentialText.isEmpty()) {
            this.text = String.valueOf(RandomHelper.getBasicRandomEntry(this.potentialText));
        }
        if (!this.potentialSubtext.isEmpty()) {
            this.subtext = String.valueOf(RandomHelper.getBasicRandomEntry(this.potentialSubtext));
        }
    }

    @Override
    public void pos(RenderContext ctx) {
        double x = this.getAllignmentX() + this.getParameterAs("x", 0.0);
        double y = this.getAllignmentY() + this.getParameterAs("y", 0.0);
        this.titleWidget.setX(x);
        this.titleWidget.setY(y);
        this.subtitleWidget.setX(x);
        this.subtitleWidget.setY(y + this.titleWidget.getHeight() * 1.5);
    }

    @Override
    void render(RenderContext ctx) {
        if (this.canRender()) {
            float opacity = Math.max(0.1f, this.getOpacity());
            int fontHeight = ctx.getFont().getFontHeight();
            this.titleWidget.setText(this.createTitleBuffer(opacity, fontHeight));
            this.titleWidget.setColor(this.titleWidget.getWrapped().getColor());
            this.subtitleWidget.setText(this.createSubtitleBuffer(opacity, fontHeight));
            this.subtitleWidget.setColor(this.subtitleWidget.getWrapped().getColor());
            ctx.getRenderer().pushMatrix();
            this.pos(ctx);
            this.scaleTitle(ctx, this.getParameterAs("scale_x", Float.valueOf(1.0f)).floatValue(), this.getParameterAs("scale_y", Float.valueOf(1.0f)).floatValue());
            this.titleWidget.draw(ctx, VectorHelper.zero3D(), 0.0, 0.0);
            this.scaleSubtitle(ctx, this.getParameterAs("subtitle_scale", Float.valueOf(1.0f)).floatValue());
            this.subtitleWidget.draw(ctx, VectorHelper.zero3D(), 0.0, 0.0);
            ctx.getRenderer().popMatrix();
        }
    }

    protected void scaleSubtitle(RenderContext ctx, float scale) {
        ctx.getRenderer().scale(scale *= 0.75f, scale, scale);
        this.translateScaled(ctx, scale, scale);
    }

    protected void scaleTitle(RenderContext ctx, float scaleX, float scaleY) {
        ctx.getRenderer().scale(scaleX *= 5.0f, scaleY *= 5.0f, 1.0f);
        this.translateScaled(ctx, scaleX, scaleY);
    }
}

