/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.common.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.advancement.AdvancementAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockSnapshotAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventFieldWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventPriority;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.ExplosionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.BasicWrapped;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;

public abstract class EventWrapper<E> {
    private final EventType<?> type;
    private boolean canceled;
    private EventPriority priority;
    private Result result;
    protected E event;

    protected EventWrapper(EventType<?> type) {
        this.type = type;
        this.priority = EventPriority.NORMAL;
    }

    public void cancel() {
    }

    public boolean hasInvokers() {
        return ((EventType)this.type).hasInvokers();
    }

    public boolean hasResult() {
        return ((EventType)this.type).hasResult;
    }

    public <V> V initPrimitive(@Nullable Function<E, V> func, V defVal) {
        return Objects.nonNull(this.event) && Objects.nonNull(func) ? func.apply(this.event) : defVal;
    }

    public boolean isCancelable() {
        return ((EventType)this.type).cancelable;
    }

    public abstract boolean isClient();

    public abstract boolean isCommon();

    public abstract boolean isServer();

    protected abstract void populate();

    public void setEvent(E event) {
        this.event = event;
        this.populate();
    }

    @Nullable
    protected <V> AdvancementAPI<V> wrapAdvancement(@Nullable Function<E, V> advancementFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(advancementFunc) ? WrapperHelper.wrapAdvancement(advancementFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, AdvancementAPI<?>> wrapAdvancementBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapAdvancement(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, AdvancementAPI<?>> wrapAdvancementGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapAdvancement(getter), null);
    }

    @Nullable
    protected <V> BlockAPI<V> wrapBlock(@Nullable Function<E, V> blockFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(blockFunc) ? WrapperHelper.wrapBlock(blockFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, BlockAPI<?>> wrapBlockBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlock(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, BlockAPI<?>> wrapBlockGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlock(getter), null);
    }

    @Nullable
    protected <V> BlockEntityAPI<V, ?> wrapBlockEntity(@Nullable Function<E, V> blockEntityFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(blockEntityFunc) ? WrapperHelper.wrapBlockEntity(blockEntityFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, BlockEntityAPI<?, ?>> wrapBlockEntityBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlockEntity(getter), (event, api) -> setter.accept(event, BasicWrapped.cast(api.getEntity())), null);
    }

    protected <V> EventFieldWrapper<E, BlockEntityAPI<?, ?>> wrapBlockEntityGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapBlockEntity(getter), null);
    }

    @Nullable
    protected <V> EntityAPI<V, ?> wrapEntity(@Nullable Function<E, V> entityFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(entityFunc) ? WrapperHelper.wrapEntity(entityFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, EntityAPI<?, ?>> wrapEntityBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapEntity(getter), (event, api) -> setter.accept(event, BasicWrapped.cast(api.getEntity())), null);
    }

    protected <V> EventFieldWrapper<E, EntityAPI<?, ?>> wrapEntityGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapEntity(getter), null);
    }

    @Nullable
    protected <V> ExplosionAPI<V> wrapExplosion(@Nullable Function<E, V> explosionFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(explosionFunc) ? WrapperHelper.wrapExplosion(explosionFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, ExplosionAPI<?>> wrapExplosionBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapExplosion(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, ExplosionAPI<?>> wrapExplosionGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapExplosion(getter), null);
    }

    @Nullable
    protected <V> ItemAPI<V> wrapItem(@Nullable Function<E, V> itemFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(itemFunc) ? WrapperHelper.wrapItem(itemFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, ItemAPI<?>> wrapItemBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItem(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, ItemAPI<?>> wrapItemGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItem(getter), null);
    }

    @Nullable
    protected <V> ItemStackAPI<V> wrapItemStack(@Nullable Function<E, V> itemStackFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(itemStackFunc) ? WrapperHelper.wrapItemStack(itemStackFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, ItemStackAPI<?>> wrapItemStackBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItemStack(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, ItemStackAPI<?>> wrapItemStackGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapItemStack(getter), null);
    }

    @Nullable
    protected <V> LivingEntityAPI<V, ?> wrapLiving(@Nullable Function<E, V> livingFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(livingFunc) ? WrapperHelper.wrapLivingEntity(livingFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, LivingEntityAPI<?, ?>> wrapLivingBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapLiving(getter), (event, api) -> setter.accept(event, BasicWrapped.cast(api.getEntity())), null);
    }

    protected <V> EventFieldWrapper<E, LivingEntityAPI<?, ?>> wrapLivingGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapLiving(getter), null);
    }

    @Nullable
    protected <V> PlayerAPI<V, ?> wrapPlayer(@Nullable Function<E, V> playerFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(playerFunc) ? WrapperHelper.wrapPlayer(playerFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, PlayerAPI<?, ?>> wrapPlayerBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPlayer(getter), (event, api) -> setter.accept(event, BasicWrapped.cast(api.getEntity())), null);
    }

    protected <V> EventFieldWrapper<E, PlayerAPI<?, ?>> wrapPlayerGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPlayer(getter), null);
    }

    protected <V> BlockPosAPI<?> wrapPos(@Nullable Function<E, V> posFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(posFunc) ? WrapperHelper.wrapPosition(posFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, BlockPosAPI<?>> wrapPosBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPos(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, BlockPosAPI<?>> wrapPosGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapPos(getter), null);
    }

    protected <V> EventFieldWrapper<E, V> wrapGenericBoth(Function<E, V> getter, BiConsumer<E, V> setter, V defVal) {
        return new EventFieldWrapper<E, V>(getter, setter, defVal);
    }

    protected <V> EventFieldWrapper<E, V> wrapGenericGetter(Function<E, V> getter, V defVal) {
        return new EventFieldWrapper<E, V>(getter, defVal);
    }

    @Nullable
    protected <V> BlockSnapshotAPI<V> wrapSnapshot(@Nullable Function<E, V> snapshotFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(snapshotFunc) ? WrapperHelper.wrapSnapshot(snapshotFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, BlockSnapshotAPI<?>> wrapSnapshotBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapSnapshot(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, BlockSnapshotAPI<?>> wrapSnapshotGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapSnapshot(getter), null);
    }

    @Nullable
    protected <V> BlockStateAPI<V> wrapState(@Nullable Function<E, V> stateFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(stateFunc) ? WrapperHelper.wrapState(stateFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, BlockStateAPI<?>> wrapStateBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapState(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, BlockStateAPI<?>> wrapStateGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapState(getter), null);
    }

    @Nullable
    protected <V> WorldAPI<V> wrapWorld(@Nullable Function<E, V> worldFunc) {
        return Objects.nonNull(this.event) && Objects.nonNull(worldFunc) ? WrapperHelper.wrapWorld(worldFunc.apply(this.event)) : null;
    }

    protected <V> EventFieldWrapper<E, WorldAPI<?>> wrapWorldBoth(Function<E, V> getter, BiConsumer<E, V> setter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapWorld(getter), (event, api) -> setter.accept(event, api.unwrap()), null);
    }

    protected <V> EventFieldWrapper<E, WorldAPI<?>> wrapWorldGetter(Function<E, V> getter) {
        return new EventFieldWrapper<Object, Object>(event -> this.wrapWorld(getter), null);
    }

    @Generated
    public EventType<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    @Generated
    public EventPriority getPriority() {
        return this.priority;
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public E getEvent() {
        return this.event;
    }

    @Generated
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Generated
    public void setPriority(EventPriority priority) {
        this.priority = priority;
    }

    @Generated
    public void setResult(Result result) {
        this.result = result;
    }

    public static abstract class EventType<E extends EventWrapper<?>> {
        private final boolean cancelable;
        private final boolean hasResult;
        private final List<Consumer<E>> invokers;
        private E connector;

        protected EventType(boolean cancelable, boolean hasResult) {
            this.cancelable = cancelable;
            this.hasResult = hasResult;
            this.invokers = new ArrayList<Consumer<E>>();
        }

        public void addInvoker(Consumer<E> invoker) {
            if (Objects.nonNull(this.connector)) {
                if (this.invokers.isEmpty()) {
                    EventHelper.registerWrapperImpl(this.connector);
                }
                this.invokers.add(invoker);
            } else {
                TILRef.logError("Cannot add invoker to unconnected event type ({})", this.getClass().getName());
            }
        }

        private boolean hasInvokers() {
            return Objects.nonNull(this.connector) && !this.invokers.isEmpty();
        }

        public <C> void invoke(C event) {
            if (Objects.nonNull(this.connector) && !this.invokers.isEmpty() && this.setWrapperEvent(event, (EventWrapper<?>)this.connector)) {
                for (Consumer<E> invoker : this.invokers) {
                    invoker.accept(this.connector);
                    if (!((EventWrapper)this.connector).isCancelable() || !((EventWrapper)this.connector).isCanceled()) continue;
                    ((EventWrapper)this.connector).cancel();
                    break;
                }
            }
        }

        public abstract boolean isClient();

        public abstract boolean isCommon();

        public abstract boolean isServer();

        public void removeInvoker(Consumer<E> invoker) {
            this.invokers.remove(invoker);
        }

        public <I extends E> void setConnector(I impl) {
            this.connector = impl;
        }

        private <C> boolean setWrapperEvent(C event, EventWrapper<?> wrapper) {
            wrapper.setEvent(event);
            return !((EventWrapper)wrapper).canceled;
        }
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

