/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.DynamicArray;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class ArrayHelper {
    public static <T> T[] append(T[] original, T toAppend, boolean allowDuplicates) {
        if (!allowDuplicates && ArrayHelper.contains(original, toAppend)) {
            return original;
        }
        if (Objects.isNull(toAppend)) {
            TILRef.logError("Cannot append null value to array! Use Misc#expandArray to do that.", new Object[0]);
            return original;
        }
        T[] expanded = ArrayHelper.expand(original, toAppend.getClass());
        expanded[expanded.length - 1] = toAppend;
        return expanded;
    }

    public static <E> boolean contains(E[] array, E value) {
        for (E a : array) {
            if ((!Objects.isNull(a) || !Objects.isNull(value)) && (!Objects.nonNull(a) || !Objects.nonNull(value) || !a.equals(value))) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static int countOccurrences(Object array, Object occurance) {
        int count = 0;
        for (Object element : (Object[])array) {
            if ((!Objects.isNull(element) || !Objects.isNull(occurance)) && !element.equals(occurance)) continue;
            ++count;
        }
        return count;
    }

    @IndirectCallers
    public static <T> T[] create(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, Math.max(length, 0));
    }

    public static <T> T[] createMulti(Class<T> clazz, int[] lengths) {
        if (Objects.isNull(lengths) || lengths.length == 0) {
            return ArrayHelper.create(clazz, 0);
        }
        if (lengths.length == 1) {
            return ArrayHelper.create(clazz, lengths[0]);
        }
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = Math.max(lengths[i], 0);
        }
        try {
            return (Object[])Array.newInstance(clazz, lengths);
        }
        catch (IllegalArgumentException ex) {
            TILRef.logError("Failed to instantiate array of class {} with dimensions {}", clazz, lengths, ex);
            return null;
        }
    }

    @SafeVarargs
    public static <T> T[] deduplicate(T[] array, T ... valuesToIgnore) {
        return ArrayHelper.deduplicate(array, false, null, valuesToIgnore);
    }

    @SafeVarargs
    public static <T> T[] deduplicate(T[] array, boolean replaceValues, T replacement, T ... valuesToIgnore) {
        Boolean[] replacements = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            int next;
            T element = array[i];
            if (ArrayHelper.hasElement(valuesToIgnore, element) || (next = ArrayHelper.findFirstOccurrenceAfter(array, element, i)) == -1) continue;
            replacements[next] = true;
        }
        int first = ArrayHelper.findFirstOccurrence(replacements, true);
        while (first != -1) {
            if (replaceValues) {
                array[first] = replacement;
                replacements[first] = false;
            } else {
                ArrayHelper.removeElement(array, first);
                ArrayHelper.removeElement(replacements, first);
            }
            first = ArrayHelper.findFirstOccurrence(replacements, true);
        }
        return array;
    }

    public static <T> T[] expand(T[] original, Class<T> clazz) {
        int length = Objects.nonNull(original) ? original.length : 0;
        T[] expanded = ArrayHelper.create(clazz, length + 1);
        if (length >= 1) {
            System.arraycopy(original, 0, expanded, 0, length);
        }
        return expanded;
    }

    public static <E> int findFirstOccurrence(E[] array, E element) {
        return ArrayHelper.findFirstOccurrenceAfter(array, element, -1);
    }

    public static <E> int findFirstOccurrenceAfter(E[] array, E element, int index) {
        if (Objects.isNull(array) || array.length == 0) {
            return -1;
        }
        for (int i = index + 1; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    @IndirectCallers
    public static boolean[] fixBoxedPrimitive(Boolean ... boxed) {
        boolean[] primitive = new boolean[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    @IndirectCallers
    public static byte[] fixBoxedPrimitive(Byte ... boxed) {
        byte[] primitive = new byte[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    @IndirectCallers
    public static char[] fixBoxedPrimitive(Character ... boxed) {
        char[] primitive = new char[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i].charValue();
        }
        return primitive;
    }

    @IndirectCallers
    public static double[] fixBoxedPrimitive(Double ... boxed) {
        double[] primitive = new double[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    @IndirectCallers
    public static float[] fixBoxedPrimitive(Float ... boxed) {
        float[] primitive = new float[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i].floatValue();
        }
        return primitive;
    }

    @IndirectCallers
    public static int[] fixBoxedPrimitive(Integer ... boxed) {
        int[] primitive = new int[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    @IndirectCallers
    public static long[] fixBoxedPrimitive(Long ... boxed) {
        long[] primitive = new long[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    @IndirectCallers
    public static short[] fixBoxedPrimitive(Short ... boxed) {
        short[] primitive = new short[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            primitive[i] = boxed[i];
        }
        return primitive;
    }

    public static <E> E[] fixObjParsed(Object[] array, Class<?> fixAs) {
        DynamicArray base = new DynamicArray(-1, fixAs);
        base = new DynamicArray(base.getBracketCount() - 1, base.getBaseClass());
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = Misc.getFixedObject(array[i2], base.getTypeClass());
        }
        return (Object[])ArrayHelper.supplyArrayCreation(base.getTypeClass(), array.length, i -> array[i]);
    }

    public static <E> E[] forEach(E[] array, BiConsumer<E, Integer> consumer) {
        if (Objects.nonNull(array)) {
            for (int i = 0; i < array.length; ++i) {
                consumer.accept(array[i], i);
            }
        }
        return array;
    }

    public static <T> T[] fromIterable(Iterable<?> itr, Class<T> clazz) {
        int[] lengths = IterableHelper.getLengths(itr);
        return ArrayHelper.fromIterator(itr.iterator(), clazz, ArrayHelper.createMulti(clazz, lengths));
    }

    public static <T> T[] fromIterator(Iterator<?> itr, Class<T> clazz) {
        int[] lengths = IterableHelper.getLengths(itr);
        return ArrayHelper.fromIterator(itr, clazz, ArrayHelper.createMulti(clazz, lengths));
    }

    private static <T> Object[] fromIterator(Iterator<?> itr, Class<T> clazz, Object[] array) {
        int i = 0;
        while (itr.hasNext()) {
            Object element = itr.next();
            array[i] = element instanceof Iterable ? ArrayHelper.fromIterable((Iterable)element, clazz) : (element instanceof Iterator ? ArrayHelper.fromIterator((Iterator)element, clazz) : element);
            ++i;
        }
        return array;
    }

    public static <E> boolean hasElement(E[] array, E element) {
        for (E e : array) {
            if (e != element) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static <E> boolean hasElementAfter(E[] array, E element, int index) {
        for (int i = index + 1; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static <E> boolean hasElementExceptAt(E[] array, E element, int index) {
        for (int i = 0; i < array.length; ++i) {
            if (i == index || array[i] != element) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static int[] intRange(int min, int max) {
        return ArrayHelper.intRange(min, max, true);
    }

    public static int[] intRange(int min, int max, boolean inclusive) {
        int length = Math.abs(max - min) + 1;
        if (!inclusive) {
            length -= 2;
        }
        if (length <= 0) {
            return new int[0];
        }
        min = Math.min(min, max);
        if (!inclusive) {
            ++min;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = min + i;
        }
        return array;
    }

    public static <E> boolean isEmpty(E[] array) {
        return Objects.isNull(array) || array.length == 0;
    }

    public static <E> boolean isNotEmpty(E[] array) {
        return !ArrayHelper.isEmpty(array);
    }

    public static <E, T> T[] mapTo(E[] array, Class<T> clazz, Function<E, T> remapper) {
        if (Objects.isNull(array)) {
            return null;
        }
        int length = array.length;
        T[] remapped = ArrayHelper.create(clazz, length);
        for (int i = 0; i < length; ++i) {
            remapped[i] = remapper.apply(array[i]);
        }
        return remapped;
    }

    public static boolean matches(@Nullable Object[] array, @Nullable Object other) {
        if (other instanceof Object[]) {
            return ArrayHelper.matchesArray(array, (Object[])other);
        }
        if (other instanceof Iterable) {
            return IterableHelper.matchesArray((Iterable)other, array);
        }
        if (other instanceof Iterator) {
            return IterableHelper.matchesArray((Iterator)other, array);
        }
        if (Objects.isNull(array)) {
            return Objects.isNull(other);
        }
        if (Objects.isNull(other)) {
            return false;
        }
        return array.length == 1 && GenericUtils.matches(array[0], other);
    }

    public static boolean matchesArray(@Nullable Object[] array, @Nullable Object[] other) {
        if (Objects.isNull(array)) {
            return Objects.isNull(other);
        }
        if (Objects.isNull(other) || array.length != other.length) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (GenericUtils.matches(array[i], other[i])) continue;
            return false;
        }
        return true;
    }

    public static <E> E[] removeAllOccurrencesAfter(E[] array, E element, int after) {
        if (Objects.nonNull(array) && after < array.length - 1) {
            int index = ArrayHelper.findFirstOccurrenceAfter(array, element, after);
            while (index != -1) {
                array = ArrayHelper.removeElement(array, index);
                index = ArrayHelper.findFirstOccurrence(array, element);
            }
        }
        return array;
    }

    public static <E> E[] removeAllOccurrencesOf(E[] array, E element) {
        return ArrayHelper.removeAllOccurrencesAfter(array, element, -1);
    }

    public static <E> E[] removeElement(E[] array, int index) {
        if (Objects.nonNull(array) && array.length > 0) {
            int length = array.length;
            for (int i = index; i < length - 1; ++i) {
                array[i] = array[i + 1];
            }
            ?[] removed = ArrayHelper.create(array.getClass().getComponentType(), length - 1);
            System.arraycopy(array, 0, removed, 0, length - 1);
            array = removed;
        }
        return array;
    }

    public static <E> E[] removeMatching(E[] array, E toMatch, Function<E, Boolean> matcher) {
        if (ArrayHelper.isNotEmpty(array)) {
            ArrayList<E> copy = new ArrayList<E>();
            for (E element : array) {
                if (matcher.apply(element).booleanValue()) continue;
                copy.add(element);
            }
            if (copy.size() < array.length) {
                array = ArrayHelper.fromIterable(copy, toMatch.getClass());
            }
        }
        return array;
    }

    @IndirectCallers
    public static <E> void supplyArray(E[] array, Function<Integer, E> func) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = func.apply(i);
        }
    }

    @IndirectCallers
    public static <E, F> void supplyArray(E[] array, F thing, BiFunction<F, Integer, E> func) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = func.apply(thing, i);
        }
    }

    public static <E> Object supplyArrayCreation(Class<E> clazz, int size, Function<Integer, ?> func) {
        E[] array = ArrayHelper.create(clazz, size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = func.apply(i);
        }
        return array;
    }

    @IndirectCallers
    public static <E, F> Object supplyArrayCreation(Class<E> clazz, int size, F thing, BiFunction<F, Integer, ?> func) {
        E[] array = ArrayHelper.create(clazz, size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = func.apply(thing, i);
        }
        return array;
    }
}

