/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionCoreModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.burningwave.core.assembler.StaticComponentContainer;

public abstract class CoreAPI {
    static final String JAVA_VERSION = System.getProperty("java.version");
    public static Object INSTANCE;
    static String BINARY;
    static int javaVersionCache;
    protected final GameVersion version;
    protected final ModLoader modLoader;
    protected final Side side;
    private final Map<MultiVersionModCandidate, Collection<MultiVersionCoreModInfo>> coreInfo;
    private final Set<CoreEntryPoint> coreInstances;
    private final Map<MultiVersionModCandidate, Collection<MultiVersionModInfo>> modInfo;
    private final Set<String> injectedMods;

    @Nullable
    public static Object findInstance(ClassLoader loader) {
        Class<?> coreClass = ClassHelper.findClass(BINARY, loader);
        if (Objects.isNull(coreClass)) {
            TILRef.logError("Unable to get CoreAPI class from {}", loader);
            return null;
        }
        return ReflectionHelper.invokeStaticMethod(coreClass, "getInstance", new Class[0], new Object[0]);
    }

    @IndirectCallers
    public static String findLoadingClass() {
        return String.valueOf(CoreAPI.findInstance(CoreAPI.class.getClassLoader())).split(" ")[0];
    }

    public static String findLoadingClass(ModLoader loader, String versionStr) {
        TILDev.logDebug("Parsing version from {}", versionStr);
        GameVersion version = CoreAPI.parseVersion(versionStr);
        TILRef.logInfo("Parsed version is {}", new Object[]{version});
        if (Objects.isNull((Object)version)) {
            throw new RuntimeException("Failed to parse " + (Object)((Object)loader) + " game version from " + versionStr);
        }
        String versionName = version.getName().replace('.', '_');
        return version.getPackageName(loader, "mods.thecomputerizer.theimpossiblelibrary") + ".core.TILCore" + (Object)((Object)loader) + versionName;
    }

    @IndirectCallers
    public static GameVersion gameVersion() {
        return CoreAPI.getInstance().getVersion();
    }

    public static CoreAPI getInstance() {
        return CoreAPI.getInstance(CoreAPI.class.getClassLoader());
    }

    public static CoreAPI getInstance(ClassLoader loader) {
        if (Objects.isNull(INSTANCE)) {
            TILRef.logDebug("Attempting to get CoreAPI instance that does not exist yet on loader {}", loader);
            if (Objects.nonNull(loader)) {
                ClassHelper.checkBurningWaveInit();
                CoreAPI.syncInstanceClassLoader(loader);
            } else {
                TILRef.logError("Tried to get CoreAPI instance on null ClassLoader??", new Object[0]);
            }
        }
        return (CoreAPI)INSTANCE;
    }

    public static Object invoke(Object instance, String name) {
        return CoreAPI.invoke(instance, name, new Class[0], new Object[0]);
    }

    public static Object invoke(Object instance, String name, Class<?>[] argClasses, Object ... args) {
        Class<?> clazz = Objects.nonNull(instance) ? instance.getClass() : CoreAPI.findInstance(Thread.currentThread().getContextClassLoader()).getClass();
        return ReflectionHelper.invokeMethod(clazz, name, instance, argClasses, args);
    }

    public static boolean isClient() {
        return CoreAPI.getInstance().getSide().isClient();
    }

    public static boolean isFabric() {
        return CoreAPI.getInstance().getModLoader() == ModLoader.FABRIC;
    }

    public static boolean isForge() {
        return CoreAPI.getInstance().getModLoader() == ModLoader.FORGE;
    }

    public static boolean isJava8() {
        return CoreAPI.javaVersion() == 8;
    }

    @IndirectCallers
    public static boolean isJava17() {
        return CoreAPI.javaVersion() == 17;
    }

    @IndirectCallers
    public static boolean isJava17OrLater() {
        return CoreAPI.javaVersion() >= 17;
    }

    @IndirectCallers
    public static boolean isJava21() {
        return CoreAPI.javaVersion() == 21;
    }

    @IndirectCallers
    public static boolean isJava21OrLater() {
        return CoreAPI.javaVersion() >= 21;
    }

    public static boolean isLegacy() {
        return CoreAPI.getInstance().getModLoader() == ModLoader.LEGACY;
    }

    public static boolean isNamedEnv() {
        if (TILDev.DEV) {
            return true;
        }
        GameVersion version = CoreAPI.getInstance().getVersion();
        return CoreAPI.isNeoforge() && version != GameVersion.V20_1 || CoreAPI.isForge() && (version == GameVersion.V20_4 || version == GameVersion.V20_6 || version == GameVersion.V21_1);
    }

    public static boolean isNeoforge() {
        return CoreAPI.getInstance().getModLoader() == ModLoader.NEOFORGE;
    }

    public static boolean isServer() {
        return CoreAPI.getInstance().getSide().isServer();
    }

    public static boolean isSrgEnv() {
        CoreAPI core = CoreAPI.getInstance();
        switch (core.getModLoader()) {
            case FORGE: 
            case LEGACY: {
                return true;
            }
            case NEOFORGE: {
                return core.getVersion() == GameVersion.V20_1;
            }
        }
        return false;
    }

    public static boolean isV12() {
        return CoreAPI.getInstance().getVersion().isV12();
    }

    public static boolean isV16() {
        return CoreAPI.getInstance().getVersion().isV16();
    }

    public static boolean isV18() {
        return CoreAPI.getInstance().getVersion().isV18();
    }

    public static boolean isV19() {
        return CoreAPI.getInstance().getVersion().isV19();
    }

    @IndirectCallers
    public static boolean isV19_2() {
        return CoreAPI.getInstance().getVersion().isV19_2();
    }

    public static boolean isV19_4() {
        return CoreAPI.getInstance().getVersion().isV19_4();
    }

    public static boolean isV20() {
        return CoreAPI.getInstance().getVersion().isV20();
    }

    @IndirectCallers
    public static boolean isV20_1() {
        return CoreAPI.getInstance().getVersion().isV20_1();
    }

    @IndirectCallers
    public static boolean isV20_4() {
        return CoreAPI.getInstance().getVersion().isV20_4();
    }

    @IndirectCallers
    public static boolean isV20_6() {
        return CoreAPI.getInstance().getVersion().isV20_6();
    }

    public static boolean isV21() {
        return CoreAPI.getInstance().getVersion().isV21();
    }

    @IndirectCallers
    public static boolean isV21_1() {
        return CoreAPI.getInstance().getVersion().isV21_1();
    }

    @IndirectCallers
    public static boolean isVersionAtLeast(@Nullable String versionStr) {
        return CoreAPI.getInstance().getVersion().isAtLeast(versionStr);
    }

    @IndirectCallers
    public static boolean isVersionAtLeast(GameVersion version) {
        return CoreAPI.getInstance().getVersion().isAtLeast(version);
    }

    @IndirectCallers
    public static boolean isVersionAtMost(@Nullable String versionStr) {
        return CoreAPI.getInstance().getVersion().isAtMost(versionStr);
    }

    @IndirectCallers
    public static boolean isVersionAtMost(GameVersion version) {
        return CoreAPI.getInstance().getVersion().isAtMost(version);
    }

    @IndirectCallers
    public static boolean isVersionGreaterThan(@Nullable String versionStr) {
        return CoreAPI.getInstance().getVersion().isGreaterThan(versionStr);
    }

    @IndirectCallers
    public static boolean isVersionGreaterThan(GameVersion version) {
        return CoreAPI.getInstance().getVersion().isGreaterThan(version);
    }

    @IndirectCallers
    public static boolean isVersionLessThan(@Nullable String versionStr) {
        return CoreAPI.getInstance().getVersion().isLessThan(versionStr);
    }

    @IndirectCallers
    public static boolean isVersionLessThan(GameVersion version) {
        return CoreAPI.getInstance().getVersion().isLessThan(version);
    }

    public static int javaVersion() {
        if (javaVersionCache > 0) {
            return javaVersionCache;
        }
        TILRef.logInfo("Parsing java version from {}", JAVA_VERSION);
        if (JAVA_VERSION.startsWith("1.")) {
            return 8;
        }
        String majorVersion = JAVA_VERSION.split("\\.")[0].split("_")[0];
        try {
            javaVersionCache = Integer.parseInt(majorVersion);
        }
        catch (Exception ex) {
            TILRef.logError("Failed to parse java version from {} (split from {})", majorVersion, JAVA_VERSION, ex);
            javaVersionCache = 17;
        }
        return javaVersionCache;
    }

    @IndirectCallers
    public static Object parseFrom(Object unparsed, ClassLoader loader, boolean java8) {
        try {
            String className = String.valueOf(unparsed).split(" ")[0];
            Class<?> coreClass = java8 ? ClassHelper.findClass(className, loader) : ClassHelper.syncDirect(loader, unparsed.getClass());
            return coreClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NullPointerException ex) {
            TILRef.logError("Unable to parse CoreAPI instance from {}", unparsed, ex);
            return null;
        }
    }

    public static GameVersion parseVersion(String versionStr) {
        return GameVersion.parse(versionStr);
    }

    public static void setInstance(Object instance) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = instance;
        }
    }

    public static void setInstance(Class<?> clazz) {
        if (Objects.nonNull(INSTANCE)) {
            return;
        }
        try {
            INSTANCE = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            TILRef.logError("Failed to set CoreAPI instance using {}", clazz, ex);
        }
    }

    public static void syncInstanceClassLoader(ClassLoader loader) {
        TILRef.logInfo("Trying to sync CoreAPI instance to {} in the context of {}", loader, Thread.currentThread().getContextClassLoader());
        try {
            StaticComponentContainer.ClassLoaders.loadOrDefine(CoreAPI.class, loader);
        }
        catch (Exception ex) {
            TILRef.logFatal("Failed to sync CoreAPI to loader {}", loader);
        }
    }

    protected CoreAPI(GameVersion version, ModLoader loader, Side side) {
        this.version = version;
        this.modLoader = loader;
        this.side = side;
        this.coreInfo = new HashMap<MultiVersionModCandidate, Collection<MultiVersionCoreModInfo>>();
        this.coreInstances = new HashSet<CoreEntryPoint>();
        this.modInfo = new HashMap<MultiVersionModCandidate, Collection<MultiVersionModInfo>>();
        this.injectedMods = new HashSet<String>();
        INSTANCE = this;
        TILRef.logInfo("I am running with `{}` in version `{}` on the `{}` side!", new Object[]{this.modLoader, this.version, this.side});
        TILDev.logDebug("Context ClassLoader is {}", Thread.currentThread().getContextClassLoader());
    }

    public void addSources(Set<String> sources) {
        ClassHelper.addSource(sources, CoreAPI.class);
    }

    public boolean addURLToClassLoader(ClassLoader loader, String url) {
        try {
            return this.addURLToClassLoader(loader, URI.create(url).toURL());
        }
        catch (Exception ex) {
            TILRef.logError("Failed to add url from string ({}) to {}", url, loader, ex);
            return false;
        }
    }

    public abstract boolean addURLToClassLoader(ClassLoader var1, URL var2);

    public abstract CommonEntryPoint getClientVersionHandler();

    public abstract CommonEntryPoint getCommonVersionHandler();

    public abstract CoreEntryPoint getCoreVersionHandler();

    @IndirectCallers
    public <T> T getLaunguageProvider() {
        String name = "TILLanguageProvider" + this.version.name.replace(".", "_");
        return (T)ClassHelper.initialize(ClassHelper.findClass(this.getPackageName("mods.thecomputerizer.theimpossiblelibrary") + ".core." + name), new Object[0]);
    }

    public abstract MultiVersionLoaderAPI getLoader();

    public Map<String, MultiVersionModData> getModData(File root) {
        HashMap<String, MultiVersionModData> map = new HashMap<String, MultiVersionModData>();
        TILRef.logInfo("Parsing data for {} mod candidate(s)", this.modInfo.size());
        for (Map.Entry<MultiVersionModCandidate, Collection<MultiVersionModInfo>> entry : this.modInfo.entrySet()) {
            for (MultiVersionModInfo info : entry.getValue()) {
                map.putIfAbsent(info.getModID(), this.getModData(root, entry.getKey(), info));
            }
        }
        return map;
    }

    public MultiVersionModData getModData(File root, MultiVersionModCandidate candidate, MultiVersionModInfo info) {
        return new MultiVersionModData(root, candidate, this.getModWriter(info));
    }

    @IndirectCallers
    public <T> T getModLocator(ClassLoader loader) {
        String name = "MultiVersionModLocator" + this.version.name.replace(".", "_");
        return (T)ClassHelper.initialize(ClassHelper.findClass(this.getPackageName("mods.thecomputerizer.theimpossiblelibrary") + ".core." + name, loader), this);
    }

    protected abstract ModWriter getModWriter(MultiVersionModInfo var1);

    public String getPackageName(String base) {
        return this.getVersion().getPackageName(this.getModLoader().getPackageName(base));
    }

    public abstract void initAPI();

    public abstract void injectWrittenMod(Class<?> var1, String var2);

    public void instantiateCoreMods() {
        TILRef.logInfo("Instantiating {} coremod candidate(s)", this.coreInfo.size());
        for (Map.Entry<MultiVersionModCandidate, Collection<MultiVersionCoreModInfo>> infos : this.coreInfo.entrySet()) {
            String path = infos.getKey().getFile().getName();
            this.instantiateCoreMods(path, infos.getValue());
        }
    }

    @IndirectCallers
    public void instantiateCoreMods(String containerName, Collection<MultiVersionCoreModInfo> infos) {
        if (infos.isEmpty()) {
            TILRef.logInfo("No coremods to instantiate for {}", new Object[0]);
            return;
        }
        for (MultiVersionCoreModInfo info : infos) {
            CoreEntryPoint core = info.getInstance();
            if (!Objects.nonNull(core)) continue;
            this.coreInstances.add(core);
            TILRef.logInfo("Successfully instantiated coremod for {} as `{}`!", info.getModid(), info.getName());
        }
    }

    public boolean isClientSide() {
        return this.getSide().isClient();
    }

    public boolean isServerSide() {
        return this.getSide().isServer();
    }

    public Collection<?> loadCandidate(MultiVersionModCandidate candidate, MultiVersionLoaderAPI loader, ClassLoader classLoader) {
        ArrayList<MultiVersionCoreModInfo> coreInfo = new ArrayList<MultiVersionCoreModInfo>();
        loader.loadCoreMods(candidate, coreInfo, classLoader);
        if (!coreInfo.isEmpty()) {
            this.coreInfo.put(candidate, coreInfo);
            this.instantiateCoreMods(candidate.getFile().getName(), coreInfo);
        }
        ArrayList<MultiVersionModInfo> modInfos = new ArrayList<MultiVersionModInfo>();
        loader.loadMods(candidate, modInfos, classLoader);
        if (!modInfos.isEmpty()) {
            this.modInfo.put(candidate, modInfos);
        }
        return modInfos;
    }

    public void loadCoreModInfo(ClassLoader classLoader) {
        this.getLoader().loadCoreMods(this.coreInfo, classLoader);
    }

    protected String mapAsBinary(String mapped, boolean asBinary) {
        return asBinary ? mapped.replace('/', '.') : mapped.replace('.', '/');
    }

    public abstract String mapClassName(String var1);

    public String mapClassName(String unmapped, boolean asBinary) {
        return this.mapAsBinary(this.mapClassName(unmapped), asBinary);
    }

    public abstract String mapFieldName(String var1, String var2, String var3);

    public String mapFieldName(String unmappedClass, String unmappedField, String desc, boolean asBinary) {
        return this.mapAsBinary(this.mapFieldName(unmappedClass, unmappedField, desc), asBinary);
    }

    public abstract String mapMethodName(String var1, String var2, String var3);

    @IndirectCallers
    public String mapMethodName(String unmappedClass, String unmappedMethod, String desc, boolean asBinary) {
        return this.mapAsBinary(this.mapMethodName(unmappedMethod, unmappedMethod, desc), asBinary);
    }

    public void modConstructed(Package pkg, String modid, String name, String entryType) {
        if (TextHelper.isBlank(modid) || TextHelper.isBlank(name)) {
            TILRef.logFatal("Found CommonEntryPoint instance in package `{}` with a blank modid or name! Things may break or crash very soon.", pkg);
            return;
        }
        if (this.injectedMods.contains(modid)) {
            TILRef.logInfo("Skipping extra entrypoint for `{}` in `{}`", modid, pkg);
        } else if (this.modConstructed(modid, this.verifyGeneratedClass(pkg, name, entryType))) {
            this.injectedMods.add(modid);
        }
    }

    protected abstract boolean modConstructed(String var1, Class<?> var2);

    @IndirectCallers
    public Map<?, ?> newMap() {
        return new HashMap();
    }

    public String qualify(String str) {
        String qualified = (Object)((Object)this.modLoader) + " " + (Object)((Object)this.version);
        return Objects.isNull(str) || str.isEmpty() ? qualified : str + " " + qualified;
    }

    public String toString() {
        return this.getClass().getName() + " " + (Object)((Object)this.version) + " " + (Object)((Object)this.modLoader) + " " + (Object)((Object)this.side);
    }

    public abstract String unmapClass(String var1);

    protected Class<?> verifyGeneratedClass(Package pkg, String name, String entryType) {
        return ClassHelper.findClassFrom(pkg, name + "Generated" + entryType + "Mod");
    }

    public void writeModContainers(ClassLoader loader) {
        this.getLoader().loadMods(this.modInfo, loader);
    }

    @Generated
    public GameVersion getVersion() {
        return this.version;
    }

    @Generated
    public ModLoader getModLoader() {
        return this.modLoader;
    }

    @Generated
    public Side getSide() {
        return this.side;
    }

    @Generated
    public Map<MultiVersionModCandidate, Collection<MultiVersionCoreModInfo>> getCoreInfo() {
        return this.coreInfo;
    }

    @Generated
    public Set<CoreEntryPoint> getCoreInstances() {
        return this.coreInstances;
    }

    @Generated
    public Map<MultiVersionModCandidate, Collection<MultiVersionModInfo>> getModInfo() {
        return this.modInfo;
    }

    @Generated
    public Set<String> getInjectedMods() {
        return this.injectedMods;
    }

    static {
        BINARY = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    }

    public static enum Side {
        ALL(true, true, true, true),
        DEDICATED_BOTH(true, true, true, false),
        DEDICATED_CLIENT(true, false, true, false),
        DEDICATED_SERVER(false, true, true, false),
        LOGICAL_BOTH(true, true, false, true),
        LOGICAL_CLIENT(true, false, false, true),
        LOGICAL_SERVER(false, true, false, true);

        private final boolean client;
        private final boolean server;
        private final boolean dedicated;
        private final boolean logical;

        private Side(boolean client, boolean server, boolean dedicated, boolean logical) {
            this.client = client;
            this.server = server;
            this.dedicated = dedicated;
            this.logical = logical;
        }

        public String toString() {
            if (this == ALL) {
                return "all";
            }
            String side = this.client && this.server ? "both" : (this.client ? "client" : "server");
            return (this.dedicated ? "dedicated" : "logical") + "_" + side;
        }

        @Generated
        public boolean isClient() {
            return this.client;
        }

        @Generated
        public boolean isServer() {
            return this.server;
        }

        @Generated
        public boolean isDedicated() {
            return this.dedicated;
        }

        @Generated
        public boolean isLogical() {
            return this.logical;
        }
    }

    public static enum ModLoader {
        FABRIC("Fabric"),
        FORGE("Forge"),
        LEGACY("Legacy"),
        NEOFORGE("NeoForge");

        private final String name;
        private final String pkg;

        private ModLoader(String name) {
            this.name = name;
            this.pkg = name.toLowerCase();
        }

        public String getPackageName() {
            return "mods.thecomputerizer.theimpossiblelibrary." + this.pkg;
        }

        public String getPackageName(String base) {
            return base + "." + this.pkg;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }

        public boolean isForge() {
            return this.isLegacyForge() || this.isModernForge();
        }

        public boolean isLegacyForge() {
            return this == LEGACY;
        }

        public boolean isModernForge() {
            return this == FORGE;
        }

        public boolean isNeoForge() {
            return this == NEOFORGE;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum GameVersion {
        V12_2("1.12.2", "v12.m2"),
        V16_5("1.16.5", "v16.m5"),
        V18_2("1.18.2", "v18.m2"),
        V19_2("1.19.2", "v19.m2"),
        V19_4("1.19.4", "v19.m4"),
        V20_1("1.20.1", "v20.m1"),
        V20_4("1.20.4", "v20.m4"),
        V20_6("1.20.6", "v20.m6"),
        V21_1("1.21.1", "v21.m1");

        private static final Map<String, GameVersion> BY_NAME;
        private final String name;
        private final String pkg;

        public static GameVersion parse(String versionStr) {
            if (Objects.isNull(versionStr) || versionStr.isEmpty()) {
                TILRef.logError("Unable to parse version from null or empty string", new Object[0]);
                return null;
            }
            switch (versionStr.split("\\.").length) {
                case 1: {
                    TILRef.logWarn("Attempting to parse version without any '.' separators from {}", versionStr);
                    switch (versionStr) {
                        case "12": {
                            return V12_2;
                        }
                        case "16": {
                            return V16_5;
                        }
                        case "18": {
                            return V18_2;
                        }
                        case "19": {
                            return V19_2;
                        }
                        case "20": {
                            return V20_1;
                        }
                        case "21": {
                            return V21_1;
                        }
                    }
                    return null;
                }
                case 2: {
                    return BY_NAME.get("1." + versionStr);
                }
                case 3: {
                    return BY_NAME.get(versionStr);
                }
            }
            TILRef.logError("Unable to guess version from string with more than 2 '.' characters", new Object[0]);
            return null;
        }

        private GameVersion(String name, String pkg) {
            this.name = name;
            this.pkg = pkg;
        }

        public String getClassExt() {
            return this.getClassExt(true);
        }

        public String getClassExt(boolean includeMinorVersion) {
            String ext = this.name.replace('.', '_');
            return includeMinorVersion ? ext : ext.substring(0, ext.length() - 2);
        }

        public String getPackageName(ModLoader loader, String base) {
            return this.getPackageName(loader.getPackageName(base));
        }

        @IndirectCallers
        public String getPackageName(ModLoader loader, String base, boolean includeMinorVersion) {
            return this.getPackageName(loader.getPackageName(base), includeMinorVersion);
        }

        public String getPackageName(String base) {
            return base + "." + this.getPackageName();
        }

        public String getPackageName(String base, boolean includeMinorVersion) {
            return base + "." + this.getPackageName(includeMinorVersion);
        }

        public String getPackageName() {
            return this.getPackageName(true);
        }

        public String getPackageName(boolean includeMinorVersion) {
            return includeMinorVersion ? this.pkg : this.pkg.substring(0, this.pkg.length() - 3);
        }

        @IndirectCallers
        public boolean isCompatibleFabric() {
            return this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
        }

        public boolean isCompatibleForge() {
            return this.isCompatibleLegacyForge() || this.isCompatibleModernForge();
        }

        public boolean isCompatibleLegacyForge() {
            return this.isV12();
        }

        public boolean isCompatibleModernForge() {
            return this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
        }

        @IndirectCallers
        public boolean isCompatibleNeoForge() {
            return this.isV20() || this.isV21();
        }

        public boolean isV12() {
            return this == V12_2;
        }

        public boolean isV16() {
            return this == V16_5;
        }

        public boolean isV18() {
            return this == V18_2;
        }

        public boolean isV19() {
            return this == V19_2 || this == V19_4;
        }

        public boolean isV19_2() {
            return this == V19_2;
        }

        public boolean isV19_4() {
            return this == V19_2;
        }

        public boolean isV20() {
            return this == V20_1 || this == V20_4 || this == V20_6;
        }

        public boolean isV20_1() {
            return this == V20_1;
        }

        public boolean isV20_4() {
            return this == V20_4;
        }

        public boolean isV20_6() {
            return this == V20_6;
        }

        public boolean isV21() {
            return this == V21_1;
        }

        public boolean isV21_1() {
            return this == V20_1;
        }

        public boolean isAtLeast(@Nullable String versionStr) {
            return this.isAtLeast(GameVersion.parse(versionStr));
        }

        public boolean isAtLeast(@Nullable GameVersion version) {
            if (Objects.isNull((Object)version)) {
                return false;
            }
            switch (version) {
                case V12_2: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
                case V16_5: {
                    return this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
                case V18_2: {
                    return this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
                case V19_2: {
                    return this.isV19() || this.isV20() || this.isV21();
                }
                case V19_4: {
                    return this.isV19_4() || this.isV20() || this.isV21();
                }
                case V20_1: {
                    return this.isV20() || this.isV21();
                }
                case V20_4: {
                    return this.isV20_4() || this.isV20_6() || this.isV21();
                }
                case V20_6: {
                    return this.isV20_6() || this.isV21();
                }
                case V21_1: {
                    return this.isV21();
                }
            }
            return false;
        }

        public boolean isAtMost(@Nullable String versionStr) {
            return this.isAtMost(GameVersion.parse(versionStr));
        }

        public boolean isAtMost(@Nullable GameVersion version) {
            if (Objects.isNull((Object)version)) {
                return false;
            }
            switch (version) {
                case V12_2: {
                    return this.isV12();
                }
                case V16_5: {
                    return this.isV12() || this.isV16();
                }
                case V18_2: {
                    return this.isV12() || this.isV16() || this.isV18();
                }
                case V19_2: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19_2();
                }
                case V19_4: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19();
                }
                case V20_1: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20_1();
                }
                case V20_4: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20_1() || this.isV20_4();
                }
                case V20_6: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20();
                }
                case V21_1: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
            }
            return false;
        }

        public boolean isGreaterThan(@Nullable String versionStr) {
            return this.isGreaterThan(GameVersion.parse(versionStr));
        }

        public boolean isGreaterThan(@Nullable GameVersion version) {
            if (Objects.isNull((Object)version)) {
                return false;
            }
            switch (version) {
                case V12_2: {
                    return this.isV16() || this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
                case V16_5: {
                    return this.isV18() || this.isV19() || this.isV20() || this.isV21();
                }
                case V18_2: {
                    return this.isV19() || this.isV20() || this.isV21();
                }
                case V19_2: {
                    return this.isV19_4() || this.isV20() || this.isV21();
                }
                case V19_4: {
                    return this.isV20() || this.isV21();
                }
                case V20_1: {
                    return this.isV20_4() || this.isV20_6() || this.isV21();
                }
                case V20_4: {
                    return this.isV20_6() || this.isV21();
                }
                case V20_6: {
                    return this.isV21();
                }
            }
            return false;
        }

        public boolean isLessThan(@Nullable String versionStr) {
            return this.isLessThan(GameVersion.parse(versionStr));
        }

        public boolean isLessThan(@Nullable GameVersion version) {
            if (Objects.isNull((Object)version)) {
                return false;
            }
            switch (version) {
                case V16_5: {
                    return this.isV12();
                }
                case V18_2: {
                    return this.isV12() || this.isV16();
                }
                case V19_2: {
                    return this.isV12() || this.isV16() || this.isV18();
                }
                case V19_4: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19_2();
                }
                case V20_1: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19();
                }
                case V20_4: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20_1();
                }
                case V20_6: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20_1() || this.isV20_4();
                }
                case V21_1: {
                    return this.isV12() || this.isV16() || this.isV18() || this.isV19() || this.isV20();
                }
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        public String withClassExt(String className) {
            return className + this.getClassExt();
        }

        public String withClassExt(String className, boolean includeMinorVersion) {
            return className + this.getClassExt(includeMinorVersion);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPkg() {
            return this.pkg;
        }

        static {
            HashMap<String, GameVersion> byName = new HashMap<String, GameVersion>();
            for (GameVersion version : GameVersion.values()) {
                byName.put(version.name, version);
            }
            BY_NAME = Collections.unmodifiableMap(byName);
        }
    }
}

