/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TILDev {
    public static final boolean DEV = Boolean.parseBoolean(System.getProperty("til.dev"));
    private static final String LOADER_FILE = System.getProperty("til.classpath.file", "theimpossiblelibrary-0.4.4.jar");
    private static final Logger LOGGER = DEV ? LogManager.getLogger((String)"TIL DEV") : null;
    public static final Set<String> CLASSPATH_COREMODS = TILDev.parseClasspathMods(System.getProperty("til.classpath.coremods"));
    public static final Set<String> CLASSPATH_MODS = TILDev.parseClasspathMods(System.getProperty("til.classpath.mods"));

    @IndirectCallers
    public static <I> void devConsume(I input, Consumer<I> consumer) {
        if (DEV) {
            consumer.accept(input);
        }
    }

    @Nullable
    @IndirectCallers
    public static <I, R> R devFunc(I input, Function<I, R> function) {
        return DEV ? (R)function.apply(input) : null;
    }

    @Nullable
    @IndirectCallers
    public static <R> R devSupply(Supplier<R> supplier) {
        return DEV ? (R)supplier.get() : null;
    }

    public static boolean isLoader(String fileName) {
        return LOADER_FILE.equals(fileName);
    }

    public static void log(Level level, String msg, Object ... args) {
        if (DEV) {
            LOGGER.log(level, msg, args);
        }
    }

    public static void logDebug(String msg, Object ... args) {
        TILDev.log(Level.DEBUG, msg, args);
    }

    public static void logError(String msg, Object ... args) {
        TILDev.log(Level.ERROR, msg, args);
    }

    public static void logFatal(String msg, Object ... args) {
        TILDev.log(Level.FATAL, msg, args);
    }

    @IndirectCallers
    public static void logFromASM(String msg, Object arg) {
        TILDev.logError(msg, arg);
    }

    public static void logInfo(String msg, Object ... args) {
        TILDev.log(Level.INFO, msg, args);
    }

    public static void logTrace(String msg, Object ... args) {
        TILDev.log(Level.TRACE, msg, args);
    }

    public static void logWarn(String msg, Object ... args) {
        TILDev.log(Level.WARN, msg, args);
    }

    private static Set<String> parseClasspathMods(String mods) {
        String[] split = Objects.nonNull(mods) ? mods.split(";") : null;
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Objects.nonNull(split) ? split : new String[]{})));
    }
}

