/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public class ASMHelper {
    public static void addField(ClassVisitor visitor, int access, String name, Type type, String signature, Object value) {
        visitor.visitField(access, name, type.getDescriptor(), signature, value).visitEnd();
    }

    public static void addSuperConstructor(MethodVisitor constructor, String name, String desc, boolean isInterface) {
        ASMHelper.addSuperConstructor(constructor, name, desc, isInterface, 0);
    }

    public static void addSuperConstructor(MethodVisitor constructor, String name, String desc, boolean isInterface, int parameterCount) {
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        for (int i = 0; i < parameterCount; ++i) {
            constructor.visitVarInsn(25, i + 1);
        }
        ASMHelper.callInit(constructor, name, desc, isInterface);
    }

    public static void addNewInstance(MethodVisitor method, String name, String desc, boolean isInterface) {
        method.visitTypeInsn(187, name);
        method.visitInsn(89);
        ASMHelper.callInit(method, name, desc, isInterface);
    }

    @IndirectCallers
    public static String buildSignature(Type base, Type ... innerTypes) {
        return ClassHelper.signatureDesc(base.getDescriptor(), ArrayHelper.mapTo(innerTypes, String.class, Type::getDescriptor));
    }

    @IndirectCallers
    public static String buildSignature(Type base, String ... innerSignatures) {
        return ClassHelper.signatureDesc(base.getDescriptor(), innerSignatures);
    }

    @IndirectCallers
    public static String buildSignature(Type base, String inner) {
        return ClassHelper.signatureDesc(base.getDescriptor(), inner);
    }

    @IndirectCallers
    public static void call(MethodVisitor method, int opcode, Class<?> clazz, String methodName, String desc) {
        ASMHelper.call(method, opcode, clazz, methodName, desc, false);
    }

    @IndirectCallers
    public static void call(MethodVisitor method, int opcode, String className, String methodName, String desc) {
        ASMHelper.call(method, opcode, className, methodName, desc, false);
    }

    public static void call(MethodVisitor method, int opcode, Class<?> clazz, String methodName, String desc, boolean isInterface) {
        ASMHelper.call(method, opcode, Type.getInternalName(clazz), methodName, desc, isInterface);
    }

    public static void call(MethodVisitor method, int opcode, String className, String methodName, String desc, boolean isInterface) {
        method.visitMethodInsn(opcode, className, methodName, desc, isInterface);
    }

    @IndirectCallers
    public static void callEmpty(MethodVisitor method, int opcode, String name, String methodName) {
        ASMHelper.callEmpty(method, opcode, name, methodName, false);
    }

    public static void callEmpty(MethodVisitor method, int opcode, String name, String methodName, boolean isInterface) {
        ASMHelper.call(method, opcode, name, methodName, ASMRef.EMPTY_METHOD.getDescriptor(), isInterface);
    }

    public static void callInit(MethodVisitor method, String name, String desc, boolean isInterface) {
        ASMHelper.call(method, 183, name, "<init>", desc, isInterface);
    }

    @IndirectCallers
    public static byte[] editClass(String className, Consumer<ClassWriter> consumer) throws IOException {
        return ASMHelper.editClass(new ClassReader(className), consumer);
    }

    @IndirectCallers
    public static byte[] editClass(InputStream stream, Consumer<ClassWriter> consumer) throws IOException {
        return ASMHelper.editClass(new ClassReader(stream), consumer);
    }

    @IndirectCallers
    public static byte[] editClass(byte[] byteCode, Consumer<ClassWriter> consumer) {
        return ASMHelper.editClass(new ClassReader(byteCode), consumer);
    }

    public static byte[] editClass(ClassReader reader, Consumer<ClassWriter> consumer) {
        ClassWriter writer = ASMHelper.getWriter(reader);
        consumer.accept(writer);
        return writer.toByteArray();
    }

    public static AbstractInsnNode findLabel(InsnList code, int ordinal) {
        return ASMHelper.findNodeOrLast(code, LabelNode.class::isInstance, ordinal);
    }

    @Nullable
    public static AbstractInsnNode findNode(InsnList code, Function<AbstractInsnNode, Boolean> compare, int ordinal) {
        int count = 0;
        AbstractInsnNode matched = null;
        for (AbstractInsnNode node : code.toArray()) {
            if (!compare.apply(node).booleanValue()) continue;
            if (count < 0 || count <= ordinal) {
                matched = node;
            }
            if (ordinal >= 0 && ++count > ordinal) break;
        }
        return matched;
    }

    @IndirectCallers
    public static AbstractInsnNode findNodeOrFirst(InsnList code, Function<AbstractInsnNode, Boolean> compare, int ordinal) {
        AbstractInsnNode node = ASMHelper.findNode(code, compare, ordinal);
        return Objects.nonNull(node) ? node : code.getFirst();
    }

    public static AbstractInsnNode findNodeOrLast(InsnList code, Function<AbstractInsnNode, Boolean> compare, int ordinal) {
        AbstractInsnNode node = ASMHelper.findNode(code, compare, ordinal);
        return Objects.nonNull(node) ? node : code.getLast();
    }

    @IndirectCallers
    public static AbstractInsnNode findReturn(InsnList code) {
        return ASMHelper.findReturn(code, -1);
    }

    public static AbstractInsnNode findReturn(InsnList code, int ordinal) {
        return ASMHelper.findNodeOrLast(code, node -> node.getOpcode() == 177, ordinal);
    }

    public static void finishMethod(MethodVisitor visitor) {
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    public static byte[] finishWriting(ClassWriter writer, Type type, boolean debugOutput) {
        return ASMHelper.finishWriting(writer, type.getInternalName(), debugOutput);
    }

    public static byte[] finishWriting(ClassWriter writer, String internalName, boolean debugOutput) {
        writer.visitEnd();
        String name = internalName.replace('/', '.');
        byte[] bytes = writer.toByteArray();
        if (debugOutput) {
            ASMHelper.writeDebugByteCode(name, bytes);
        }
        return bytes;
    }

    @IndirectCallers
    public static AnnotationVisitor getAnnotation(ClassVisitor visitor, Class<?> clazz) {
        return ASMHelper.getAnnotation(visitor, clazz, true);
    }

    @IndirectCallers
    public static AnnotationVisitor getAnnotation(MethodVisitor visitor, Class<?> clazz) {
        return ASMHelper.getAnnotation(visitor, clazz, true);
    }

    public static AnnotationVisitor getAnnotation(ClassVisitor visitor, Type type) {
        return ASMHelper.getAnnotation(visitor, type, true);
    }

    public static AnnotationVisitor getAnnotation(MethodVisitor visitor, Type type) {
        return ASMHelper.getAnnotation(visitor, type, true);
    }

    public static AnnotationVisitor getAnnotation(ClassVisitor visitor, Class<?> clazz, boolean runtime) {
        if (!Annotation.class.isAssignableFrom(clazz)) {
            TILRef.logError("Class is not an annotation `{}`", clazz);
            return null;
        }
        return ASMHelper.getAnnotation(visitor, Type.getType(clazz), runtime);
    }

    public static AnnotationVisitor getAnnotation(MethodVisitor visitor, Class<?> clazz, boolean runtime) {
        if (!Annotation.class.isAssignableFrom(clazz)) {
            TILRef.logError("Class is not an annotation `{}`", clazz);
            return null;
        }
        return ASMHelper.getAnnotation(visitor, Type.getType(clazz), runtime);
    }

    public static AnnotationVisitor getAnnotation(ClassVisitor visitor, Type type, boolean runtime) {
        return visitor.visitAnnotation(type.getDescriptor(), runtime);
    }

    public static AnnotationVisitor getAnnotation(MethodVisitor visitor, Type type, boolean runtime) {
        return visitor.visitAnnotation(type.getDescriptor(), runtime);
    }

    @IndirectCallers
    public static byte[] getBytes(URL url) throws IOException {
        return ASMHelper.getBytes(UrlConnectionFactory.createConnection((URL)url));
    }

    public static byte[] getBytes(URLConnection connection) throws IOException {
        return ASMHelper.getBytes(connection.getInputStream());
    }

    public static byte[] getBytes(InputStream stream) throws IOException {
        return ASMHelper.getBytes(new ClassReader(stream));
    }

    public static byte[] getBytes(ClassReader reader) {
        return ASMHelper.getWriter(reader).toByteArray();
    }

    public static MethodVisitor getClassInit(ClassVisitor visitor) {
        return ASMHelper.getMethod(visitor, 8, "<clinit>", null, new String[0], Type.VOID_TYPE, new Type[0]);
    }

    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", null, new String[0], Type.VOID_TYPE, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", null, new String[0], returnType, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, String signature, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", signature, new String[0], Type.VOID_TYPE, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, String[] exceptions, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", null, exceptions, Type.VOID_TYPE, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, String signature, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", signature, new String[0], returnType, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, String[] exceptions, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", null, exceptions, returnType, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getConstructor(ClassVisitor visitor, int access, String signature, String[] exceptions, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, "<init>", signature, exceptions, returnType, argTypes);
    }

    public static MethodVisitor getMethod(ClassVisitor visitor, int access, String name, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, name, null, new String[0], Type.VOID_TYPE, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getMethod(ClassVisitor visitor, int access, String name, String[] exceptions, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, name, null, exceptions, Type.VOID_TYPE, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getMethod(ClassVisitor visitor, int access, String name, String signature, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, name, signature, new String[0], returnType, argTypes);
    }

    @IndirectCallers
    public static MethodVisitor getMethod(ClassVisitor visitor, int access, String name, String[] exceptions, Type returnType, Type ... argTypes) {
        return ASMHelper.getMethod(visitor, access, name, null, exceptions, returnType, argTypes);
    }

    public static MethodVisitor getMethod(ClassVisitor visitor, int access, String name, String signature, String[] exceptions, Type returnType, Type ... argTypes) {
        return visitor.visitMethod(access, name, Type.getMethodDescriptor((Type)returnType, (Type[])argTypes), signature, exceptions);
    }

    @IndirectCallers
    public static ClassReader getReader(Class<?> clazz) throws IOException {
        return ASMHelper.getReader(Type.getType(clazz));
    }

    public static ClassReader getReader(Type type) throws IOException {
        return new ClassReader(type.getClassName());
    }

    @IndirectCallers
    public static ClassWriter getWriter(int javaVer, int access, Type type) {
        return ASMHelper.getWriter(javaVer, access, type, null, ASMRef.OBJECT_TYPE, new String[0]);
    }

    public static ClassWriter getWriter(int javaVer, int access, Type type, String[] interfaces) {
        return ASMHelper.getWriter(javaVer, access, type, null, ASMRef.OBJECT_TYPE, interfaces);
    }

    @IndirectCallers
    public static ClassWriter getWriter(int javaVer, int access, Type type, String signature, String[] interfaces) {
        return ASMHelper.getWriter(javaVer, access, type, signature, ASMRef.OBJECT_TYPE, interfaces);
    }

    public static ClassWriter getWriter(int javaVer, int access, String internalName, String internalSuperName) {
        return ASMHelper.getWriter(javaVer, access, internalName, null, internalSuperName, new String[0]);
    }

    @IndirectCallers
    public static ClassWriter getWriter(int javaVer, int access, String internalName, Type superType) {
        return ASMHelper.getWriter(javaVer, access, internalName, null, superType.getInternalName(), new String[0]);
    }

    public static ClassWriter getWriter(int javaVer, int access, Type type, Type superType) {
        return ASMHelper.getWriter(javaVer, access, type, null, superType, new String[0]);
    }

    @IndirectCallers
    public static ClassWriter getWriter(int javaVer, int access, Type type, String signature, Type superType) {
        return ASMHelper.getWriter(javaVer, access, type, signature, superType, new String[0]);
    }

    public static ClassWriter getWriter(int javaVer, int access, Type type, String signature, Type superType, String[] interfaces) {
        return ASMHelper.getWriter(javaVer, access, type.getInternalName(), signature, superType.getInternalName(), interfaces);
    }

    public static ClassWriter getWriter(int javaVer, int access, String internalName, String signature, String internalSuperName, String[] interfaces) {
        ClassWriter writer = new ClassWriter(2);
        writer.visit(javaVer, access, internalName, signature, internalSuperName, interfaces);
        return writer;
    }

    public static ClassWriter getWriter(ClassReader reader) {
        return new ClassWriter(reader, 2);
    }

    public static boolean isValidReplacement(AbstractInsnNode node, @Nullable AbstractInsnNode replacement) {
        return Objects.isNull(replacement) || node != replacement;
    }

    public static boolean isValidReplacement(AbstractInsnNode node, @Nullable InsnList replacement) {
        return Objects.isNull(replacement) || replacement.size() != 1 || replacement.get(0) != node;
    }

    public static void replaceNode(InsnList code, Function<AbstractInsnNode, AbstractInsnNode> replacer, int min, int max) {
        HashMap<AbstractInsnNode, AbstractInsnNode> replacements = new HashMap<AbstractInsnNode, AbstractInsnNode>();
        int count = 0;
        for (AbstractInsnNode node : code.toArray()) {
            AbstractInsnNode replacement = replacer.apply(node);
            if (!ASMHelper.isValidReplacement(node, replacement)) continue;
            if (count >= min && (max < 0 || count <= max)) {
                replacements.put(node, replacement);
            }
            if (++count > max && max > 0) break;
        }
        for (Map.Entry entry : replacements.entrySet()) {
            AbstractInsnNode removal = (AbstractInsnNode)entry.getKey();
            int i = code.indexOf(removal);
            code.remove(removal);
            AbstractInsnNode replaceWith = (AbstractInsnNode)entry.getValue();
            if (!Objects.nonNull(replaceWith)) continue;
            code.insertBefore(code.get(i), replaceWith);
        }
    }

    @IndirectCallers
    public static void replaceNodes(InsnList code, Function<AbstractInsnNode, InsnList> replacer, int min, int max) {
        HashMap<AbstractInsnNode, InsnList> replacements = new HashMap<AbstractInsnNode, InsnList>();
        int count = 0;
        for (AbstractInsnNode node : code.toArray()) {
            InsnList replacement = replacer.apply(node);
            if (!ASMHelper.isValidReplacement(node, replacement)) continue;
            if (count >= min && (max < 0 || count <= max)) {
                replacements.put(node, replacement);
            }
            if (++count > max && max > 0) break;
        }
        for (Map.Entry entry : replacements.entrySet()) {
            AbstractInsnNode removal = (AbstractInsnNode)entry.getKey();
            int i = code.indexOf(removal);
            code.remove(removal);
            InsnList replaceWith = (InsnList)entry.getValue();
            if (!Objects.nonNull(replaceWith)) continue;
            code.insertBefore(code.get(i), replaceWith);
        }
    }

    @Nullable
    @IndirectCallers
    public static byte[] toBytes(@Nullable ClassNode node) {
        return ASMHelper.toBytes(node, 0);
    }

    @Nullable
    public static byte[] toBytes(@Nullable ClassNode node, int flags) {
        if (Objects.isNull(node)) {
            return null;
        }
        ClassWriter writer = new ClassWriter(flags);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static ClassNode toClassNode(byte[] byteCode) {
        return ASMHelper.toClassNode(byteCode, 0);
    }

    public static ClassNode toClassNode(byte[] byteCode, int parsingOptions) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(byteCode);
        reader.accept((ClassVisitor)node, parsingOptions);
        return node;
    }

    public static void writeByteCodeToFile(File file, byte[] bytes) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            stream.write(bytes);
            TILDev.logTrace("Successfully dumped class bytes to `{}`", file);
        }
        catch (IOException ex) {
            TILRef.logError("Failed to print class file to `{}`", file);
        }
    }

    public static void writeDebugByteCode(String classpath, byte[] bytes) {
        File debugDir = new File("impossible_data", "asm_debug");
        String filepath = classpath.replace('.', File.separatorChar) + ".class";
        File writeTo = FileHelper.get(new File(debugDir, filepath), true);
        ASMHelper.writeByteCodeToFile(writeTo, bytes);
        if (Objects.nonNull(writeTo)) {
            TILRef.logInfo("Wrote bytecode for {} to {}", classpath, writeTo.getAbsolutePath());
        }
    }
}

