/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.AnnotationPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.BytecodePrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;

public class FieldPrinter
extends FieldVisitor
implements BytecodePrinter {
    protected final ClassPrinter parent;
    protected final String access;
    protected final String name;
    protected final String typeName;
    protected final Object value;
    protected AnnotationPrinter[] annotations;

    public FieldPrinter(int api, ClassPrinter parent, int access, String name, String typeName, Object value) {
        super(api);
        this.parent = parent;
        this.access = ClassPrinter.parseAccess(access);
        this.name = name;
        this.typeName = ClassPrinter.getClassPath(typeName);
        this.value = value;
    }

    protected void getAnnotationLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.annotations)) {
            for (AnnotationPrinter annotation : this.annotations) {
                annotation.toLines(lines, tabs);
            }
        }
    }

    protected AnnotationPrinter parseAnnotation(String desc) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(desc));
        this.parent.addImport(pkgPair.getKey());
        AnnotationPrinter printer = new AnnotationPrinter(this.api, this.parent, pkgPair.getValue());
        this.annotations = ArrayHelper.append(this.annotations, printer, false);
        return printer;
    }

    @Override
    public void toLines(Collection<String> lines, int tabs) {
        this.getAnnotationLines(lines, tabs);
        lines.add(TextHelper.withTabs(this.access + " " + this.typeName + " " + this.name + (Objects.nonNull(this.value) ? " = " + this.value : "") + ";", tabs));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.parseAnnotation(desc);
    }
}

