/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.loader;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionCoreMod;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionMod;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionCoreModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;

public abstract class MultiVersionLoaderAPI {
    protected final CoreAPI parent;
    protected final Set<Path> potentialModPaths;
    protected Collection<MultiVersionModCandidate> candidates;

    protected MultiVersionLoaderAPI(CoreAPI parent) {
        this.parent = parent;
        this.potentialModPaths = new LinkedHashSet<Path>();
    }

    public void addPotentialModPath(Path path) {
        this.potentialModPaths.add(path);
    }

    protected abstract File findCoreModRoot();

    public abstract File findModRoot();

    protected abstract List<File> gatherCandidateModFiles(File var1);

    protected <A extends Annotation> A getAnnotationMatching(Class<?> clazz, Class<A> annotation) {
        String name = annotation.getName();
        Annotation type = null;
        for (Annotation a : clazz.getAnnotations()) {
            if (!name.equals(a.annotationType().getName())) continue;
            type = a;
            break;
        }
        return (A)(Objects.nonNull(type) ? clazz.getAnnotation(type.annotationType()) : null);
    }

    @Nullable
    protected abstract Attributes getFileAttributes(File var1);

    public String getName() {
        return this.parent.qualify("Multiversion Loader");
    }

    private boolean isValidContext(MultiVersionCoreMod mod) {
        return this.isValidSide(mod.client(), mod.server()) && this.isValidLoader(mod.fabric(), mod.forge(), mod.legacy(), mod.neoforge()) && this.isValidVersion(mod.version12(), mod.version16(), mod.version18(), mod.version19(), mod.version20(), mod.version21());
    }

    private boolean isValidContext(MultiVersionMod mod) {
        return this.isValidSide(mod.client(), mod.server()) && this.isValidLoader(mod.fabric(), mod.forge(), mod.legacy(), mod.neoforge()) && this.isValidVersion(mod.version12(), mod.version16(), mod.version18(), mod.version19(), mod.version20(), mod.version21());
    }

    private boolean isValidLoader(boolean fabric, boolean forge, boolean legacy, boolean neoforge) {
        CoreAPI.ModLoader loader = this.parent.getModLoader();
        if (loader.isFabric()) {
            return fabric;
        }
        if (loader.isLegacyForge()) {
            return legacy;
        }
        if (loader.isModernForge()) {
            return forge;
        }
        if (loader.isNeoForge()) {
            return neoforge;
        }
        return false;
    }

    private boolean isValidSide(boolean client, boolean server) {
        CoreAPI.Side side = this.parent.getSide();
        if (side.isClient()) {
            return client;
        }
        if (side.isServer()) {
            return server;
        }
        return false;
    }

    private boolean isValidVersion(boolean v12, boolean v16, boolean v18, boolean v19, boolean v20, boolean v21) {
        CoreAPI.GameVersion version = this.parent.getVersion();
        if (version.isV12()) {
            return v12;
        }
        if (version.isV16()) {
            return v16;
        }
        if (version.isV18()) {
            return v18;
        }
        if (version.isV19()) {
            return v19;
        }
        if (version.isV20()) {
            return v20;
        }
        if (version.isV21()) {
            return v21;
        }
        return false;
    }

    public void loadCoreMods(MultiVersionModCandidate candidate, Collection<MultiVersionCoreModInfo> infos, ClassLoader loader) {
        HashSet<Class<? extends CoreEntryPoint>> classes = new HashSet<Class<? extends CoreEntryPoint>>();
        candidate.findCoreClasses(classes, loader);
        this.loadCoreMods(infos, classes);
    }

    public void loadCoreMods(Collection<MultiVersionCoreModInfo> infos, Collection<Class<? extends CoreEntryPoint>> classes) {
        if (classes.isEmpty()) {
            return;
        }
        for (Class<? extends CoreEntryPoint> clazz : classes) {
            MultiVersionCoreModInfo info = this.loadCoreMod(clazz);
            if (!Objects.nonNull(info)) continue;
            infos.add(info);
            TILDev.logInfo("Successfully loaded coremod `{}` using class `{}`", info.getName(), info.getEntryClass());
        }
    }

    public void loadCoreMods(Map<MultiVersionModCandidate, Collection<MultiVersionCoreModInfo>> infoMap, ClassLoader loader) {
        File root = this.findCoreModRoot();
        TILRef.logInfo("Finding multiversion coremods from root `{}`", root);
        HashMap<MultiVersionModCandidate, Collection<Class<? extends CoreEntryPoint>>> classes = new HashMap<MultiVersionModCandidate, Collection<Class<? extends CoreEntryPoint>>>();
        this.candidates = MultiVersionModFinder.discover(this, root, true);
        for (MultiVersionModCandidate multiVersionModCandidate : this.candidates) {
            multiVersionModCandidate.findCoreClasses(classes, multiVersionModCandidate, loader);
        }
        TILRef.logInfo("{} coremod(s) will attempt to be loaded", classes.size());
        for (Map.Entry entry : classes.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            ArrayList<MultiVersionCoreModInfo> infos = new ArrayList<MultiVersionCoreModInfo>();
            this.loadCoreMods(infos, (Collection)entry.getValue());
            if (infos.isEmpty()) continue;
            infoMap.put(candidate, infos);
        }
    }

    @Nullable
    private MultiVersionCoreModInfo loadCoreMod(Class<? extends CoreEntryPoint> clazz) {
        return this.loadCoreMod(clazz, this.getAnnotationMatching(clazz, MultiVersionCoreMod.class));
    }

    @Nullable
    private MultiVersionCoreModInfo loadCoreMod(Class<? extends CoreEntryPoint> clazz, MultiVersionCoreMod mod) {
        return this.isValidContext(mod) ? MultiVersionCoreModInfo.get(clazz, mod) : null;
    }

    public void loadMods(MultiVersionModCandidate candidate, Collection<MultiVersionModInfo> infos, ClassLoader loader) {
        HashSet<Class<? extends CommonEntryPoint>> classes = new HashSet<Class<? extends CommonEntryPoint>>();
        candidate.findModClasses(classes, loader);
        this.loadMods(candidate, infos, loader, classes);
    }

    public void loadMods(MultiVersionModCandidate candidate, Collection<MultiVersionModInfo> infos, ClassLoader loader, Collection<Class<? extends CommonEntryPoint>> classes) {
        if (classes.isEmpty()) {
            return;
        }
        for (Class<? extends CommonEntryPoint> clazz : classes) {
            MultiVersionModInfo info = this.loadMod(loader, candidate, clazz);
            if (!Objects.nonNull(info)) continue;
            infos.add(info);
            TILDev.logInfo("Successfully preloaded mod `{}` using class `{}`", info.getName(), info.getEntryClass());
        }
    }

    public void loadMods(Map<MultiVersionModCandidate, Collection<MultiVersionModInfo>> infoMap, ClassLoader loader) {
        File root = this.findModRoot();
        TILDev.logInfo("Finding multiversion mods from root `{}`", root);
        HashMap<MultiVersionModCandidate, Collection<Class<? extends CommonEntryPoint>>> classes = new HashMap<MultiVersionModCandidate, Collection<Class<? extends CommonEntryPoint>>>();
        this.candidates = MultiVersionModFinder.discover(this, root, false);
        for (MultiVersionModCandidate multiVersionModCandidate : this.candidates) {
            multiVersionModCandidate.findModClasses(classes, multiVersionModCandidate, loader);
        }
        TILRef.logDebug("{} mods will attempt to be preloaded", classes.size());
        for (Map.Entry entry : classes.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            ArrayList<MultiVersionModInfo> infos = new ArrayList<MultiVersionModInfo>();
            this.loadMods(candidate, infos, loader, (Collection)entry.getValue());
            if (infos.isEmpty()) continue;
            infoMap.put(candidate, infos);
        }
    }

    @Nullable
    private MultiVersionModInfo loadMod(ClassLoader classLoader, MultiVersionModCandidate candidate, Class<? extends CommonEntryPoint> clazz) {
        return this.loadMod(classLoader, candidate, clazz, this.getAnnotationMatching(clazz, MultiVersionMod.class));
    }

    @Nullable
    private MultiVersionModInfo loadMod(ClassLoader classLoader, MultiVersionModCandidate candidate, Class<? extends CommonEntryPoint> clazz, MultiVersionMod mod) {
        return this.isValidContext(mod) ? this.loadModInfo(classLoader, candidate, MultiVersionModInfo.get(clazz, mod)) : null;
    }

    protected abstract MultiVersionModInfo loadModInfo(ClassLoader var1, MultiVersionModCandidate var2, MultiVersionModInfo var3);
}

