/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.WrapperableMappable;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Patterns;

public class IOUtils {
    private static final WrapperableMappable<Class<?>, String> CLASS_ALIASES = new WrapperableMappable(new HashMap(), false);

    public static void addBasicClassAliases(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            IOUtils.addClassAliases(clazz, new Object[0]);
        }
    }

    public static void addClassAliases(Class<?> clazz, Object ... aliasArgs) {
        if (CLASS_ALIASES.containsKey(clazz)) {
            return;
        }
        ArrayList<Object> aliasArgList = new ArrayList<Object>(Arrays.asList(aliasArgs));
        aliasArgList.add(IOUtils.getClassNames(clazz));
        HashSet<String> aliasSet = new HashSet<String>();
        for (Object e : aliasArgList) {
            if (e instanceof String) {
                Misc.lowerCaseAddCollection(aliasSet, (String)e);
                continue;
            }
            if (e instanceof Map.Entry) {
                Map.Entry argPair = (Map.Entry)e;
                Misc.lowerCaseAddCollection(aliasSet, argPair.getKey().toString());
                Misc.lowerCaseAddCollection(aliasSet, argPair.getValue().toString());
                continue;
            }
            if (e instanceof String[]) {
                for (String argArrElement : (String[])e) {
                    Misc.lowerCaseAddCollection(aliasSet, argArrElement);
                }
                continue;
            }
            Misc.lowerCaseAddCollection(aliasSet, e.toString());
        }
        CLASS_ALIASES.putFast(clazz, aliasSet);
        TILRef.logDebug("Added class aliases {} for class {}", TextHelper.compileCollection(aliasSet), clazz);
    }

    public static Class<?> getClassFromAlias(String alias) {
        return CLASS_ALIASES.getKeyOrDefault(w -> Patterns.matchesAny(alias, w), Object.class);
    }

    private static Map.Entry<String, String> getClassNames(Class<?> clazz) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(clazz.getName(), clazz.getSimpleName());
    }

    @IndirectCallers
    public static void lintCollections(Collection<String> ... collections) {
        for (Collection<String> c : collections) {
            c.removeIf(TextHelper::isBlank);
        }
    }

    @IndirectCallers
    public static void loadDefaults() {
        IOUtils.loadDefaultClassAliases();
    }

    private static void loadDefaultClassAliases() {
        TILRef.logInfo("Loading default class aliases", new Object[0]);
        IOUtils.addBasicClassAliases(Byte.class, Character.class, Double.class, Float.class, Long.class, Short.class, String.class, Void.class);
        IOUtils.addClassAliases(Boolean.class, "bool");
        IOUtils.addClassAliases(Character.class, "char");
        IOUtils.addClassAliases(Integer.class, "int");
    }

    @IndirectCallers
    public static <E> E[] mapArray(E[] instances, int[] indices) {
        assert (instances.length > 0 && indices.length > 0);
        Object[] mapped = (Object[])Array.newInstance(instances[0].getClass(), indices.length);
        for (int i = 0; i < indices.length; ++i) {
            mapped[i] = instances[indices[i]];
        }
        return mapped;
    }

    @IndirectCallers
    public static <E> E[][] mapGrid(E[] instances, int[][] indices) {
        assert (instances.length > 0 && indices.length > 0 && indices[0].length > 0);
        Object[][] mapped = (Object[][])Array.newInstance(instances[0].getClass(), indices.length, indices[0].length);
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < indices[j].length; ++j) {
                mapped[i][j] = instances[indices[i][j]];
            }
        }
        return mapped;
    }

    @IndirectCallers
    public static <E> E[][][] mapBox(E[] instances, int[][][] indices) {
        assert (instances.length > 0 && indices.length > 0 && indices[0].length > 0 && indices[0][0].length > 0);
        Object[][][] mapped = (Object[][][])Array.newInstance(instances[0].getClass(), indices.length, indices[0].length, indices[0][0].length);
        for (int i = 0; i < indices.length; ++i) {
            for (int j = 0; j < indices[j].length; ++j) {
                for (int k = 0; k < indices[i][j].length; ++k) {
                    mapped[i][j][k] = instances[indices[i][j][k]];
                }
            }
        }
        return mapped;
    }

    public static String streamToString(InputStream stream) throws IOException {
        int length;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = stream.read(buffer)) != -1) {
            output.write(buffer, 0, length);
        }
        return output.toString(StandardCharsets.UTF_8.name());
    }

    @IndirectCallers
    public static InputStream stringToStream(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }
}

