/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.iterator;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Mappable;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Wrapperable;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public class IterableHelper {
    public static <E> int count(Iterable<E> itr) {
        if (itr instanceof Collection) {
            return ((Collection)itr).size();
        }
        if (itr instanceof Wrapperable) {
            return ((Wrapperable)itr).size();
        }
        if (itr instanceof Mappable) {
            return ((Mappable)itr).size();
        }
        return IterableHelper.count(itr.iterator());
    }

    public static <E> int count(Iterator<E> itr) {
        int count = 0;
        while (itr.hasNext()) {
            ++count;
            itr.next();
        }
        return count;
    }

    public static <E> int countOccurances(E occurance, Iterable<E> itr) {
        return IterableHelper.countOccurances(occurance, itr.iterator());
    }

    public static <E> int countOccurances(E occurance, Iterator<E> itr) {
        int count = 0;
        while (itr.hasNext()) {
            E element = itr.next();
            if ((!Objects.isNull(element) || !Objects.isNull(occurance)) && !element.equals(occurance)) continue;
            ++count;
        }
        return count;
    }

    public static <E> E getElement(int index, Iterable<E> itr) throws IndexOutOfBoundsException {
        if (itr instanceof List) {
            return ((List)itr).get(index);
        }
        if (itr instanceof Wrapperable) {
            return ((Wrapperable)itr).get(index);
        }
        return IterableHelper.getElement(index, itr.iterator());
    }

    public static <E> E getElement(int index, Iterator<E> itr) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Cannot get negative index `" + index + "` for iterator");
        }
        int counter = index;
        while (itr.hasNext()) {
            E element = itr.next();
            if (counter == 0) {
                return element;
            }
            --index;
        }
        throw new IndexOutOfBoundsException("Index `" + index + "` is out of bounds for iterator of size `" + (index - counter) + "`");
    }

    @Nullable
    public static <E> E getElementOrDefault(int index, E defaultVal, Iterable<E> itr) {
        return IterableHelper.getElementOrDefault(index, defaultVal, itr.iterator());
    }

    public static <E> E getElementOrDefault(int index, E defaultVal, Iterator<E> itr) {
        try {
            return IterableHelper.getElement(index, itr);
        }
        catch (IndexOutOfBoundsException ex) {
            TILRef.logError("Failed to get iterator element.", ex);
            return defaultVal;
        }
    }

    @Nullable
    public static <E> E getElementOrNull(int index, Iterable<E> itr) {
        return IterableHelper.getElementOrNull(index, itr.iterator());
    }

    @Nullable
    public static <E> E getElementOrNull(int index, Iterator<E> itr) {
        return IterableHelper.getElementOrDefault(index, null, itr);
    }

    public static int[] getLengths(Iterable<?> itr) {
        return IterableHelper.getLengths(itr.iterator());
    }

    public static int[] getLengths(Iterator<?> itr) {
        return IterableHelper.getLengths(itr, 0, new int[]{0});
    }

    private static int[] getLengths(Iterator<?> itr, int index, int[] lengths) {
        if (index >= lengths.length) {
            int[] lengthsCopy = new int[index + 1];
            System.arraycopy(lengths, 0, lengthsCopy, 0, lengths.length);
            lengths = lengthsCopy;
        }
        int size = 0;
        while (itr.hasNext()) {
            Object element = itr.next();
            if (element instanceof Iterable) {
                lengths = IterableHelper.getLengths(((Iterable)element).iterator(), index + 1, lengths);
            } else if (element instanceof Iterator) {
                lengths = IterableHelper.getLengths((Iterator)element, index + 1, lengths);
            }
            ++size;
        }
        lengths[index] = Math.max(lengths[index], size);
        return lengths;
    }

    public static <K, V> Map.Entry<K, V> getMapEntry(K key, V val) {
        return IterableHelper.getMapEntry(key, val, false);
    }

    public static <K, V> Map.Entry<K, V> getMapEntry(K key, V val, boolean mutable) {
        return mutable ? new AbstractMap.SimpleEntry<K, V>(key, val) : new AbstractMap.SimpleImmutableEntry<K, V>(key, val);
    }

    public static boolean matches(@Nullable Iterable<?> itr, @Nullable Object value) {
        return Objects.isNull(itr) ? Objects.isNull(value) : IterableHelper.matches(itr.iterator(), value);
    }

    public static boolean matches(@Nullable Iterator<?> itr, @Nullable Object value) {
        if (value instanceof Object[]) {
            return IterableHelper.matchesArray(itr, (Object[])value);
        }
        if (value instanceof Iterable) {
            return IterableHelper.matchesItr((Iterable)value, itr);
        }
        if (value instanceof Iterator) {
            return IterableHelper.matchesItr(itr, (Iterator)value);
        }
        if (Objects.isNull(itr)) {
            return Objects.isNull(value);
        }
        if (Objects.isNull(value)) {
            return false;
        }
        boolean potential = false;
        int count = 0;
        while (itr.hasNext()) {
            Object next = itr.next();
            potential = count == 0 && GenericUtils.matches(next, value);
            ++count;
        }
        return potential;
    }

    public static boolean matchesArray(@Nullable Iterable<?> itr, @Nullable Object[] array) {
        return Objects.isNull(itr) ? Objects.isNull(array) : IterableHelper.matchesArray(itr.iterator(), array);
    }

    public static boolean matchesArray(@Nullable Iterator<?> itr, @Nullable Object[] array) {
        if (Objects.isNull(itr)) {
            return Objects.isNull(array);
        }
        if (Objects.isNull(array)) {
            return false;
        }
        boolean potential = true;
        int count = 0;
        while (itr.hasNext()) {
            Object next = itr.next();
            if (array.length <= count) {
                return false;
            }
            if (!GenericUtils.matches(next, array[count])) {
                potential = false;
                break;
            }
            ++count;
        }
        return potential && count == array.length;
    }

    public static boolean matchesItr(@Nullable Iterable<?> itr, @Nullable Iterable<?> other) {
        return Objects.isNull(itr) ? Objects.isNull(other) : IterableHelper.matchesItr(other, itr.iterator());
    }

    public static boolean matchesItr(@Nullable Iterable<?> itr, @Nullable Iterator<?> other) {
        return Objects.isNull(itr) ? Objects.isNull(other) : IterableHelper.matchesItr(itr.iterator(), other);
    }

    public static boolean matchesItr(@Nullable Iterator<?> itr, @Nullable Iterator<?> other) {
        if (Objects.isNull(itr)) {
            return Objects.isNull(other);
        }
        if (Objects.isNull(other)) {
            return false;
        }
        while (itr.hasNext()) {
            Object next = itr.next();
            if (other.hasNext() && GenericUtils.matches(next, other.next())) continue;
            return false;
        }
        return !other.hasNext();
    }
}

