/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Mappable;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageHandlerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageHandlerDefault;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageInfo;

public class NetworkHandler {
    private static final Mappable<?, MessageDirectionInfo<?>> DIRECTION_INFO = Mappable.makeSynchronized(HashMap::new);

    @Nullable
    public static <DIR> MessageDirectionInfo<DIR> getDirectionInfo(DIR dir) {
        return DIRECTION_INFO.get(dir);
    }

    private static <DIR> MessageDirectionInfo<?> getOrInitDirectionInfo(DIR dir) {
        Mappable<?, MessageDirectionInfo<?>> map = DIRECTION_INFO;
        map.putIfAbsent(dir, new MessageDirectionInfo<DIR>(dir));
        return map.get(dir);
    }

    public static void load() {
        if (TILRef.CLIENT_ONLY) {
            return;
        }
        int id = 0;
        if (DIRECTION_INFO.isNotEmpty()) {
            NetworkHelper.getNetwork();
        }
        for (MessageDirectionInfo<?> info : DIRECTION_INFO.values()) {
            NetworkHelper.registerMessage(info, id);
            ++id;
        }
    }

    public static <M extends MessageAPI<?>> void registerMsgToClient(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToClient());
    }

    public static <M extends MessageAPI<?>> void registerMsgToClient(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToClient());
    }

    public static <M extends MessageAPI<?>> void registerMsgToClientLogin(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToClientLogin());
    }

    public static <M extends MessageAPI<?>> void registerMsgToClientLogin(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToClientLogin());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServer(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToServer());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServer(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToServer());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServerLogin(Class<M> clazz, Function<ByteBuf, M> decoder) {
        NetworkHandler.registerMsg(clazz, decoder, NetworkHelper.getDirToServerLogin());
    }

    public static <M extends MessageAPI<?>> void registerMsgToServerLogin(Class<M> clazz, MessageHandlerAPI handler) {
        NetworkHandler.registerMsg(clazz, handler, NetworkHelper.getDirToServerLogin());
    }

    private static <DIR, M extends MessageAPI<?>> void registerMsg(Class<M> clazz, Function<ByteBuf, M> decoder, DIR dir) {
        if (Objects.isNull(dir)) {
            return;
        }
        MessageDirectionInfo<?> dirInfo = NetworkHandler.getOrInitDirectionInfo(dir);
        dirInfo.getInfoSet().add(new MessageInfo<M>(clazz, dirInfo, decoder));
    }

    public static <DIR, M extends MessageAPI<?>> void registerMsg(Class<M> clazz, MessageHandlerAPI handler, DIR dir) {
        if (Objects.isNull(dir)) {
            return;
        }
        MessageDirectionInfo<?> dirInfo = NetworkHandler.getOrInitDirectionInfo(dir);
        dirInfo.getInfoSet().add(new MessageInfo<M>(clazz, dirInfo, handler));
    }

    public static void registerMsgs(MessageInfo<?> ... infos) {
        NetworkHandler.registerMsgs(Arrays.asList(infos));
    }

    public static void registerMsgs(Iterable<MessageInfo<?>> infos) {
        for (MessageInfo<?> info : infos) {
            NetworkHandler.registerMsg(info.getMsgClass(), new MessageHandlerDefault(info::decode), info.getDirectionInfo().getDirection());
        }
    }
}

