/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.network.message;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageInfo;

public class MessageDirectionInfo<DIR> {
    private final DIR direction;
    private final Set<MessageInfo<?>> infoSet;

    public MessageDirectionInfo(DIR direction) {
        this.direction = direction;
        this.infoSet = new HashSet();
    }

    @Nullable
    public <M extends MessageAPI<?>> M decode(Class<?> clazz, ByteBuf buf) {
        try {
            MessageInfo<?> info = this.getMessageInfo(clazz);
            return Objects.nonNull(info) ? (M)info.decode(buf) : null;
        }
        catch (ClassCastException ex) {
            TILRef.logError("Unable to decode message of class `{}`", clazz);
            return null;
        }
    }

    public <M extends MessageAPI<?>> void encode(M message, ByteBuf buf) {
        try {
            MessageInfo<?> info = this.getMessageInfo(message);
            if (Objects.nonNull(info)) {
                info.encode(message, buf);
            }
        }
        catch (ClassCastException ex) {
            TILRef.logError("Unable to encode message of class `{}`", ClassHelper.className(message));
        }
    }

    @Nullable
    public <CTX, M extends MessageAPI<CTX>> MessageAPI<CTX> handle(M message, CTX context) {
        try {
            MessageInfo<?> info = this.getMessageInfo(message);
            return Objects.nonNull(info) ? info.handle(message, context) : null;
        }
        catch (ClassCastException ex) {
            TILRef.logError("Unable to handle message of class `{}`", ClassHelper.className(message));
            return null;
        }
    }

    @Nullable
    public <M extends MessageAPI<?>> MessageInfo<?> getMessageInfo(M message) {
        return this.getMessageInfo(message.getClass());
    }

    @Nullable
    public <M extends MessageAPI<?>> MessageInfo<?> getMessageInfo(Class<M> msgClass) {
        for (MessageInfo<?> info : this.infoSet) {
            if (msgClass != info.getMsgClass()) continue;
            return info;
        }
        TILDev.logInfo("Unable to find registered message for {}!", msgClass);
        return null;
    }

    public boolean isLogin() {
        return Objects.nonNull(this.direction) && NetworkHelper.isDirLogin(this.direction);
    }

    public boolean isToClient() {
        return Objects.nonNull(this.direction) && NetworkHelper.isDirToClient(this.direction);
    }

    public boolean isLoginToClient() {
        return this.isLogin() && this.isToClient();
    }

    public boolean isToServer() {
        return Objects.nonNull(this.direction) && !NetworkHelper.isDirToClient(this.direction);
    }

    public boolean isLoginToServer() {
        return this.isLogin() && this.isToServer();
    }

    @Generated
    public DIR getDirection() {
        return this.direction;
    }

    @Generated
    public Set<MessageInfo<?>> getInfoSet() {
        return this.infoSet;
    }
}

