/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry;

import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHandlerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.block.BlockBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.blockentity.BlockEntityBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.entity.EntityBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.DiscBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemBlockBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ItemBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.ToolBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.sound.SoundBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.CreativeTabBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.BasicWrapped;

public class RegistryHelper {
    static <R> RegistryAPI<R> get(Function<RegistryHandlerAPI, RegistryAPI<?>> getter) {
        return (RegistryAPI)BasicWrapped.cast(getter.apply(RegistryHelper.getHandler()));
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getBiomeRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getBiomeRegistry);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getBlockRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getBlockRegistry);
    }

    public static <R> RegistryAPI<R> getBlockEntityRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getBlockEntityRegistry);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getEffectRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getEffectRegistry);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getEntityRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getEntityRegistry);
    }

    @IndirectCallers
    public static <E> E getEntryIfPresent(ResourceLocationAPI<?> registryKey, ResourceLocationAPI<?> entryKey) {
        return (E)RegistryHelper.getHandler().getEntryIfPresent(registryKey, entryKey);
    }

    public static RegistryHandlerAPI getHandler() {
        return TILRef.getCommonSubAPI(CommonAPI::getRegistryHandler);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getItemRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getItemRegistry);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getPotionRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getPotionRegistry);
    }

    public static RegistryAPI<?> getRegistry(ResourceLocationAPI<?> key) {
        return RegistryHelper.getHandler().getRegistry(key);
    }

    public static RegistryAPI<?> getRegistry(Class<?> type) {
        return RegistryHelper.getHandler().getRegistry(type);
    }

    @IndirectCallers
    public static <R> RegistryAPI<R> getSoundRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getSoundRegistry);
    }

    public static <R> RegistryAPI<R> getStructureRegistry() {
        return RegistryHelper.get(RegistryHandlerAPI::getStructureRegistry);
    }

    @IndirectCallers
    public static BlockBuilderAPI makeBlockBuilder() {
        return RegistryHelper.makeBlockBuilder(null);
    }

    public static BlockBuilderAPI makeBlockBuilder(@Nullable BlockBuilderAPI parent) {
        return RegistryHelper.getHandler().makeBlockBuilder(parent);
    }

    @IndirectCallers
    public static BlockEntityBuilderAPI makeBlockEntityBuilder() {
        return RegistryHelper.makeBlockEntityBuilder(null);
    }

    public static BlockEntityBuilderAPI makeBlockEntityBuilder(@Nullable BlockEntityBuilderAPI parent) {
        return RegistryHelper.getHandler().makeBlockEntityBuilder(parent);
    }

    @IndirectCallers
    public static CreativeTabBuilderAPI makeCreativeTabBuilder() {
        return RegistryHelper.getHandler().makeCreativeTabBuilder();
    }

    @IndirectCallers
    public static DiscBuilderAPI makeDiscBuilder() {
        return RegistryHelper.makeDiscBuilder(null);
    }

    public static DiscBuilderAPI makeDiscBuilder(@Nullable ItemBuilderAPI parent) {
        return RegistryHelper.getHandler().makeDiscBuilder(parent);
    }

    @IndirectCallers
    public static EntityBuilderAPI makeEntityBuilder() {
        return RegistryHelper.makeEntityBuilder(null);
    }

    public static EntityBuilderAPI makeEntityBuilder(@Nullable EntityBuilderAPI parent) {
        return RegistryHelper.getHandler().makeEntityBuilder(parent);
    }

    @IndirectCallers
    public static ItemBlockBuilderAPI makeItemBlockBuilder() {
        return RegistryHelper.makeItemBlockBuilder(null);
    }

    public static ItemBlockBuilderAPI makeItemBlockBuilder(@Nullable ItemBuilderAPI parent) {
        return RegistryHelper.getHandler().makeItemBlockBuilder(parent);
    }

    @IndirectCallers
    public static ItemBuilderAPI makeItemBuilder() {
        return RegistryHelper.makeItemBuilder(null);
    }

    public static ItemBuilderAPI makeItemBuilder(@Nullable ItemBuilderAPI parent) {
        return RegistryHelper.getHandler().makeItemBuilder(parent);
    }

    @IndirectCallers
    public static SoundBuilderAPI makeSoundBuilder() {
        return RegistryHelper.makeSoundBuilder(null);
    }

    public static SoundBuilderAPI makeSoundBuilder(@Nullable SoundBuilderAPI parent) {
        return RegistryHelper.getHandler().makeSoundBuilder(parent);
    }

    @IndirectCallers
    public static ToolBuilderAPI makeToolBuilder(ItemBuilderAPI.ToolType tool) {
        return RegistryHelper.makeToolBuilder(null, tool);
    }

    public static ToolBuilderAPI makeToolBuilder(@Nullable ItemBuilderAPI builder, ItemBuilderAPI.ToolType tool) {
        return RegistryHelper.getHandler().makeToolBuilder(builder, tool);
    }
}

