/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry.block;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.MaterialAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.MaterialColorAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.TILItemUseContext;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.block.BlockBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;

public class BlockProperties {
    private final BlockBuilderAPI.BlockEntityCreator blockEntityCreator;
    private final Map<String, Integer> effectiveTools;
    private final MaterialAPI<?> material;
    private final MaterialColorAPI<?> materialColor;
    private final ResourceLocationAPI<?> registryName;
    private final Function<BlockStateAPI<?>, BlockStateAPI<?>> stateTransformer;
    private final Function<TILItemUseContext, ActionResult> useFunc;

    public BlockProperties(MaterialAPI<?> material, MaterialColorAPI<?> materialColor, Map<String, Integer> effectiveTools, ResourceLocationAPI<?> registryName, @Nullable Function<BlockStateAPI<?>, BlockStateAPI<?>> stateTransformer, @Nullable Function<TILItemUseContext, ActionResult> useFunc, @Nullable BlockBuilderAPI.BlockEntityCreator blockEntityCreator) {
        this.blockEntityCreator = blockEntityCreator;
        this.effectiveTools = effectiveTools;
        this.material = material;
        this.materialColor = materialColor;
        this.registryName = registryName;
        this.stateTransformer = stateTransformer;
        this.useFunc = useFunc;
    }

    public BlockEntityAPI<?, ?> createBlockEntity(WorldAPI<?> world, BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        return Objects.nonNull(this.blockEntityCreator) ? this.blockEntityCreator.create(world, pos, state) : null;
    }

    public BlockStateAPI<?> getDefaultState(BlockStateAPI<?> state) {
        return Objects.nonNull(this.stateTransformer) ? this.stateTransformer.apply(state) : state;
    }

    public ActionResult getUseResult(TILItemUseContext ctx) {
        return Objects.nonNull(this.useFunc) ? this.useFunc.apply(ctx) : ActionResult.PASS;
    }

    public boolean hasStateTransformer() {
        return Objects.nonNull(this.stateTransformer);
    }

    public boolean hasUseResult() {
        return Objects.nonNull(this.useFunc);
    }

    public boolean isBlockEntity() {
        return Objects.nonNull(this.blockEntityCreator);
    }

    @Generated
    public Map<String, Integer> getEffectiveTools() {
        return this.effectiveTools;
    }

    @Generated
    public MaterialAPI<?> getMaterial() {
        return this.material;
    }

    @Generated
    public MaterialColorAPI<?> getMaterialColor() {
        return this.materialColor;
    }

    @Generated
    public ResourceLocationAPI<?> getRegistryName() {
        return this.registryName;
    }
}

