/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape2D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorStreams;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public class Circle
extends Shape2D {
    protected final int resolution;
    protected double radius;
    protected double innerRadius;
    protected double heightRatio;

    public Circle(Vector3 direction, double radius, double innerRadius, double heightRatio) {
        this(direction, radius, innerRadius, heightRatio, 360);
    }

    private Circle(Vector3 direction, double radius, double innerRadius, double heightRatio, int resolution) {
        super(direction);
        this.resolution = resolution;
        if (innerRadius < 0.0) {
            innerRadius = 0.0;
        }
        if (radius < 0.0) {
            radius = 0.0;
        }
        this.radius = Math.max(innerRadius, radius);
        this.innerRadius = Math.min(innerRadius, radius);
        this.heightRatio = heightRatio;
    }

    @Override
    public boolean checkToleranceBounds(Vector3 center, Box bounds) {
        return bounds.expand(this.radius).isInside(this.getCenter(center));
    }

    @Override
    public Circle copy() {
        return this.getScaled(1.0, 1.0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (other.getClass() == Circle.class) {
            Circle circle = (Circle)other;
            return this.sameDirection(circle) && this.resolution == circle.resolution && this.innerRadius == circle.innerRadius && this.radius == circle.radius && this.heightRatio == circle.heightRatio;
        }
        return false;
    }

    public double getAngleDif() {
        return Math.abs(this.getAngleEnd() - this.getAngleStart());
    }

    public double getAngleStart() {
        return -MathHelper.RADIANS_180;
    }

    public double getAngleEnd() {
        return MathHelper.RADIANS_180;
    }

    @Override
    public double getBoundedX(double x, double y, double z) {
        return this.getBoundedXY(x, y).dX();
    }

    @Override
    public Vector2 getBoundedXY(Vector2 xy) {
        return this.getBoundedXY(xy.dX(), xy.dY());
    }

    @Override
    public Vector2 getBoundedXY(double x, double y) {
        double end;
        Vector2 polar = VectorHelper.toPolar(x, y);
        double radius = Math.max(this.innerRadius, Math.min(this.radius, polar.dX()));
        double start = this.getAngleStart();
        if (start > (end = this.getAngleEnd())) {
            double d = end;
            end = start;
            start = d;
        }
        double angle = Math.max(start, Math.min(end, polar.dY()));
        return VectorHelper.toCartesian(radius, angle);
    }

    @Override
    public double getBoundedY(double x, double y, double z) {
        return this.getBoundedXY(x, y).dY();
    }

    @Override
    public Vector3 getCenter(Vector3 center) {
        Vector2 center2D = this.getCenter();
        return new Vector3(center.dX() + center2D.dX(), center.dY() + center2D.dY(), center.dZ());
    }

    public Vector2 getCenter() {
        double radius = MathHelper.getHalfway(this.innerRadius, this.radius);
        double angle = MathHelper.getBoundedAngle(MathHelper.getHalfway(this.getAngleStart(), this.getAngleEnd()));
        return this.withRatio(VectorHelper.toCartesian(radius, angle));
    }

    @Override
    public double getDepth() {
        return 0.0;
    }

    @Override
    public double getHeight() {
        return this.radius * 2.0;
    }

    @Override
    public VectorSuppliers.VectorSupplier2D getOutlineSupplier(Box bounds) {
        double sliceWidth = this.getAngleDif() / (double)this.resolution;
        double start = this.getAngleStart();
        Vector2[] vectors = new Vector2[this.resolution + 1];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = bounds.getBoundedXY(this.withRatio(VectorHelper.toCartesian(this.radius, start + sliceWidth * (double)i)));
        }
        return VectorStreams.get2D(vectors);
    }

    @Override
    public Circle getScaled(double scale) {
        return this.getScaled(scale, scale);
    }

    @Override
    public Circle getScaled(Vector2 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Circle getScaled(double scale, double scaleInner) {
        if (scale <= 0.0) {
            scale = 1.0;
        }
        if (scaleInner <= 0.0) {
            scaleInner = 1.0;
        }
        return new Circle(new Vector3(this.direction), this.radius * scale, this.innerRadius * scaleInner, this.heightRatio);
    }

    @Override
    public Circle getScaled(Vector3 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Circle getScaled(double scaleX, double scaleY, double scaleZ) {
        return this.getScaled(scaleX, scaleY);
    }

    @Override
    public VectorSuppliers.VectorSupplier2D getVectorSupplier(Box bounds) {
        return new CircleStream(this, this.getAngleStart(), this.getAngleDif() / (double)this.resolution, vec -> bounds.getBoundedXY(this.withRatio(VectorHelper.toCartesian(vec))));
    }

    @Override
    public double getWidth() {
        return this.radius * 2.0;
    }

    @Override
    public boolean isInsideRelative(Vector2 pos) {
        if ((pos = VectorHelper.toPolar(pos.dX() / Math.min(this.heightRatio, 1.0), pos.dY() / Math.min(1.0 / this.heightRatio, 1.0))).dX() >= this.innerRadius && pos.dX() < this.radius) {
            double end;
            double start;
            while (pos.dY() < 0.0) {
                pos.setY(pos.dY() + MathHelper.RADIANS_360);
            }
            for (start = this.getAngleStart(); start < 0.0; start += MathHelper.RADIANS_360) {
            }
            for (end = this.getAngleEnd(); end < start; end += MathHelper.RADIANS_360) {
            }
            return pos.dY() >= start && pos.dY() < end;
        }
        return false;
    }

    @Override
    public Vector2 random2D() {
        double radius = RandomHelper.randomDouble(this.innerRadius, this.radius);
        double start = this.getAngleStart();
        double angle = RandomHelper.randomDouble(start, start + this.getAngleDif());
        return this.withRatio(VectorHelper.toCartesian(radius, angle));
    }

    @Override
    public Vector3 random3D() {
        return new Vector3(this.random2D(), (Number)0.0);
    }

    public CircleSlice[] slice(int numSlices) {
        return this.slice(numSlices, 0.0);
    }

    public CircleSlice[] slice(int numSlices, double angleOffset) {
        numSlices = Math.max(numSlices, 1);
        double start = this.getAngleStart();
        double sliceWidth = this.getAngleDif() / (double)numSlices;
        CircleSlice[] slices = new CircleSlice[numSlices];
        for (int i = 0; i < numSlices; ++i) {
            slices[i] = new CircleSlice(new Vector3(this.direction), this.radius, this.innerRadius, this.heightRatio, start + angleOffset + sliceWidth * (double)i, start + angleOffset + sliceWidth * (double)(i + 1));
        }
        return slices;
    }

    protected Vector2 withRatio(Vector2 v) {
        return this.withRatio(v.dX(), v.dY());
    }

    protected Vector2 withRatio(double x, double y) {
        return new Vector2(x * Math.min(this.heightRatio, 1.0), y * Math.min(1.0 / this.heightRatio, 1.0));
    }

    @Generated
    public int getResolution() {
        return this.resolution;
    }

    @Generated
    public double getRadius() {
        return this.radius;
    }

    @Generated
    public double getInnerRadius() {
        return this.innerRadius;
    }

    @Generated
    public double getHeightRatio() {
        return this.heightRatio;
    }

    @Generated
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Generated
    public void setInnerRadius(double innerRadius) {
        this.innerRadius = innerRadius;
    }

    @Generated
    public void setHeightRatio(double heightRatio) {
        this.heightRatio = heightRatio;
    }

    public static final class CircleStream
    implements VectorSuppliers.VectorSupplier2D {
        private final Circle circle;
        private final double startAngle;
        private final double angleDif;
        private final Function<Vector2, Vector2> vertexSupplier;
        private int resolutionCount;
        private int cornerCount;

        public CircleStream(Circle circle, double startAngle, double angleDif, Function<Vector2, Vector2> vertexSupplier) {
            this.circle = circle;
            this.startAngle = startAngle;
            this.angleDif = angleDif;
            this.vertexSupplier = vertexSupplier;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (Objects.isNull(other)) {
                return false;
            }
            if (other.getClass() == CircleStream.class) {
                CircleStream stream = (CircleStream)other;
                return Misc.equalsNullable(this.circle, stream.circle) && this.startAngle == stream.startAngle && this.angleDif == stream.angleDif;
            }
            return false;
        }

        @Override
        public int getIndex() {
            return this.resolutionCount * 4 + this.cornerCount;
        }

        @Override
        public Vector2 getNext() {
            double angle = this.startAngle + this.angleDif * (double)this.resolutionCount;
            if (this.cornerCount == 1 || this.cornerCount == 2) {
                angle += this.angleDif;
            }
            double radius = this.cornerCount <= 1 ? this.circle.radius : this.circle.innerRadius;
            Vector2 next = this.vertexSupplier.apply(new Vector2(radius, angle));
            ++this.cornerCount;
            if (this.cornerCount > 3) {
                this.cornerCount = 0;
                ++this.resolutionCount;
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.resolutionCount < this.circle.resolution;
        }

        @Override
        public void onFinished() {
        }

        @Override
        public void reset() {
            this.resolutionCount = 0;
            this.cornerCount = 0;
        }

        @Generated
        public Circle getCircle() {
            return this.circle;
        }

        @Generated
        public double getStartAngle() {
            return this.startAngle;
        }

        @Generated
        public double getAngleDif() {
            return this.angleDif;
        }

        @Generated
        public Function<Vector2, Vector2> getVertexSupplier() {
            return this.vertexSupplier;
        }

        @Generated
        public int getResolutionCount() {
            return this.resolutionCount;
        }

        @Generated
        public int getCornerCount() {
            return this.cornerCount;
        }
    }

    public static class CircleSlice
    extends Circle {
        protected final double startAngle;
        protected final double endAngle;

        public CircleSlice(Vector3 direction, double radius, double innerRadius, double heightRatio, double startAngle, double endAngle) {
            super(direction, radius, innerRadius, heightRatio, (int)(360.0 * (Math.abs(endAngle - startAngle) / MathHelper.RADIANS_360) + 1.0));
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        @Override
        public boolean checkToleranceBounds(Vector3 center, Box bounds) {
            return bounds.expand((this.radius - this.innerRadius) / 2.0).isInside(this.getCenter(center));
        }

        @Override
        public CircleSlice copy() {
            return this.getScaled(1.0, 1.0, 1.0);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (Objects.isNull(other)) {
                return false;
            }
            if (other.getClass() == CircleSlice.class) {
                CircleSlice slice = (CircleSlice)other;
                return this.sameDirection(slice) && this.resolution == slice.resolution && this.innerRadius == slice.innerRadius && this.radius == slice.radius && this.heightRatio == slice.heightRatio && this.startAngle == slice.startAngle && this.endAngle == slice.endAngle;
            }
            return false;
        }

        @Override
        public double getAngleStart() {
            return this.startAngle;
        }

        @Override
        public double getAngleEnd() {
            return this.endAngle;
        }

        @Override
        public CircleSlice getScaled(double scale) {
            return this.getScaled(scale, scale, 1.0);
        }

        @Override
        public CircleSlice getScaled(Vector2 scale) {
            return this.getScaled(scale.dX(), scale.dY(), 1.0);
        }

        @Override
        public CircleSlice getScaled(double scale, double scaleInner) {
            return this.getScaled(scale, scaleInner, 1.0);
        }

        @Override
        public CircleSlice getScaled(Vector3 scale) {
            return this.getScaled(scale.dX(), scale.dY(), scale.dZ());
        }

        @Override
        public CircleSlice getScaled(double scale, double scaleInner, double scaleAngle) {
            if (scale <= 0.0) {
                scale = 1.0;
            }
            if (scaleInner <= 0.0) {
                scaleInner = 1.0;
            }
            if (scaleAngle <= 0.0) {
                scaleAngle = 1.0;
            }
            double radius = this.radius * scale;
            double innerRadius = this.innerRadius * scaleInner;
            double start = this.getAngleStart();
            return new CircleSlice(new Vector3(this.direction), radius, innerRadius, this.heightRatio, start, start + this.getAngleDif() * scaleAngle);
        }
    }
}

