/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape2D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorStreams;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class Plane
extends Shape2D {
    protected Vector3 worldMin;
    protected Vector3 worldMax;
    protected Vector2 relativeMin;
    protected Vector2 relativeMax;
    protected double width;
    protected double height;

    public static Plane getBounded(Vector3 direction, double width, double height, double heightRatio) {
        width = width * Math.min(heightRatio, 1.0) / 2.0;
        height = height * Math.min(1.0 / heightRatio, 1.0) / 2.0;
        Vector2 min = new Vector2(-width, -height);
        Vector2 max = new Vector2(width, height);
        return new Plane(direction, min, max);
    }

    public static Plane getBoundedAxis(Facing.Axis axis, double width, double height, double heightRatio) {
        return Plane.getBounded(axis.getDirection(), width, height, heightRatio);
    }

    public static Plane[] getOutlinePlanes(Plane outer, Plane inner) {
        return new Plane[]{new Plane(outer.direction, outer.relativeMin, new Vector2(inner.relativeMin.dX(), outer.relativeMax.dY())), new Plane(outer.direction, new Vector2(inner.relativeMin.dX(), outer.relativeMin.dY()), new Vector2(inner.relativeMax.dX(), inner.relativeMin.dY())), new Plane(outer.direction, new Vector2(inner.relativeMin.dX(), inner.relativeMax.dY()), new Vector2(inner.relativeMax.dX(), outer.relativeMax.dY())), new Plane(outer.direction, new Vector2(inner.relativeMax.dX(), outer.relativeMin.dY()), outer.relativeMax)};
    }

    public Plane(Vector3 direction, Vector2 corner, Vector2 oppositeCorner) {
        super(direction);
        this.relativeMin = new Vector2(Math.min(corner.dX(), oppositeCorner.dX()), Math.min(corner.dY(), oppositeCorner.dY()));
        this.relativeMax = new Vector2(Math.max(corner.dX(), oppositeCorner.dX()), Math.max(corner.dY(), oppositeCorner.dY()));
        this.calculateActuals();
        this.calculateSize();
    }

    protected void calculateActuals() {
        this.worldMin = this.getWorldCoordinate(this.relativeMin);
        this.worldMax = this.getWorldCoordinate(this.relativeMax);
    }

    protected void calculateSize() {
        this.width = Math.abs(this.relativeMax.dX() - this.relativeMin.dX());
        this.height = Math.abs(this.relativeMax.dY() - this.relativeMin.dY());
    }

    @Override
    public boolean checkToleranceBounds(Vector3 center, Box bounds) {
        return bounds.expand(this.getWidth() / 2.0, this.getHeight() / 2.0, 0.0).isInside(this.getCenter(center));
    }

    @Override
    public Plane copy() {
        return this.getScaled(1.0, 1.0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (other.getClass() == Plane.class) {
            Plane plane = (Plane)other;
            return this.sameDirection(plane) && Misc.equalsNullable(this.relativeMin, plane.relativeMin) && Misc.equalsNullable(this.relativeMax, plane.relativeMax);
        }
        return false;
    }

    @Override
    public double getDepth() {
        return 0.0;
    }

    @Override
    public double getBoundedX(double x, double y, double z) {
        return Math.max(this.relativeMin.dX(), Math.min(this.relativeMax.dX(), x));
    }

    @Override
    public double getBoundedY(double x, double y, double z) {
        return Math.max(this.relativeMin.dY(), Math.min(this.relativeMax.dY(), y));
    }

    @Override
    public Plane getScaled(double scale) {
        return this.getScaled(scale, scale);
    }

    @Override
    public Plane getScaled(Vector2 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Plane getScaled(double scaleX, double scaleY) {
        if (scaleX <= 0.0) {
            scaleX = 1.0;
        }
        if (scaleY <= 0.0) {
            scaleY = 1.0;
        }
        return new Plane(new Vector3(this.direction), this.relativeMin.mulScalar(scaleX, new Vector2()), this.relativeMax.mulScalar(scaleY, new Vector2()));
    }

    @Override
    public Plane getScaled(Vector3 scale) {
        return this.getScaled(scale.dX(), scale.dY());
    }

    @Override
    public Plane getScaled(double scaleX, double scaleY, double scaleZ) {
        return this.getScaled(scaleX, scaleY);
    }

    @Override
    public VectorSuppliers.VectorSupplier2D getVectorSupplier(Box bounds) {
        return VectorStreams.get2D(bounds.getBoundedXY(this.relativeMin), bounds.getBoundedXY(this.relativeMax.dX(), this.relativeMin.dY()), bounds.getBoundedXY(this.relativeMax), bounds.getBoundedXY(this.relativeMin.dX(), this.relativeMax.dY()));
    }

    @Override
    public boolean isInsideRelative(Vector2 pos) {
        return pos.dX() >= this.relativeMin.dX() && pos.dX() <= this.relativeMax.dX() && pos.dY() >= this.relativeMin.dY() && pos.dY() <= this.relativeMax.dY();
    }

    @Override
    public Vector2 random2D() {
        return VectorHelper.randomD(this.relativeMin, this.relativeMax);
    }

    @Override
    public Vector3 random3D() {
        return new Vector3(this.random2D(), (Number)0.0);
    }

    public void setRelativeMax(double x, double y) {
        this.setRelativeMax(new Vector2(x, y));
    }

    public void setRelativeMax(Vector2 max) {
        this.relativeMax = max;
        this.worldMax = this.getWorldCoordinate(max);
        this.calculateSize();
    }

    public void setRelativeMin(double x, double y) {
        this.setRelativeMin(new Vector2(x, y));
    }

    public void setRelativeMin(Vector2 min) {
        this.relativeMin = min;
        this.worldMin = this.getWorldCoordinate(min);
        this.calculateSize();
    }

    public void setScales(double scaledWidth, double scaledHeight) {
        this.setScaleWidth(scaledWidth);
        this.setScaleHeight(scaledHeight);
    }

    public void setScaleHeight(double scale) {
        double height = this.getHeight() / 2.0;
        double center = this.relativeMin.dY() + height;
        this.setRelativeMin(this.relativeMin.dX(), center - height * scale);
        this.setRelativeMax(this.relativeMax.dX(), center + height * scale);
    }

    public void setScaleWidth(double scale) {
        double width = this.getWidth() / 2.0;
        double center = this.relativeMin.dX() + width;
        this.setRelativeMin(center - width * scale, this.relativeMin.dY());
        this.setRelativeMax(center + width * scale, this.relativeMax.dY());
    }

    @Generated
    public Vector3 getWorldMin() {
        return this.worldMin;
    }

    @Generated
    public Vector3 getWorldMax() {
        return this.worldMax;
    }

    @Generated
    public Vector2 getRelativeMin() {
        return this.relativeMin;
    }

    @Generated
    public Vector2 getRelativeMax() {
        return this.relativeMax;
    }

    @Override
    @Generated
    public double getWidth() {
        return this.width;
    }

    @Override
    @Generated
    public double getHeight() {
        return this.height;
    }
}

