/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Circle;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Plane;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Square;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;

public class ShapeHelper {
    public static Box box(double sideLength) {
        return ShapeHelper.box(-sideLength / 2.0, -sideLength / 2.0, -sideLength / 2.0, sideLength / 2.0, sideLength / 2.0, sideLength / 2.0);
    }

    public static Box box(Vector3 center, double sideLength) {
        return ShapeHelper.box(center.dX() - sideLength / 2.0, center.dY() - sideLength / 2.0, center.dZ() - sideLength / 2.0, center.dX() + sideLength / 2.0, center.dY() + sideLength / 2.0, center.dZ() + sideLength / 2.0);
    }

    public static Box box(Vector3 center, double sideLengthH, double sideLengthV) {
        return ShapeHelper.box(center.dX() - sideLengthH / 2.0, center.dY() - sideLengthV / 2.0, center.dZ() - sideLengthH / 2.0, center.dX() + sideLengthH / 2.0, center.dY() + sideLengthV / 2.0, center.dZ() + sideLengthH / 2.0);
    }

    public static Box box(Vector3 center, double sideLengthX, double sideLengthY, double sideLengthZ) {
        return ShapeHelper.box(center.dX() - sideLengthX / 2.0, center.dY() - sideLengthY / 2.0, center.dZ() - sideLengthZ / 2.0, center.dX() + sideLengthX / 2.0, center.dY() + sideLengthY / 2.0, center.dZ() + sideLengthZ / 2.0);
    }

    public static Box box(Vector3 v1, Vector3 v2) {
        return ShapeHelper.box(v1.dX(), v1.dY(), v1.dZ(), v2.dX(), v2.dY(), v2.dZ());
    }

    public static Box box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new Box(x1, y1, z1, x2, y2, z2);
    }

    public static Circle circle(Facing facing, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(facing), 1.0, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing.Axis axis, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(axis), 1.0, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Vector3 direction, double heightRatio) {
        return ShapeHelper.circle(direction, 1.0, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing facing, double radius, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(facing), radius, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing.Axis axis, double radius, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(axis), radius, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Vector3 direction, double radius, double heightRatio) {
        return ShapeHelper.circle(direction, radius, 0.0, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing facing, Vector2 radii, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(facing), radii.dX(), radii.dY(), heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing.Axis axis, Vector2 radii, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(axis), radii.dX(), radii.dY(), heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Vector3 direction, Vector2 radii, double heightRatio) {
        return ShapeHelper.circle(direction, radii.dX(), radii.dY(), heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing facing, double radius, double innerRadius, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(facing), radius, innerRadius, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing.Axis axis, double radius, double innerRadius, double heightRatio) {
        return ShapeHelper.circle(VectorHelper.from(axis), radius, innerRadius, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Vector3 direction, double radius, double innerRadius, double heightRatio) {
        return ShapeHelper.circle(direction, radius, innerRadius, heightRatio, 0.0, 0.0);
    }

    public static Circle circle(Facing facing, Vector2 radii, double heightRatio, Vector2 angles) {
        return ShapeHelper.circle(VectorHelper.from(facing), radii.dX(), radii.dY(), heightRatio, angles.dX(), angles.dY());
    }

    public static Circle circle(Facing.Axis axis, Vector2 radii, double heightRatio, Vector2 angles) {
        return ShapeHelper.circle(VectorHelper.from(axis), radii.dX(), radii.dY(), heightRatio, angles.dX(), angles.dY());
    }

    public static Circle circle(Vector3 direction, Vector2 radii, double heightRatio, Vector2 angles) {
        return ShapeHelper.circle(direction, radii.dX(), radii.dY(), heightRatio, angles.dX(), angles.dY());
    }

    public static Circle circle(Facing facing, double radius, double innerRadius, double heightRatio, double startAngle, double endAngle) {
        return ShapeHelper.circle(VectorHelper.from(facing), radius, innerRadius, heightRatio, startAngle, endAngle);
    }

    public static Circle circle(Facing.Axis axis, double radius, double innerRadius, double heightRatio, double startAngle, double endAngle) {
        return ShapeHelper.circle(VectorHelper.from(axis), radius, innerRadius, heightRatio, startAngle, endAngle);
    }

    public static Circle circle(Vector3 direction, double radius, double innerRadius, double heightRatio, double startAngle, double endAngle) {
        return startAngle == endAngle || Math.abs(endAngle - startAngle) >= MathHelper.RADIANS_360 ? new Circle(direction, radius, innerRadius, heightRatio) : new Circle.CircleSlice(direction, radius, innerRadius, heightRatio, startAngle, endAngle);
    }

    public static Plane plane(Vector3 corner, Vector3 oppositeCorner, Vector2 relativeCorner, Vector2 relativeOppositeCorner) {
        return new Plane(oppositeCorner.sub(corner), relativeCorner, relativeOppositeCorner);
    }

    public static Plane plane(Vector3 corner, Vector3 oppositeCorner) {
        return new Plane(oppositeCorner.sub(corner), VectorHelper.negInf2D(), VectorHelper.inf2D());
    }

    public static Plane plane(Facing facing) {
        return new Plane(VectorHelper.from(facing), VectorHelper.negInf2D(), VectorHelper.inf2D());
    }

    public static Plane plane(Facing.Axis axis) {
        return new Plane(VectorHelper.from(axis), VectorHelper.negInf2D(), VectorHelper.inf2D());
    }

    public static Plane plane(Vector3 direction) {
        return new Plane(direction, VectorHelper.negInf2D(), VectorHelper.inf2D());
    }

    public static Plane plane(Facing facing, Vector2 corner, Vector2 oppositeCorner) {
        return new Plane(VectorHelper.from(facing), corner, oppositeCorner);
    }

    public static Plane plane(Facing.Axis axis, Vector2 corner, Vector2 oppositeCorner) {
        return new Plane(VectorHelper.from(axis), corner, oppositeCorner);
    }

    public static Plane plane(Vector3 direction, Vector2 corner, Vector2 oppositeCorner) {
        return new Plane(direction, corner, oppositeCorner);
    }

    public static Plane plane(Facing facing, double sideLength) {
        return ShapeHelper.plane(VectorHelper.from(facing), VectorHelper.zero2D(), sideLength, sideLength);
    }

    public static Plane plane(Facing.Axis axis, double sideLength) {
        return ShapeHelper.plane(VectorHelper.from(axis), VectorHelper.zero2D(), sideLength, sideLength);
    }

    public static Plane plane(Vector3 direction, double sideLength) {
        return ShapeHelper.plane(direction, VectorHelper.zero2D(), sideLength, sideLength);
    }

    public static Plane plane(Facing facing, double width, double height) {
        return ShapeHelper.plane(VectorHelper.from(facing), VectorHelper.zero2D(), width, height);
    }

    public static Plane plane(Facing.Axis axis, double width, double height) {
        return ShapeHelper.plane(VectorHelper.from(axis), VectorHelper.zero2D(), width, height);
    }

    public static Plane plane(Vector3 direction, double width, double height) {
        return ShapeHelper.plane(direction, VectorHelper.zero2D(), width, height);
    }

    public static Plane plane(Facing facing, Vector2 center, double width, double height) {
        return ShapeHelper.plane(VectorHelper.from(facing), center, width, height);
    }

    public static Plane plane(Facing.Axis axis, Vector2 center, double width, double height) {
        return ShapeHelper.plane(VectorHelper.from(axis), center, width, height);
    }

    public static Plane plane(Vector3 direction, Vector2 center, double width, double height) {
        return new Plane(direction, center.sub(width / 2.0, height / 2.0, new Vector2()), center.add(width / 2.0, height / 2.0, new Vector2()));
    }

    public static Square square(Facing facing, double heightRatio) {
        return ShapeHelper.square(VectorHelper.from(facing), 1.0, heightRatio);
    }

    public static Square square(Facing.Axis axis, double heightRatio) {
        return ShapeHelper.square(VectorHelper.from(axis), 1.0, heightRatio);
    }

    public static Square square(Vector3 direction, double heightRatio) {
        return ShapeHelper.square(direction, 1.0, heightRatio);
    }

    public static Square square(Facing facing, double sideLength, double heightRatio) {
        return ShapeHelper.square(VectorHelper.from(facing), sideLength, heightRatio);
    }

    public static Square square(Facing.Axis axis, double sideLength, double heightRatio) {
        return ShapeHelper.square(VectorHelper.from(axis), sideLength, heightRatio);
    }

    public static Square square(Vector3 direction, double sideLength, double heightRatio) {
        return new Square(direction, sideLength, heightRatio);
    }
}

