/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector4;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public abstract class VectorStreams<V> {
    protected final V[] vectors;
    protected int index;

    public static VectorStream2D get2D(Iterable<Vector2> vectors) {
        return VectorStreams.get2D(ArrayHelper.fromIterable(vectors, Vector2.class));
    }

    public static VectorStream2D get2D(Vector2 ... vectors) {
        return new VectorStream2D(vectors);
    }

    public static VectorStream3D get3D(Iterable<Vector3> vectors) {
        return VectorStreams.get3D(ArrayHelper.fromIterable(vectors, Vector3.class));
    }

    public static VectorStream3D get3D(Vector3 ... vectors) {
        return new VectorStream3D(vectors);
    }

    public static VectorStream4D get4D(Iterable<Vector4> vectors) {
        return VectorStreams.get4D(ArrayHelper.fromIterable(vectors, Vector4.class));
    }

    public static VectorStream4D get4D(Vector4 ... vectors) {
        return new VectorStream4D(vectors);
    }

    @SafeVarargs
    protected VectorStreams(V ... vectors) {
        this.vectors = Objects.nonNull(vectors) ? vectors : this.getDefault();
        this.index = 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (other instanceof VectorSuppliers) {
            VectorSuppliers vectors = (VectorSuppliers)other;
            int savedIndex = this.getIndex();
            int savedIndexOther = vectors.getIndex();
            this.reset();
            vectors.reset();
            boolean equals = true;
            while (this.hasNext()) {
                V next = this.getNext();
                if (vectors.hasNext() && Misc.equalsNullable(next, vectors.getNext())) continue;
                equals = false;
                break;
            }
            if (this instanceof VectorSuppliers) {
                ((VectorSuppliers)((Object)this)).seekTo(savedIndex);
            }
            vectors.seekTo(savedIndexOther);
            return equals;
        }
        return false;
    }

    protected abstract V[] getDefault();

    public V getNext() {
        V next = this.vectors[this.index];
        ++this.index;
        return next;
    }

    public boolean hasNext() {
        return this.index < this.vectors.length;
    }

    public void onFinished() {
    }

    public void reset() {
        this.index = 0;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    public static class VectorStream4D
    extends VectorStreams<Vector4>
    implements VectorSuppliers.VectorSupplier4D {
        protected VectorStream4D(Vector4 ... vectors) {
            super(vectors);
            for (int i = 0; i < vectors.length; ++i) {
                if (!Objects.isNull(vectors[i])) continue;
                vectors[i] = new Vector4();
            }
        }

        protected Vector4[] getDefault() {
            return new Vector4[0];
        }
    }

    public static class VectorStream3D
    extends VectorStreams<Vector3>
    implements VectorSuppliers.VectorSupplier3D {
        protected VectorStream3D(Vector3 ... vectors) {
            super(vectors);
            for (int i = 0; i < vectors.length; ++i) {
                if (!Objects.isNull(vectors[i])) continue;
                vectors[i] = new Vector3();
            }
        }

        protected Vector3[] getDefault() {
            return new Vector3[0];
        }
    }

    public static class VectorStream2D
    extends VectorStreams<Vector2>
    implements VectorSuppliers.VectorSupplier2D {
        protected VectorStream2D(Vector2 ... vectors) {
            super(vectors);
            for (int i = 0; i < vectors.length; ++i) {
                if (!Objects.isNull(vectors[i])) continue;
                vectors[i] = new Vector2();
            }
        }

        protected Vector2[] getDefault() {
            return new Vector2[0];
        }
    }
}

