/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.tag;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.PrimitiveTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.StringTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagAPI;

public class TagHelper {
    private static final List<String> EXPLANATION = Arrays.asList("Hi!", "This folder is used to store data used by The Impossible Library and other mods that might use it as a dependency. It might also contain some debug files such classes generated via ASM.\n\n", "----------------------------------------------------------------------------------------------------\n\n", "For mod developers:", "\tIf you registered any global data through The Impossible Library, this is where that gets stored! If your modid is here, everything is working as intended.\n", "\tIf you generated a class via ASM that isn't working, you can find a copy of it within the 'asm_debug' \tsubdirectory to help with the debugging process.\n\n", "----------------------------------------------------------------------------------------------------\n\n", "For modpack creators:", "\tThis is where mods that utilize the global data system implemented by The Impossible Library have their data stored!\n", "\tIf you want to quickly reset a specific mod's data, you can try removing the .dat file corresponding to its modid here.\n", "\tThis folder does not need to be exported when packaging a modpack unless the globally saved data for some mod that depends on The Impossible Library is vital to the experience of the pack\n\n", "----------------------------------------------------------------------------------------------------\n\n", "For players:", "\tYou probably don't have to worry about this folder, but if you can tell that a specific mod is breaking and there looks to be a .dat file with its modid, you can try removing it.", "\tThere are no guaruntees whether this will do anything as it depends entirely on the mod.", "\tRemember to report issues!");

    public static File getDataDirectory() {
        return new File("impossible_data");
    }

    public static File getDataDirectory(@Nullable File parent) {
        File file = Objects.nonNull(parent) ? new File(parent, "impossible_data") : TagHelper.getDataDirectory();
        try {
            if (!file.exists()) {
                Files.createDirectory(file.toPath(), new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            TILRef.logError("Failed to create data directory at {}", file, ex);
        }
        return file;
    }

    private static CompoundTagAPI<?> getFileData(File directory, String modid, boolean createIfAbsent) throws IOException {
        File dataFile = FileHelper.get(new File(directory, modid + ".dat").toPath(), createIfAbsent);
        if (dataFile.exists()) {
            return TagHelper.readFromFile(dataFile);
        }
        TILRef.logError("Failed to create data file for {} in directory {}", modid, directory);
        return TagHelper.makeCompoundTag();
    }

    @IndirectCallers
    public static CompoundTagAPI<?> getGlobalData(String modid, boolean createIfAbsent) throws IOException {
        return TagHelper.getFileData(TagHelper.getDataDirectory(), modid, createIfAbsent);
    }

    @IndirectCallers
    public static CompoundTagAPI<?> getOrCreateCompound(CompoundTagAPI<?> tag, String key) throws IOException {
        if (tag.contains(key)) {
            BaseTagAPI<?> baseTag = tag.getTag(key);
            if (!baseTag.isCompound()) {
                throw new IOException("Tried to get existing tag of the wrong type!");
            }
            return baseTag.asCompoundTag();
        }
        CompoundTagAPI<?> compound = TagHelper.makeCompoundTag();
        tag.putTag(key, compound);
        return compound;
    }

    @IndirectCallers
    public static ListTagAPI<?> getOrCreateList(CompoundTagAPI<?> tag, String key) {
        if (tag.contains(key)) {
            return tag.getListTag(key);
        }
        ListTagAPI<?> list = TagHelper.makeListTag();
        tag.putTag(key, list);
        return list;
    }

    public static TagAPI getTagAPI() {
        return TILRef.getCommonSubAPI(CommonAPI::getTag);
    }

    @IndirectCallers
    public static CompoundTagAPI<?> getWorldData(String modid) {
        File dataFile = TagHelper.getWorldDataFile(modid);
        try {
            return Objects.nonNull(dataFile) ? TagHelper.readFromFile(dataFile) : TagHelper.makeCompoundTag();
        }
        catch (IOException ex) {
            TILRef.logError("Failed to get world data for {}", modid);
            return TagHelper.makeCompoundTag();
        }
    }

    public static File getWorldDataFile(String modid) {
        File saveDir = ServerHelper.getSaveDir();
        if (Objects.isNull(saveDir)) {
            TILRef.logError("Failed to get world directory!", new Object[0]);
            return null;
        }
        return new File(TagHelper.getDataDirectory(saveDir), modid + ".dat");
    }

    public static <T> BaseTagAPI<T> getWrapped(T tag) {
        return TagHelper.getTagAPI().getWrapped(tag);
    }

    public static void initGlobal() {
        try {
            TagHelper.writeExplanation(FileHelper.get(TagHelper.getDataDirectory() + "/what_is_this_folder.txt"));
        }
        catch (IOException ex) {
            TILRef.logError("There was an error generating the data folder or explanation file!", ex);
        }
    }

    public static CompoundTagAPI<?> makeCompoundTag() {
        return TagHelper.getTagAPI().makeCompoundTag();
    }

    public static ListTagAPI<?> makeListTag() {
        return TagHelper.getTagAPI().makeListTag();
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(boolean b) {
        return TagHelper.getTagAPI().makePrimitiveTag(b);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(byte b) {
        return TagHelper.getTagAPI().makePrimitiveTag(b);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(double d) {
        return TagHelper.getTagAPI().makePrimitiveTag(d);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(float f) {
        return TagHelper.getTagAPI().makePrimitiveTag(f);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(int i) {
        return TagHelper.getTagAPI().makePrimitiveTag(i);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(long l) {
        return TagHelper.getTagAPI().makePrimitiveTag(l);
    }

    @IndirectCallers
    public static PrimitiveTagAPI<?> makePrimitiveTag(short s) {
        return TagHelper.getTagAPI().makePrimitiveTag(s);
    }

    @IndirectCallers
    public static StringTagAPI<?> makeStringTag(String value) {
        return TagHelper.getTagAPI().makeStringTag(value);
    }

    public static CompoundTagAPI<?> readFromFile(File file) throws IOException {
        return TagHelper.getTagAPI().readFromFile(file);
    }

    private static void writeDataFile(CompoundTagAPI<?> data, File directory, String modid) throws IOException {
        File dataFile = FileHelper.get(directory, modid + ".dat", true);
        if (Objects.nonNull(dataFile)) {
            TagHelper.writeToFile(data, dataFile);
        } else {
            TILRef.logError("Could not write data for {} due to an error in creating the file", modid);
        }
    }

    private static void writeExplanation(File file) throws IOException {
        if (!Objects.nonNull(file)) {
            throw new IOException("Failed to create file!");
        }
        FileHelper.writeLines(file, EXPLANATION, false);
    }

    @IndirectCallers
    public static void writeGlobalData(CompoundTagAPI<?> data, String modid) throws IOException {
        TagHelper.writeDataFile(data, TagHelper.getDataDirectory(), modid);
    }

    public static void writeToFile(CompoundTagAPI<?> data, File file) throws IOException {
        TagHelper.getTagAPI().writeToFile(data, file);
    }

    @IndirectCallers
    public static void writeWorldData(CompoundTagAPI<?> data, String modid) throws IOException {
        File dataFile = TagHelper.getWorldDataFile(modid);
        if (Objects.nonNull(dataFile)) {
            TagHelper.writeToFile(data, dataFile);
        } else {
            TILRef.logError("Failed to write world data for {}! Data file is null", modid);
        }
    }
}

