/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.CommonEventsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;

public class CustomTick {
    private static final List<CustomTick> registeredTickEvents = new ArrayList<CustomTick>();
    private final long millis;
    private final int tps;

    private static void addCustomTick(CustomTick ticker) {
        CommonEventsAPI api = EventHelper.getEventsAPI(false, false);
        if (Objects.isNull(api) || CustomTick.isRegistered(ticker)) {
            return;
        }
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
            try {
                api.postCustomTick(ticker);
            }
            catch (Throwable t) {
                TILRef.logError("Failed to post custom tick", t);
            }
        }, 0L, ticker.millis, TimeUnit.MILLISECONDS);
        registeredTickEvents.add(ticker);
    }

    public static void addCustomTickMillis(long millis) {
        if (millis <= 0L) {
            millis = 1L;
        }
        if (millis > 1000L) {
            millis = 1000L;
        }
        CustomTick.addCustomTick(new CustomTick(millis));
    }

    public static void addCustomTickTPS(int tps) {
        if (tps <= 0) {
            tps = 1;
        }
        if (tps > 1000) {
            tps = 1000;
        }
        CustomTick.addCustomTick(new CustomTick(tps));
    }

    public static boolean isRegistered(CustomTick ticker) {
        return registeredTickEvents.contains(ticker);
    }

    public static boolean isRegistered(long millis) {
        return CustomTick.isRegistered(new CustomTick(millis));
    }

    public static boolean isRegistered(int ticks) {
        return CustomTick.isRegistered(new CustomTick(ticks));
    }

    protected CustomTick(long millis) {
        this(millis, (int)(1000.0 / (double)millis));
    }

    protected CustomTick(int tps) {
        this((long)(1000.0 / (double)tps), tps);
    }

    private CustomTick(long millis, int tps) {
        this.millis = millis;
        this.tps = tps;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomTick) {
            return this.millis == ((CustomTick)obj).millis;
        }
        return obj instanceof Number && (obj instanceof Long ? this.millis == (Long)obj : this.tps == ((Number)obj).intValue());
    }

    public boolean isEquivalentMillis(long millis) {
        return this.millis == millis;
    }

    public boolean isEquivalentTPS(int tps) {
        return this.tps == tps;
    }

    @Generated
    public long getMillis() {
        return this.millis;
    }

    @Generated
    public int getTps() {
        return this.tps;
    }
}

