/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;

public class Misc {
    public static boolean allNonNull(Object ... objects) {
        return !Misc.anyNull(objects);
    }

    public static boolean allNull(Object ... objects) {
        return !Misc.anyNonNull(objects);
    }

    public static boolean anyNonNull(Object ... objects) {
        for (Object obj : objects) {
            if (!Objects.nonNull(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyNull(Object ... objects) {
        for (Object obj : objects) {
            if (!Objects.isNull(obj)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <K, V> V applyNullable(@Nullable K thing, Function<K, V> function) {
        return Objects.isNull(thing) ? null : (V)function.apply(thing);
    }

    public static <K> void consumeNullable(@Nullable K thing, Consumer<K> conumer) {
        if (Objects.nonNull(thing)) {
            conumer.accept(thing);
        }
    }

    public static <T> boolean equalsNullable(@Nullable T thing, @Nullable Object other) {
        return Objects.isNull(thing) ? Objects.isNull(other) : Objects.nonNull(other) && thing.equals(other);
    }

    @SafeVarargs
    public static <T> boolean equalsAny(T thing, T ... others) {
        for (T other : others) {
            if (!Misc.equalsNullable(thing, other)) continue;
            return true;
        }
        return false;
    }

    public static List<String> expandFilePaths(@Nullable List<String> filePaths) {
        HashSet<String> files = new HashSet<String>();
        if (Objects.nonNull(filePaths)) {
            for (String filePath : filePaths) {
                try (Stream<Path> paths = Files.walk(Paths.get(filePath, new String[0]), new FileVisitOption[0]);){
                    files.addAll(paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).collect(Collectors.toList()));
                }
                catch (IOException ex) {
                    TILRef.logError("Failed to walk file path {}", filePath, ex);
                }
                File file = new File(filePath);
                if (filePath.contains(".")) {
                    files.add(filePath);
                    continue;
                }
                String[] nextFiles = file.list();
                if (!Objects.nonNull(nextFiles)) continue;
                for (String appendedPath : Misc.expandFilePaths(nextFiles)) {
                    files.add(filePath + "/" + appendedPath);
                }
            }
        }
        return new ArrayList<String>(files);
    }

    public static List<String> expandFilePaths(String ... filePaths) {
        return Misc.expandFilePaths(Arrays.asList(filePaths));
    }

    public static Object getFixedObject(Object obj, Class<?> fixAs) {
        if (obj instanceof Object[]) {
            return ArrayHelper.fixObjParsed((Object[])obj, fixAs);
        }
        try {
            return fixAs.cast(obj);
        }
        catch (ClassCastException ex) {
            return obj;
        }
    }

    public static <V> V getEither(boolean choice, V ifChoice, V notChoice) {
        return choice ? ifChoice : notChoice;
    }

    public static <V> V getEitherOr(boolean choice1, boolean choice2, V ifChoice1, V ifChoice2, V neither) {
        return choice1 ? ifChoice1 : (choice2 ? ifChoice2 : neither);
    }

    @SafeVarargs
    public static <V> V getEitherTrailing(boolean[] choices, V ... returns) {
        if (returns.length == 1) {
            return returns[0];
        }
        int i = 0;
        while (i + 1 < returns.length) {
            boolean choice;
            boolean bl = choice = choices.length > i && choices[i];
            if (choice) {
                return returns[i];
            }
            ++i;
        }
        return returns[returns.length - 1];
    }

    public static String getLastSplit(String str, char splitBy) {
        return str.substring(str.lastIndexOf(splitBy) + 1);
    }

    public static String getLastSplit(String str, String splitBy) {
        return str.substring(str.lastIndexOf(splitBy) + 1);
    }

    public static <N, V> V getNullable(@Nullable N nullable, V notNull, V isNull) {
        return Misc.getEither(Objects.nonNull(nullable), notNull, isNull);
    }

    public static void lowerCaseAddCollection(Collection<String> c, String str) {
        if (TextHelper.isNotBlank(str)) {
            c.add(str.trim().toLowerCase());
        }
    }

    public static <V> void lowerCaseAddMap(Map<String, V> map, String str, V val) {
        if (TextHelper.isNotBlank(str)) {
            map.put(str.trim().toLowerCase(), val);
        }
    }

    public static String removeAll(String str, String ... removals) {
        for (String removal : removals) {
            str = str.replaceAll(removal, "");
        }
        return str;
    }

    public static <V, W> BiConsumer<V, W> safeBiConsumer(BiConsumer<V, W> biConsumer) {
        return Misc.safeBiConsumer(biConsumer, t -> {
            throw new RuntimeException("Consumer handle failed!", (Throwable)t);
        });
    }

    public static <V, W> BiConsumer<V, W> safeBiConsumer(BiConsumer<V, W> biConsumer, Consumer<Throwable> onThrow) {
        return (val1, val2) -> {
            try {
                biConsumer.accept(val1, val2);
            }
            catch (Throwable t) {
                onThrow.accept(t);
            }
        };
    }

    public static <A, B, V> BiFunction<A, B, V> safeBiFunction(BiFunction<A, B, V> biFunction) {
        return Misc.safeBiFunction(biFunction, t -> {
            throw new RuntimeException("BiFunction handle failed!", (Throwable)t);
        });
    }

    public static <A, B, V> BiFunction<A, B, V> safeBiFunction(BiFunction<A, B, V> biFunction, Function<Throwable, V> onThrow) {
        return (arg1, arg2) -> {
            try {
                return biFunction.apply(arg1, arg2);
            }
            catch (Throwable t) {
                return onThrow.apply(t);
            }
        };
    }

    public static <V> Consumer<V> safeConsumer(Consumer<V> consumer) {
        return Misc.safeConsumer(consumer, t -> {
            throw new RuntimeException("Consumer handle failed!", (Throwable)t);
        });
    }

    public static <V> Consumer<V> safeConsumer(Consumer<V> consumer, Consumer<Throwable> onThrow) {
        return value -> {
            try {
                consumer.accept(value);
            }
            catch (Throwable t) {
                onThrow.accept(t);
            }
        };
    }

    public static <A, V> Function<A, V> safeFunction(Function<A, V> function) {
        return Misc.safeFunction(function, t -> {
            throw new RuntimeException("Function handle failed!", (Throwable)t);
        });
    }

    public static <A, V> Function<A, V> safeFunction(Function<A, V> function, Function<Throwable, V> onThrow) {
        return arg -> {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                return onThrow.apply(t);
            }
        };
    }

    public static <V> Supplier<V> safeSupplier(Supplier<V> supplier) {
        return Misc.safeSupplier(supplier, t -> {
            throw new RuntimeException("Supplier handle failed!", (Throwable)t);
        });
    }

    public static <V> Supplier<V> safeSupplier(Supplier<V> supplier, Function<Throwable, V> onThrow) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                return onThrow.apply(t);
            }
        };
    }

    public static <T> T stupidCast(Object o) {
        return (T)o;
    }

    @Nullable
    public static <V, W> W wrap(@Nullable V val, Function<V, W> wrapperFunc) {
        return Misc.applyNullable(val, wrapperFunc);
    }

    public static <V> boolean xOr(V value, V in1, V in2) {
        return value.equals(in1) != value.equals(in2);
    }

    public static <V> V xOr(V value, V in1, V in2, V on, V off) {
        return Misc.xOr(value, in1, in2) ? on : off;
    }
}

