/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;

public class RandomHelper {
    public static <E> E getBasicRandomEntry(Collection<E> entries) {
        int index = entries.size();
        if (index == 0) {
            throw new IllegalArgumentException("Cannot get random entry of empty collection");
        }
        if (index == 1) {
            return new ArrayList<E>(entries).get(0);
        }
        index = RandomHelper.randomInt(index);
        for (E element : entries) {
            if (index == 0) {
                return element;
            }
            --index;
        }
        return null;
    }

    @Nullable
    public static <E extends WeightedEntry> E getEntryAt(Iterable<E> entries, int weight) {
        for (WeightedEntry entry : entries) {
            if ((weight -= entry.getWeight()) >= 0) continue;
            return (E)entry;
        }
        return null;
    }

    public static <E extends WeightedEntry> int getTotalWeight(Iterable<E> entries) {
        int weight = 0;
        for (WeightedEntry entry : entries) {
            weight += entry.getWeight();
        }
        return weight;
    }

    @Nullable
    @IndirectCallers
    public static <E extends WeightedEntry> E getWeightedEntry(Random rand, Iterable<E> entries) {
        return RandomHelper.getEntryAt(entries, rand.nextInt(RandomHelper.getTotalWeight(entries)));
    }

    private static <N extends Number> N parse(String name, String unparsed, N fallback, Function<String, N> fromString) {
        try {
            return (N)((Number)fromString.apply(unparsed));
        }
        catch (NumberFormatException ex) {
            TILRef.logError("Failed to parse number for {} from {}! Using fallback {}", name, unparsed, fallback);
            return fallback;
        }
    }

    @IndirectCallers
    public static byte randomByte(byte range) {
        return RandomHelper.randomByte((byte)0, range);
    }

    public static byte randomByte(byte b1, byte b2) {
        return (byte)RandomHelper.randomInt(b1, b2);
    }

    @IndirectCallers
    public static byte randomByte(String name, String unparsed, byte fallback) {
        return RandomHelper.randomNum(name, unparsed, fallback, Byte::parseByte, RandomHelper::randomByte);
    }

    @IndirectCallers
    public static double randomDouble(double range) {
        return RandomHelper.randomDouble(0.0, range);
    }

    public static double randomDouble(double d1, double d2) {
        if (d1 == d2) {
            return d1;
        }
        double min = Math.min(d1, d2);
        return min + ThreadLocalRandom.current().nextDouble() * (Math.max(d1, d2) - min);
    }

    @IndirectCallers
    public static double randomDouble(String name, String unparsed, double fallback) {
        return RandomHelper.randomNum(name, unparsed, fallback, Double::parseDouble, RandomHelper::randomDouble);
    }

    @IndirectCallers
    public static float randomFloat(float range) {
        return RandomHelper.randomFloat(0.0f, range);
    }

    public static float randomFloat(float f1, float f2) {
        if (f1 == f2) {
            return f1;
        }
        float min = Math.min(f1, f2);
        return min + ThreadLocalRandom.current().nextFloat() * (Math.max(f1, f2) - min);
    }

    @IndirectCallers
    public static float randomFloat(String name, String unparsed, float fallback) {
        return RandomHelper.randomNum(name, unparsed, Float.valueOf(fallback), Float::parseFloat, RandomHelper::randomFloat).floatValue();
    }

    public static int randomInt(int range) {
        return RandomHelper.randomInt(0, range);
    }

    public static int randomInt(int i1, int i2) {
        if (i1 == i2) {
            return i1;
        }
        int min = Math.min(i1, i2);
        return min + ThreadLocalRandom.current().nextInt(Math.max(i1, i2) - min);
    }

    @IndirectCallers
    public static int randomInt(String name, String unparsed, int fallback) {
        return RandomHelper.randomNum(name, unparsed, fallback, Integer::parseInt, RandomHelper::randomInt);
    }

    @IndirectCallers
    public static long randomLong(long range) {
        return RandomHelper.randomLong(0L, range);
    }

    public static long randomLong(long l1, long l2) {
        if (l1 == l2) {
            return l1;
        }
        long min = Math.min(l1, l2);
        return min + ThreadLocalRandom.current().nextLong(Math.max(l1, l2) - min);
    }

    @IndirectCallers
    public static long randomLong(String name, String unparsed, long fallback) {
        return RandomHelper.randomNum(name, unparsed, fallback, Long::parseLong, RandomHelper::randomLong);
    }

    private static <N extends Number> N randomNum(String name, String unparsed, N fallback, Function<String, N> fromString, BiFunction<N, N, N> fromRand) {
        if (TextHelper.isBlank(unparsed)) {
            TILRef.logWarn("String to parse blank value {} numerical parameter {}! Using fallback {}", unparsed, name, fallback);
            return fallback;
        }
        int index = unparsed.indexOf(58);
        if (index <= 0) {
            return RandomHelper.parse(name, unparsed, fallback, fromString);
        }
        N min = RandomHelper.parse(name, unparsed.substring(0, index - 1), fallback, fromString);
        N max = RandomHelper.parse(name, unparsed.substring(0, index - 1), fallback, fromString);
        return (N)((Number)fromRand.apply(min, max));
    }

    @IndirectCallers
    public static short randomShort(short range) {
        return RandomHelper.randomShort((short)0, range);
    }

    public static short randomShort(short s1, short s2) {
        return (short)RandomHelper.randomInt(s1, s2);
    }

    @IndirectCallers
    public static short randomShort(String name, String unparsed, short fallback) {
        return RandomHelper.randomNum(name, unparsed, fallback, Short::parseShort, RandomHelper::randomShort);
    }

    public static interface WeightedEntry {
        public int getWeight();

        public void setWeight(int var1);
    }
}

