/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum Sorting {
    ALPHABETICAL(Comparator.naturalOrder()),
    REVERSE(Comparator.reverseOrder());

    final Comparator<?> comparator;

    public static <T, C extends Collection<T>> C applyAll(C collection, Sorting ... sorters) {
        for (Sorting sorter : sorters) {
            collection = sorter.sorted(collection);
        }
        return collection;
    }

    private Sorting(Comparator<?> comparator) {
        this.comparator = comparator;
    }

    <T, C extends Collection<T>> C sorted(C collection) {
        Comparator<?> comparator = this.comparator;
        if (collection instanceof List) {
            ((List)collection).sort(comparator);
        } else if (collection instanceof Set) {
            collection = collection.stream().sorted(this.comparator).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return collection;
    }
}

