/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.minecraft.class_1159;
import net.minecraft.class_2583;
import net.minecraft.class_290;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.lwjgl.opengl.GL11;
import org.objectweb.asm.Type;

public class FabricHelper {
    static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    static final int DEFAULT_BORDER_COLOR_END = 1344798847;
    private static volatile Object CURRENT_SERVER;

    public static void finalizeEntrypoints(CommonEntryPoint entryPoint) {
        if (CoreAPI.getInstance().getSide().isClient()) {
            ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
                entryPoint.onInterModProcess();
                entryPoint.onLoadComplete();
            });
        } else {
            ServerLifecycleEvents.SERVER_STARTING.register(server -> {
                entryPoint.onInterModProcess();
                entryPoint.onLoadComplete();
            });
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            entryPoint.onServerAboutToStart();
            entryPoint.onServerStarting();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> entryPoint.onServerStarted());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> entryPoint.onServerStopping());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> entryPoint.onServerStopped());
    }

    public static Object getCurrentServer() {
        return CURRENT_SERVER;
    }

    @IndirectCallers
    public static String getCurrentNamespace() {
        return FabricHelper.getResolver().getCurrentRuntimeNamespace();
    }

    @IndirectCallers
    public static Field getObfField(String name, Class<?> owner, Object instance) {
        return FabricHelper.getObfField("intermediary", name, owner, instance);
    }

    public static Field getObfField(String namespace, String name, Class<?> owner, Object instance) {
        return FabricHelper.getObfField(namespace, name, owner, instance.getClass());
    }

    public static Field getObfField(String namespace, String srgName, Class<?> owner, Class<?> instanceClass) {
        return ReflectionHelper.getField(owner, FabricHelper.getObfFieldName(namespace, srgName, owner, instanceClass));
    }

    @IndirectCallers
    public static String getObfFieldName(String namespace, String srgName, Class<?> owner, Object instance) {
        return FabricHelper.getObfFieldName(namespace, srgName, owner, instance.getClass());
    }

    public static String getObfFieldName(String namespace, String name, Class<?> owner, Class<?> instanceClass) {
        return FabricHelper.getObfFieldName(namespace, name, owner.getName(), Type.getDescriptor(instanceClass));
    }

    public static String getObfFieldName(String namespace, String name, String owner, String desc) {
        return FabricHelper.getResolver().mapFieldName(namespace, owner, name, desc);
    }

    public static MappingResolver getResolver() {
        return FabricLoader.getInstance().getMappingResolver();
    }

    @IndirectCallers
    public static String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().getTargetNamespace();
    }

    public static boolean isJava8() {
        return System.getProperty("java.version").startsWith("1.");
    }

    public static void registerServerHooks() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CURRENT_SERVER = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            CURRENT_SERVER = null;
        });
    }

    public static void renderTooltip(class_4587 matrix, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, class_327 font) {
        FabricHelper.renderTooltip(matrix, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    public static void renderTooltip(class_4587 matrix, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font) {
        boolean java8 = FabricHelper.isJava8();
        RenderAPI renderer = ClientHelper.getRenderer();
        if (!textLines.isEmpty() && Objects.nonNull(renderer)) {
            int n;
            if (java8) {
                GL11.glDisable((int)32826);
            }
            int tooltipTextWidth = 0;
            for (class_5348 class_53482 : textLines) {
                int textLineWidth = font.method_27525(class_53482);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
                for (int i = 0; i < textLines.size(); ++i) {
                    class_5348 textLine = textLines.get(i);
                    List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (class_5348 line : wrappedLine) {
                        int lineWidth = font.method_27525(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((class_5348)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 400;
            matrix.method_22903();
            class_1159 mat = matrix.method_23760().method_23761();
            Object buffer = renderer.getBufferBuilder();
            if (!java8) {
                buffer = renderer.beginBuffer(buffer, 7, class_290.field_1576);
            }
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            FabricHelper.drawGradientRect(java8, renderer, buffer, mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            if (!java8) {
                RenderSystem.enableDepthTest();
                renderer.disableTexture();
                renderer.enableBlend();
                renderer.defaultBlendFunc();
                renderer.endBuffer();
                renderer.disableBlend();
                renderer.enableTexture();
            }
            Object renderType = renderer.renderSourceImmediate();
            matrix.method_22904(0.0, 0.0, 400.0);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                class_5348 line = textLines.get(lineNumber);
                FontAPI<?> api = ClientHelper.getFont();
                if (Objects.nonNull(line) && Objects.nonNull(api)) {
                    api.drawInBatch(line, tooltipX, tooltipY, -1, true, mat, renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderer.endBatch(renderType);
            matrix.method_22909();
            if (java8) {
                GL11.glEnable((int)32826);
            }
        }
    }

    public static void drawGradientRect(boolean java8, RenderAPI renderer, Object buffer, Object mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        if (Objects.isNull(renderer)) {
            return;
        }
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        if (java8) {
            RenderSystem.enableDepthTest();
            renderer.disableTexture();
            renderer.enableBlend();
            renderer.defaultBlendFunc();
            GL11.glShadeModel((int)7425);
            buffer = renderer.beginBuffer(buffer, 7, class_290.field_1576);
        }
        FabricHelper.drawVertex(renderer, buffer, mat, right, top, zLevel, startRed, startGreen, startBlue, startAlpha);
        FabricHelper.drawVertex(renderer, buffer, mat, left, top, zLevel, startRed, startGreen, startBlue, startAlpha);
        FabricHelper.drawVertex(renderer, buffer, mat, right, bottom, zLevel, endRed, endGreen, endBlue, endAlpha);
        FabricHelper.drawVertex(renderer, buffer, mat, left, bottom, zLevel, endRed, endGreen, endBlue, endAlpha);
        if (java8) {
            renderer.endBuffer();
            GL11.glShadeModel((int)7424);
            renderer.disableBlend();
            renderer.enableTexture();
        }
    }

    private static void drawVertex(RenderAPI renderer, Object buffer, Object mat, float x, float y, float z, float r, float g, float b, float a) {
        renderer.endVertex(renderer.vertexColor(renderer.vertexWithMatrix(buffer, mat, x, y, z), r, g, b, a));
    }
}

