/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.BasicMutableWrapped;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.objectweb.asm.tree.ClassNode;

public class TILFabricASMTarget {
    private static TILFabricASMTarget INSTANCE;
    private final Map<String, byte[]> classDefinitions = new HashMap<String, byte[]>();
    private final Map<String, Set<Consumer<ClassNode>>> classEditors = new HashMap<String, Set<Consumer<ClassNode>>>();
    private boolean loadedDefinitions;

    private static ClassLoader targetClassLoader() {
        return FabricLauncherBase.getLauncher().getTargetClassLoader();
    }

    private static TILFabricASMTarget getInstance() {
        return Objects.nonNull(INSTANCE) ? INSTANCE : new TILFabricASMTarget();
    }

    public static void loadDefinitions() {
        TILFabricASMTarget.getInstance().load(TILFabricASMTarget.targetClassLoader());
    }

    public static void registerDefinition(String target, byte[] byteCode) {
        TILFabricASMTarget instance = TILFabricASMTarget.getInstance();
        instance.classDefinitions.put(target, byteCode);
        instance.checkLoadLate(TILFabricASMTarget.targetClassLoader());
    }

    public static void registerEditor(String target, Consumer<ClassNode> editor) {
        TILFabricASMTarget instance = TILFabricASMTarget.getInstance();
        instance.classEditors.putIfAbsent(target, new HashSet());
        instance.classEditors.get(target).add(editor);
    }

    public static void runTransformers(Function<String, ClassNode> source, Consumer<ClassNode> emitter) {
        TILFabricASMTarget.getInstance().transformFunctionally(source, emitter);
    }

    @Nullable
    @IndirectCallers
    private byte[] transformSingleton(String className, byte[] byteCode) {
        return TILFabricASMTarget.getInstance().transform(className, byteCode);
    }

    private TILFabricASMTarget() {
        INSTANCE = this;
    }

    private void checkLoadLate(ClassLoader target) {
        if (this.loadedDefinitions) {
            this.load(target);
        }
    }

    private void load(ClassLoader target) {
        for (Map.Entry<String, byte[]> definition : this.classDefinitions.entrySet()) {
            ClassHelper.defineClass(target, definition.getKey(), definition.getValue());
        }
        this.classDefinitions.clear();
        this.loadedDefinitions = true;
    }

    @Nullable
    private byte[] onReturnTransform(String className, @Nullable byte[] transformed) {
        this.classEditors.remove(className);
        return transformed;
    }

    @Nullable
    private byte[] transform(String className, byte[] byteCode) {
        BasicMutableWrapped nodeWrapper = new BasicMutableWrapped();
        this.transformFunctionally(name -> ASMHelper.toClassNode(byteCode), nodeWrapper::setWrapped);
        return this.onReturnTransform(className, nodeWrapper.asOptional().map(ASMHelper::toBytes).orElse(null));
    }

    private void transformFunctionally(Function<String, ClassNode> source, Consumer<ClassNode> emitter) {
        for (Map.Entry<String, Set<Consumer<ClassNode>>> entry : this.classEditors.entrySet()) {
            this.transformNode(entry.getKey(), source, emitter, (Collection<Consumer<ClassNode>>)entry.getValue());
        }
        this.classEditors.clear();
    }

    private void transformNode(String className, Function<String, ClassNode> source, Consumer<ClassNode> emitter, Collection<Consumer<ClassNode>> editors) {
        ClassNode node = source.apply(className);
        if (Objects.isNull(node)) {
            TILRef.logError("ClassNode note found! Failed to transform {}", className);
            return;
        }
        if (Objects.isNull(editors) || editors.isEmpty()) {
            return;
        }
        TILRef.logInfo("Running transfomers for {}", className);
        for (Consumer<ClassNode> editor : editors) {
            editor.accept(node);
        }
        emitter.accept(node);
    }
}

