/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.forge.v16.m5.common.biome.Biome1_16_5;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;

public class World1_16_5
extends WorldAPI<IWorld> {
    public World1_16_5(Object world) {
        super((IWorld)world);
    }

    @Override
    public boolean canSnowAt(BlockPosAPI<?> api) {
        BlockPos pos = (BlockPos)api.unwrap();
        return ((IWorld)this.wrapped).func_226691_t_(pos).func_201850_b((IWorldReader)this.wrapped, pos);
    }

    @Override
    public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        BiomeAPI biome = WrapperHelper.wrapBiome(((IWorld)this.wrapped).func_226691_t_((BlockPos)pos.unwrap()));
        ((Biome1_16_5)biome).setAccess(((IWorld)this.wrapped).func_241828_r());
        return biome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box box) {
        ArrayList entities = new ArrayList();
        if (this.wrapped instanceof World) {
            IWorld iWorld = (IWorld)this.wrapped;
            synchronized (iWorld) {
                for (TileEntity tile : ((World)this.wrapped).field_147482_g) {
                    BlockPos pos = tile.func_174877_v();
                    if (!box.isInside(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
                    entities.add(WrapperHelper.wrapBlockEntity(tile));
                }
            }
        }
        return entities;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> pos) {
        TileEntity tile = ((IWorld)this.wrapped).func_175625_s((BlockPos)pos.unwrap());
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    @Override
    public int getDayNumber() {
        return (int)((double)this.getTimeTotal() / 24000.0);
    }

    @Override
    public int getDifficultyOrdinal() {
        if (((IWorld)this.wrapped).func_72912_H().func_76093_s()) {
            return 4;
        }
        switch (((IWorld)this.wrapped).func_175659_aa()) {
            case PEACEFUL: {
                return 0;
            }
            case EASY: {
                return 1;
            }
            case NORMAL: {
                return 2;
            }
            case HARD: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this, ((IWorld)this.wrapped).func_230315_m_());
    }

    @Override
    public List<EntityAPI<?, ?>> getEntitiesInBox(Box box) {
        return this.getEntitiesInBox(new AxisAlignedBB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<EntityAPI<?, ?>> getEntitiesInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (Entity entity : ((IWorld)this.wrapped).func_217357_a(Entity.class, (AxisAlignedBB)box)) {
            entities.add(WrapperHelper.wrapEntity(entity));
        }
        return entities;
    }

    @Override
    public int getLightBlock(BlockPosAPI<?> pos) {
        return ((IWorld)this.wrapped).func_226658_a_(LightType.BLOCK, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightSky(BlockPosAPI<?> pos) {
        return ((IWorld)this.wrapped).func_226658_a_(LightType.SKY, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightTotal(BlockPosAPI<?> pos) {
        return ((IWorld)this.wrapped).func_225524_e_().func_227470_b_((BlockPos)pos.unwrap(), 0);
    }

    @Override
    public List<LivingEntityAPI<?, ?>> getLivingInBox(Box box) {
        return this.getLivingInBox(new AxisAlignedBB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<LivingEntityAPI<?, ?>> getLivingInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (LivingEntity entity : ((IWorld)this.wrapped).func_217357_a(LivingEntity.class, (AxisAlignedBB)box)) {
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        }
        return entities;
    }

    @Override
    public int getMoonPhase() {
        return ((IWorld)this.wrapped).func_242414_af();
    }

    private Raid getRaid(BlockPosAPI<?> pos) {
        return ((IWorld)this.wrapped).func_201670_d() ? null : ((ServerWorld)this.wrapped).func_217475_c_((BlockPos)pos.unwrap());
    }

    @Override
    @Nullable
    public String getRaidStatus(BlockPosAPI<?> pos) {
        Raid raid = this.getRaid(pos);
        if (Objects.isNull(raid)) {
            return null;
        }
        if (raid.func_221321_e()) {
            return "VICTORY";
        }
        if (raid.func_221336_f()) {
            return "LOSS";
        }
        if (raid.func_221310_d()) {
            return "STOPPED";
        }
        if (raid.func_221333_v()) {
            return "ONGOING";
        }
        return null;
    }

    @Override
    public int getRaidWave(BlockPosAPI<?> pos) {
        Raid raid = this.getRaid(pos);
        return Objects.nonNull(raid) ? raid.func_221315_l() : -1;
    }

    @Override
    public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapState(((IWorld)this.wrapped).func_180495_p((BlockPos)pos.unwrap()));
    }

    @Override
    public StructureAPI<?> getStructureAt(BlockPosAPI<?> api) {
        if (this.wrapped instanceof ServerWorld) {
            StructureManager manager = ((ServerWorld)this.wrapped).func_241112_a_();
            BlockPos pos = (BlockPos)api.unwrap();
            for (Object structure : RegistryHelper.getStructureRegistry().getValues()) {
                if (!manager.func_235010_a_(pos, false, (Structure)structure).func_75069_d()) continue;
                return WrapperHelper.wrapStructure(structure);
            }
        }
        return null;
    }

    @Override
    public long getTimeDay() {
        return this.getTimeTotal() % 24000L;
    }

    @Override
    public long getTimeTotal() {
        return ((IWorld)this.wrapped).func_241851_ab();
    }

    @Override
    public boolean isClient() {
        return ((IWorld)this.wrapped).func_201670_d();
    }

    @Override
    public boolean isDaytime() {
        return this.wrapped instanceof World && this.getTimeDay() < 13000L;
    }

    @Override
    public boolean isNighttime() {
        return this.wrapped instanceof World && this.getTimeDay() >= 13000L;
    }

    @Override
    public boolean isRaining() {
        return this.wrapped instanceof World && ((World)this.wrapped).func_72896_J();
    }

    @Override
    public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return ((IWorld)this.wrapped).func_226660_f_((BlockPos)pos.unwrap());
    }

    @Override
    public boolean isStorming() {
        return this.wrapped instanceof World && ((World)this.wrapped).func_72911_I();
    }

    @Override
    public boolean isSunrise() {
        return this.getTimeDay() >= 23000L;
    }

    @Override
    public boolean isSunset() {
        long time = this.getTimeDay();
        return time >= 12000L && time < 13000L;
    }

    @Override
    public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        ((IWorld)this.wrapped).func_180501_a((BlockPos)pos.unwrap(), (BlockState)state.unwrap(), 2);
    }

    @Override
    public void spawnEntity(EntityAPI<?, ?> entity, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((IWorld)this.wrapped).func_201670_d()) {
            ((IWorld)this.wrapped).func_217376_c((Entity)entity.unwrapEntity());
            if (Objects.nonNull(onSpawn)) {
                onSpawn.accept(entity);
            }
        }
    }

    @Override
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (this.wrapped instanceof World && !((IWorld)this.wrapped).func_201670_d()) {
            ItemEntity item = new ItemEntity((World)this.wrapped, pos.dX(), pos.dY(), pos.dZ(), (ItemStack)stack.unwrap());
            item.func_174869_p();
            this.spawnEntity(WrapperHelper.wrapEntity(item), onSpawn);
        }
    }

    @Override
    public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((IWorld)this.wrapped).func_201670_d()) {
            ItemStackAPI stack = WrapperHelper.wrapItemStack(new ItemStack((IItemProvider)api.unwrap()));
            if (Objects.nonNull(beforeSpawn)) {
                beforeSpawn.accept(stack);
            }
            this.spawnItem(stack, pos, onSpawn);
        }
    }
}

