/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GL1_18_2
implements GLAPI {
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;
    private VertexFormat workingFormat;
    private BufferBuilder workingBuffer;
    private PoseStack.Pose workingPose;
    private double scaleX = 1.0;
    private double scaleY = 1.0;

    @Override
    public void directBegin(int modeVal) {
        this.workingBuffer = RenderSystem.m_69883_().m_85915_();
        this.workingFormat = DefaultVertexFormat.f_166851_;
        this.workingBuffer.m_166779_(VertexFormat.Mode.LINES, this.workingFormat);
        this.setWorkingColor(RenderSystem.m_157197_());
        Window window = Minecraft.m_91087_().m_91268_();
        double width = window.m_85441_();
        double height = window.m_85442_();
        double widthFactor = height > width ? width / height : 1.0;
        double heightFactor = width > height ? height / width : 1.0;
        this.scaleX = 1.0 + 1.0 / width * 16.0 * widthFactor;
        this.scaleY = 1.0 + 1.0 / height * 16.0 * heightFactor;
    }

    @Override
    public void directEnd() {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly end buffer before calling directBegin!", new Object[0]);
        } else {
            this.workingBuffer.m_85721_();
            RenderSystem.m_69464_();
            this.endWithShader(this.workingFormat);
            RenderSystem.m_69481_();
            this.workingBuffer = null;
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
        }
    }

    @Override
    public void directVertexD(double x, double y, double z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexD(double x, double y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void directVertexF(float x, float y, float z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexF(float x, float y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    @Override
    public void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    void endWithShader(VertexFormat format) {
        if (format == DefaultVertexFormat.f_85815_) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
        } else if (format == DefaultVertexFormat.f_85819_) {
            RenderSystem.m_157427_(GameRenderer::m_172820_);
        } else if (format == DefaultVertexFormat.f_85818_) {
            RenderSystem.m_157427_(GameRenderer::m_172712_);
        } else if (format == DefaultVertexFormat.f_166851_) {
            RenderSystem.m_157427_(GameRenderer::m_172757_);
        }
        BufferUploader.m_85761_((BufferBuilder)this.workingBuffer);
        RenderSystem.m_157427_(() -> null);
    }

    @Override
    public int lineStrip() {
        return 3;
    }

    @Override
    public int lines() {
        return 1;
    }

    private VertexConsumer normal(VertexConsumer consumer, float x, float y, float z) {
        return Objects.nonNull(this.workingPose) ? consumer.m_85977_(this.workingPose.m_85864_(), x, y, z) : consumer.m_5601_(x, y, z);
    }

    @Override
    public void normalizedVertex(double x, double y, double z, float r, float g, float b, float a, double nextX, double nextY, double nextZ) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot add normalized vertex to buffer before calling directBegin!", new Object[0]);
        }
        boolean same = x == nextX && y == nextY && z == nextZ;
        double nX = same ? 1.0 : (nextX *= this.scaleX) - (x *= this.scaleX);
        double nY = same ? 1.0 : (nextY *= this.scaleY) - (y *= this.scaleY);
        double nZ = same ? 1.0 : nextZ - z;
        double dist = MathHelper.distance(nX, nY, nZ);
        this.normal(this.vertex(x, y, z).m_85950_(r, g, b, a), (float)(nX /= dist), (float)(nY /= dist), (float)(nZ /= dist)).m_5752_();
        this.normal(this.vertex(nextX, nextY, nextZ).m_85950_(r, g, b, a), (float)nX, (float)nY, (float)nZ).m_5752_();
    }

    @Override
    public int quads() {
        return 7;
    }

    @Override
    public void scissor(int left, int bottom, int width, int height) {
        GL20.glScissor((int)left, (int)bottom, (int)width, (int)height);
    }

    @Override
    public int scissorTest() {
        return 3089;
    }

    @Override
    public void setLineWidth(float width) {
        RenderSystem.m_69832_((float)width);
    }

    private void setWorkingColor(float ... workingColor) {
        this.r = workingColor[0];
        this.g = workingColor[1];
        this.b = workingColor[2];
        this.a = workingColor[3];
    }

    @Override
    public void setWorkingMatrix(Object matrix) {
        if (matrix instanceof PoseStack) {
            this.workingPose = ((PoseStack)matrix).m_85850_();
        } else if (matrix instanceof PoseStack.Pose) {
            this.workingPose = (PoseStack.Pose)matrix;
        } else {
            if (Objects.nonNull(matrix)) {
                TILRef.logError("Tried to set working Pose for GL1_18_2 to a non PoseStack or Pose {}", matrix);
            }
            this.workingPose = null;
        }
    }

    @Override
    public int triangles() {
        return 4;
    }

    @Override
    public int triangleFan() {
        return 6;
    }

    private VertexConsumer vertex(double x, double y, double z) {
        return Objects.nonNull(this.workingPose) ? this.workingBuffer.m_85982_(this.workingPose.m_85861_(), (float)x, (float)y, (float)z) : this.workingBuffer.m_5483_(x, y, z);
    }
}

