/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.common.block;

import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockPropertyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.common.block.BlockProperty1_18_2;
import mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.common.block.Material1_18_2;
import mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.common.block.MaterialColor1_18_2;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class BlockHelper1_18_2
implements BlockHelperAPI {
    static final Map<String, MaterialColor> COLOR_BY_NAME = BlockHelper1_18_2.buildColorMap();
    static final Map<String, Material> MATERIAL_BY_NAME = BlockHelper1_18_2.buildMaterialMap();

    static Map<String, MaterialColor> buildColorMap() {
        return Map.ofEntries(Map.entry("AIR", MaterialColor.f_76398_), Map.entry("BLACK", MaterialColor.f_76365_), Map.entry("BLACK_TERRACOTTA", MaterialColor.f_76388_), Map.entry("BLUE", MaterialColor.f_76361_), Map.entry("BLUE_TERRACOTTA", MaterialColor.f_76383_), Map.entry("BROWN", MaterialColor.f_76362_), Map.entry("BROWN_TERRACOTTA", MaterialColor.f_76384_), Map.entry("CLAY", MaterialColor.f_76407_), Map.entry("CYAN", MaterialColor.f_76421_), Map.entry("CYAN_TERRACOTTA", MaterialColor.f_76381_), Map.entry("DIAMOND", MaterialColor.f_76367_), Map.entry("DIRT", MaterialColor.f_76408_), Map.entry("EMERALD", MaterialColor.f_76369_), Map.entry("FOLIAGE", MaterialColor.f_76405_), Map.entry("GOLD", MaterialColor.f_76366_), Map.entry("GRASS", MaterialColor.f_76399_), Map.entry("GRAY", MaterialColor.f_76419_), Map.entry("GRAY_TERRACOTTA", MaterialColor.f_76379_), Map.entry("GREEN", MaterialColor.f_76363_), Map.entry("GREEN_TERRACOTTA", MaterialColor.f_76385_), Map.entry("ICE", MaterialColor.f_76403_), Map.entry("LAPIS", MaterialColor.f_76368_), Map.entry("LIGHT_BLUE", MaterialColor.f_76415_), Map.entry("LIGHT_BLUE_TERRACOTTA", MaterialColor.f_76375_), Map.entry("LIGHT_GRAY", MaterialColor.f_76420_), Map.entry("LIGHT_GRAY_TERRACOTTA", MaterialColor.f_76380_), Map.entry("LIME", MaterialColor.f_76417_), Map.entry("LIME_TERRACOTTA", MaterialColor.f_76377_), Map.entry("MAGENTA", MaterialColor.f_76414_), Map.entry("MAGENTA_TERRACOTTA", MaterialColor.f_76374_), Map.entry("METAL", MaterialColor.f_76404_), Map.entry("NETHER", MaterialColor.f_76371_), Map.entry("ORANGE", MaterialColor.f_76413_), Map.entry("ORANGE_TERRACOTTA", MaterialColor.f_76373_), Map.entry("PINK", MaterialColor.f_76418_), Map.entry("PINK_TERRACOTTA", MaterialColor.f_76378_), Map.entry("PURPLE", MaterialColor.f_76422_), Map.entry("PURPLE_TERRACOTTA", MaterialColor.f_76382_), Map.entry("QUARTZ", MaterialColor.f_76412_), Map.entry("RED", MaterialColor.f_76364_), Map.entry("RED_TERRACOTTA", MaterialColor.f_76386_), Map.entry("SAND", MaterialColor.f_76400_), Map.entry("SNOW", MaterialColor.f_76406_), Map.entry("STONE", MaterialColor.f_76409_), Map.entry("WATER", MaterialColor.f_76410_), Map.entry("WHITE_TERRACOTTA", MaterialColor.f_76372_), Map.entry("WOOL", MaterialColor.f_76401_), Map.entry("WOOD", MaterialColor.f_76411_), Map.entry("YELLOW", MaterialColor.f_76416_), Map.entry("YELLOW_TERRACOTTA", MaterialColor.f_76376_));
    }

    static Map<String, Material> buildMaterialMap() {
        return Map.ofEntries(Map.entry("AIR", Material.f_76296_), Map.entry("ANVIL", Material.f_76281_), Map.entry("BARRIER", Material.f_76282_), Map.entry("CACTUS", Material.f_76277_), Map.entry("CAKE", Material.f_76287_), Map.entry("CLAY", Material.f_76313_), Map.entry("CORAL", Material.f_76301_), Map.entry("DIRT", Material.f_76314_), Map.entry("DRAGON_EGG", Material.f_76286_), Map.entry("EXPLOSIVE", Material.f_76273_), Map.entry("FIRE", Material.f_76309_), Map.entry("GLASS", Material.f_76275_), Map.entry("VEGETABLE", Material.f_76285_), Map.entry("GRASS", Material.f_76315_), Map.entry("ICE", Material.f_76276_), Map.entry("LAVA", Material.f_76307_), Map.entry("LEAVES", Material.f_76274_), Map.entry("METAL", Material.f_76279_), Map.entry("PACKED_ICE", Material.f_76316_), Map.entry("PISTON", Material.f_76283_), Map.entry("PORTAL", Material.f_76298_), Map.entry("SAND", Material.f_76317_), Map.entry("SNOW", Material.f_76280_), Map.entry("SNOW_LAYER", Material.f_76308_), Map.entry("SPONGE", Material.f_76318_), Map.entry("STONE", Material.f_76278_), Map.entry("STRUCTURE_VOID", Material.f_76297_), Map.entry("WATER", Material.f_76305_), Map.entry("WEB", Material.f_76311_), Map.entry("WOOL", Material.f_76272_), Map.entry("WOOD", Material.f_76320_));
    }

    @Override
    public <V extends Comparable<V>> BlockPropertyAPI<?, V> createProperty(String name, V defVal) {
        if (defVal instanceof Boolean) {
            return new BlockProperty1_18_2(BooleanProperty.m_61465_((String)name));
        }
        if (defVal instanceof Enum) {
            return new BlockProperty1_18_2(this.createPropertyEnum(name, defVal.getClass()));
        }
        if (defVal instanceof Number) {
            return new BlockProperty1_18_2(IntegerProperty.m_61631_((String)name, (int)0, (int)((Number)((Object)defVal)).intValue()));
        }
        TILRef.logError("Unsupported createProperty type for {}!", Objects.nonNull(defVal) ? defVal.getClass() : "null");
        return null;
    }

    private <E extends Enum<E>> EnumProperty<E> createPropertyEnum(String name, Class<?> clazz) {
        return EnumProperty.m_61587_((String)name, clazz);
    }

    @Override
    public <P> BlockPropertyAPI<?, ?> getAsProperty(P property) {
        if (property instanceof Property) {
            return new BlockProperty1_18_2((Property)property);
        }
        TILRef.logError("Object {} is not an instance of {}!", property, Property.class);
        return null;
    }

    public Material1_18_2 getMaterialByName(String name) {
        Material mat = TextHelper.isBlank(name) ? Material.f_76320_ : MATERIAL_BY_NAME.getOrDefault(name, Material.f_76320_);
        return new Material1_18_2(mat);
    }

    public MaterialColor1_18_2 getMaterialColorByName(String name) {
        MaterialColor color = TextHelper.isBlank(name) ? MaterialColor.f_76399_ : COLOR_BY_NAME.getOrDefault(name, MaterialColor.f_76399_);
        return new MaterialColor1_18_2(color);
    }
}

