/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v19.network;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v19.network.MessageWrapperForge1_19;
import mods.thecomputerizer.theimpossiblelibrary.forge.v19.network.Network1_19;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkForge1_19
extends Network1_19<SimpleChannel, NetworkDirection> {
    private SimpleChannel network;

    @Override
    public NetworkDirection getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT" -> NetworkDirection.LOGIN_TO_CLIENT;
            case "PLAY_TO_SERVER" -> NetworkDirection.PLAY_TO_SERVER;
            case "LOGIN_TO_SERVER" -> NetworkDirection.LOGIN_TO_SERVER;
            default -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }

    @Override
    public String getNameFromDir(NetworkDirection dir) {
        return dir.name();
    }

    @Override
    public NetworkDirection getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection getOppositeDir(NetworkDirection dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case NetworkDirection.PLAY_TO_CLIENT -> NetworkDirection.PLAY_TO_SERVER;
            case NetworkDirection.PLAY_TO_SERVER -> NetworkDirection.PLAY_TO_CLIENT;
            case NetworkDirection.LOGIN_TO_CLIENT -> NetworkDirection.LOGIN_TO_SERVER;
            case NetworkDirection.LOGIN_TO_SERVER -> NetworkDirection.LOGIN_TO_CLIENT;
        };
    }

    @Override
    public SimpleChannel getNetwork() {
        if (Objects.isNull(this.network)) {
            this.network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)((ResourceLocation)TILRef.res("main_network").unwrap())).clientAcceptedVersions(version -> true).serverAcceptedVersions(version -> true).networkProtocolVersion(TILRef::getNetworkVersion).simpleChannel();
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection> dir, int id) {
        this.getNetwork().registerMessage(id, MessageWrapperForge1_19.getClass(dir.getDirection()), MessageWrapperAPI::encode, buf -> MessageWrapperForge1_19.getInstance((NetworkDirection)dir.getDirection(), (ByteBuf)buf), (message, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            MessageWrapperForge1_19 wrapper = (MessageWrapperForge1_19)message.handle(context);
            if (Objects.nonNull(wrapper)) {
                if (!dir.isToClient()) {
                    wrapper.setPlayer(context.getSender());
                }
                wrapper.send();
            }
        }, Optional.of(dir.getDirection()));
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)((MessageWrapperForge1_19)message));
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().sendToServer((Object)((MessageWrapperForge1_19)message));
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection dir, MessageAPI<CTX> message) {
        MessageWrapperForge1_19 wrapper = MessageWrapperForge1_19.getInstance(dir);
        wrapper.setMessage(dir, message);
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, MessageAPI<CTX> ... messages) {
        MessageWrapperForge1_19 wrapper = MessageWrapperForge1_19.getInstance(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperForge1_19 wrapper = MessageWrapperForge1_19.getInstance(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }
}

