/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v20.common.block;

import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockPropertyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.common.block.BlockProperty1_20;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.common.block.Material1_20;
import mods.thecomputerizer.theimpossiblelibrary.forge.v20.common.block.MaterialColor1_20;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockHelper1_20
implements BlockHelperAPI {
    static final Map<String, MapColor> COLOR_BY_NAME = BlockHelper1_20.buildColorMap();

    static Map<String, MapColor> buildColorMap() {
        return Map.ofEntries(Map.entry("AIR", MapColor.f_283808_), Map.entry("BLACK", MapColor.f_283927_), Map.entry("BLACK_TERRACOTTA", MapColor.f_283771_), Map.entry("BLUE", MapColor.f_283743_), Map.entry("BLUE_TERRACOTTA", MapColor.f_283908_), Map.entry("BROWN", MapColor.f_283748_), Map.entry("BROWN_TERRACOTTA", MapColor.f_283774_), Map.entry("CLAY", MapColor.f_283744_), Map.entry("CYAN", MapColor.f_283772_), Map.entry("CYAN_TERRACOTTA", MapColor.f_283846_), Map.entry("DIAMOND", MapColor.f_283821_), Map.entry("DIRT", MapColor.f_283762_), Map.entry("EMERALD", MapColor.f_283812_), Map.entry("FOLIAGE", MapColor.f_283915_), Map.entry("GOLD", MapColor.f_283757_), Map.entry("GRASS", MapColor.f_283824_), Map.entry("GRAY", MapColor.f_283818_), Map.entry("GRAY_TERRACOTTA", MapColor.f_283861_), Map.entry("GREEN", MapColor.f_283784_), Map.entry("GREEN_TERRACOTTA", MapColor.f_283856_), Map.entry("ICE", MapColor.f_283828_), Map.entry("LAPIS", MapColor.f_283933_), Map.entry("LIGHT_BLUE", MapColor.f_283869_), Map.entry("LIGHT_BLUE_TERRACOTTA", MapColor.f_283791_), Map.entry("LIGHT_GRAY", MapColor.f_283779_), Map.entry("LIGHT_GRAY_TERRACOTTA", MapColor.f_283907_), Map.entry("LIME", MapColor.f_283916_), Map.entry("LIME_TERRACOTTA", MapColor.f_283778_), Map.entry("MAGENTA", MapColor.f_283931_), Map.entry("MAGENTA_TERRACOTTA", MapColor.f_283850_), Map.entry("METAL", MapColor.f_283906_), Map.entry("NETHER", MapColor.f_283820_), Map.entry("ORANGE", MapColor.f_283750_), Map.entry("ORANGE_TERRACOTTA", MapColor.f_283895_), Map.entry("PINK", MapColor.f_283765_), Map.entry("PINK_TERRACOTTA", MapColor.f_283870_), Map.entry("PURPLE", MapColor.f_283889_), Map.entry("PURPLE_TERRACOTTA", MapColor.f_283892_), Map.entry("QUARTZ", MapColor.f_283942_), Map.entry("RED", MapColor.f_283913_), Map.entry("RED_TERRACOTTA", MapColor.f_283798_), Map.entry("SAND", MapColor.f_283761_), Map.entry("SNOW", MapColor.f_283811_), Map.entry("STONE", MapColor.f_283947_), Map.entry("WATER", MapColor.f_283864_), Map.entry("WHITE_TERRACOTTA", MapColor.f_283919_), Map.entry("WOOL", MapColor.f_283930_), Map.entry("WOOD", MapColor.f_283825_), Map.entry("YELLOW", MapColor.f_283832_), Map.entry("YELLOW_TERRACOTTA", MapColor.f_283843_));
    }

    @Override
    public <V extends Comparable<V>> BlockPropertyAPI<?, V> createProperty(String name, V defVal) {
        if (defVal instanceof Boolean) {
            return new BlockProperty1_20(BooleanProperty.m_61465_((String)name));
        }
        if (defVal instanceof Enum) {
            return new BlockProperty1_20(this.createPropertyEnum(name, defVal.getClass()));
        }
        if (defVal instanceof Number) {
            return new BlockProperty1_20(IntegerProperty.m_61631_((String)name, (int)0, (int)((Number)((Object)defVal)).intValue()));
        }
        TILRef.logError("Unsupported createProperty type for {}!", Objects.nonNull(defVal) ? defVal.getClass() : "null");
        return null;
    }

    private <E extends Enum<E>> EnumProperty<E> createPropertyEnum(String name, Class<?> clazz) {
        return EnumProperty.m_61587_((String)name, clazz);
    }

    @Override
    public <P> BlockPropertyAPI<?, ?> getAsProperty(P property) {
        if (property instanceof Property) {
            return new BlockProperty1_20((Property)property);
        }
        TILRef.logError("Object {} is not an instance of {}!", property, Property.class);
        return null;
    }

    public Material1_20 getMaterialByName(String name) {
        return null;
    }

    public MaterialColor1_20 getMaterialColorByName(String name) {
        MapColor color = TextHelper.isBlank(name) ? MapColor.f_283824_ : COLOR_BY_NAME.getOrDefault(name, MapColor.f_283824_);
        return new MaterialColor1_20(color);
    }
}

