/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.common.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import org.burningwave.core.assembler.StaticComponentContainer;

public class StructureRef {
    private static final Set<StructureRef> REFS = StructureRef.addVanillaRefs();
    private static final String FEATURE_GEN_FIELD = TILDev.DEV ? "scatteredFeatureGenerator" : "field_186007_z";
    private final ResourceLocation id;
    private final String name;
    private final BiFunction<WorldServer, BlockPos, Boolean> posCheck;

    private static void addVanillaRef(Set<StructureRef> refs, String id, String name, @Nullable BiFunction<WorldServer, BlockPos, Boolean> posCheck) {
        refs.add(new StructureRef(new ResourceLocation(id), name, posCheck));
    }

    private static Set<StructureRef> addVanillaRefs() {
        HashSet<StructureRef> refs = new HashSet<StructureRef>();
        StructureRef.addVanillaRef(refs, "end_city", "EndCity", null);
        StructureRef.addVanillaRef(refs, "fortress", "Fortress", null);
        StructureRef.addVanillaRef(refs, "mansion", "Mansion", null);
        StructureRef.addVanillaRef(refs, "mineshaft", "Mineshaft", null);
        StructureRef.addVanillaRef(refs, "monument", "Monument", null);
        StructureRef.addVanillaRef(refs, "stronghold", "Stronghold", null);
        StructureRef.addVanillaRef(refs, "swamp_hut", "SwampHut", (world, pos) -> {
            IChunkGenerator generator;
            if (world.func_72863_F().func_193413_a((World)world, "Temple", pos) && (generator = world.func_72863_F().field_186029_c) instanceof ChunkGeneratorOverworld) {
                MapGenScatteredFeature features = StructureRef.getFeatureGenerator(generator);
                return Objects.nonNull(features) && features.func_175798_a(pos);
            }
            return false;
        });
        StructureRef.addVanillaRef(refs, "temple", "Temple", null);
        StructureRef.addVanillaRef(refs, "village", "Village", null);
        return refs;
    }

    private static MapGenScatteredFeature getFeatureGenerator(IChunkGenerator generator) {
        return (MapGenScatteredFeature)StaticComponentContainer.Fields.getDirect((Object)generator, FEATURE_GEN_FIELD);
    }

    public static Collection<StructureRef> getRegisteredStructures() {
        return Collections.unmodifiableSet(REFS);
    }

    @Nullable
    public static StructureRef getStructure(ResourceLocation id) {
        for (StructureRef ref : REFS) {
            if (!ref.id.equals((Object)id)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    public static StructureRef getStructureAt(WorldServer world, BlockPos pos) {
        for (StructureRef ref : REFS) {
            if (!ref.isPosInside(world, pos)) continue;
            return ref;
        }
        return null;
    }

    public static boolean isRegistered(StructureRef ref) {
        return REFS.contains(ref);
    }

    @IndirectCallers
    public static void register(ResourceLocation id, String name) {
        REFS.add(new StructureRef(id, name, null));
    }

    @IndirectCallers
    public static void register(ResourceLocation id, String name, BiFunction<WorldServer, BlockPos, Boolean> posCheck) {
        REFS.add(new StructureRef(id, name, posCheck));
    }

    private StructureRef(ResourceLocation id, String name, BiFunction<WorldServer, BlockPos, Boolean> posCheck) {
        this.id = id;
        this.name = name;
        this.posCheck = posCheck;
    }

    public boolean isPosInside(WorldServer world, BlockPos pos) {
        return Objects.nonNull(this.posCheck) ? this.posCheck.apply(world, pos).booleanValue() : world.func_72863_F().func_193413_a((World)world, this.name, pos);
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof StructureRef) {
            StructureRef otherRef = (StructureRef)other;
            return this.id.equals((Object)otherRef.id) && (Objects.isNull(this.posCheck) && Objects.isNull(otherRef.posCheck) || this.posCheck.equals(otherRef.posCheck));
        }
        return false;
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

