/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILDependencyConfigNeoForge;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILModConfigNeoForge;
import net.neoforged.neoforgespi.language.IConfigurable;
import org.burningwave.core.assembler.StaticComponentContainer;

public class TILFileConfigNeoForge
implements IConfigurable {
    private final Map<String, Object> infoMap = new HashMap<String, Object>();
    private final Map<String, List<IConfigurable>> childConfigs;
    private final Map<String, List<IConfigurable>> dependencies;

    public TILFileConfigNeoForge(Collection<?> infos, String loaderName) {
        this.infoMap.put("modLoader", loaderName);
        this.infoMap.put("loaderVersion", "[0.4.0,)");
        this.childConfigs = new HashMap<String, List<IConfigurable>>();
        this.dependencies = new HashMap<String, List<IConfigurable>>();
        this.childConfigs.put("mods", new ArrayList());
        boolean foundLicense = false;
        for (Object info : infos) {
            if (!foundLicense) {
                this.infoMap.put("license", this.getLicense(info));
                foundLicense = true;
            }
            this.childConfigs.get("mods").add(new TILModConfigNeoForge(info));
            String modid = this.getModID(info);
            if (modid.equals("theimpossiblelibrary")) continue;
            this.dependencies.put(modid, new ArrayList());
            this.dependencies.get(modid).add(new TILDependencyConfigNeoForge("theimpossiblelibrary", "[0.4.0,)", "AFTER", "BOTH", true));
        }
        if (!foundLicense) {
            this.infoMap.put("license", "LGPL V3");
        }
    }

    String getLicense(Object info) {
        return (String)StaticComponentContainer.Methods.invokeDirect(info, "getLicense", new Object[0]);
    }

    String getModID(Object info) {
        return (String)StaticComponentContainer.Methods.invokeDirect(info, "getModID", new Object[0]);
    }

    public <T> Optional<T> getConfigElement(String ... keys) {
        if (Objects.isNull(keys) || keys.length == 0) {
            return Optional.empty();
        }
        String key = keys[0];
        Object value = this.infoMap.get(key);
        return Objects.nonNull(value) ? Optional.of(value) : Optional.empty();
    }

    public List<? extends IConfigurable> getConfigList(String ... keys) {
        if (Objects.isNull(keys) || keys.length == 0) {
            return Collections.emptyList();
        }
        String key = keys[0];
        return key.equals("dependencies") ? this.dependencies.getOrDefault(keys[1], Collections.emptyList()) : this.childConfigs.getOrDefault(key, Collections.emptyList());
    }
}

