/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.VertexWrapper;

public class VertexWrapper1_20
extends VertexWrapper {
    protected final VertexFormat format;
    protected final VertexFormat.Mode formatMode;
    protected final Tesselator tesselator;
    protected final BufferBuilder buffer;

    public VertexWrapper1_20(VertexFormat.Mode mode, VertexFormat format, int numVertices, int ... vertexSizes) {
        super(mode.asGLMode, numVertices, vertexSizes);
        this.format = format;
        this.formatMode = mode;
        this.tesselator = mode == VertexFormat.Mode.LINES || mode == VertexFormat.Mode.LINE_STRIP ? RenderSystem.renderThreadTesselator() : Tesselator.getInstance();
        this.buffer = this.tesselator.getBuilder();
    }

    @Override
    protected void begin() {
        this.buffer.begin(this.formatMode, this.format);
    }

    @Override
    protected void draw() {
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)this.buffer.end());
    }

    @Override
    protected void onVertexEnded(Number[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            this.pushBuffer((VertexFormatElement)this.format.getElements().get(i), numbers[i]);
        }
        this.buffer.endVertex();
    }

    protected void pushBuffer(VertexFormatElement element, Number[] numbers) {
        if (element == DefaultVertexFormat.ELEMENT_POSITION) {
            this.buffer.vertex(numbers[0].doubleValue(), numbers[1].doubleValue(), numbers[2].doubleValue());
        } else if (element == DefaultVertexFormat.ELEMENT_COLOR) {
            this.buffer.color(numbers[0].floatValue(), numbers[1].floatValue(), numbers[2].floatValue(), numbers[3].floatValue());
        } else if (element == DefaultVertexFormat.ELEMENT_UV0 || element == DefaultVertexFormat.ELEMENT_UV1 || element == DefaultVertexFormat.ELEMENT_UV2) {
            this.buffer.uv(numbers[0].floatValue(), numbers[1].floatValue());
        }
    }
}

