/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.common.biome;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.burningwave.core.assembler.StaticComponentContainer;

public class Biome1_20
extends BiomeAPI<Biome> {
    static final String CLIMATE_SETTINGS;
    private static final String GET_TEMPERATURE;
    protected RegistryAccess access;

    public Biome1_20(Object biome) {
        super(biome instanceof Holder ? (Biome)((Holder)biome).value() : (Biome)biome);
    }

    @Override
    public boolean canRain(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return ((Biome)this.wrapped).getPrecipitationAt((BlockPos)pos.unwrap()) == Biome.Precipitation.RAIN;
    }

    @Override
    public boolean canSnow(WorldAPI<?> world, BlockPosAPI<?> pos) {
        return ((Biome)this.wrapped).getPrecipitationAt((BlockPos)pos.unwrap()) == Biome.Precipitation.SNOW;
    }

    @Override
    public float getRainfall() {
        if (FORGE_OR_NEOFORGE) {
            return ((Biome)this.wrapped).getModifiedClimateSettings().downfall();
        }
        Biome.ClimateSettings climate = (Biome.ClimateSettings)StaticComponentContainer.Fields.getDirect(this.wrapped, CLIMATE_SETTINGS);
        return climate.downfall();
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName() {
        if (Objects.isNull(this.registryName)) {
            if (Objects.isNull(this.access)) {
                ClientLevel level;
                this.access = CoreAPI.isClient() ? (Objects.nonNull(level = Minecraft.getInstance().level) ? level.registryAccess() : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)) : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
            }
            this.registryName = this.getRegistryName(this.access);
        }
        return this.registryName;
    }

    @Override
    public ResourceLocationAPI<?> getRegistryName(WorldAPI<?> world) {
        if (Objects.isNull(this.registryName)) {
            this.registryName = this.getRegistryName(((LevelAccessor)world.unwrap()).registryAccess());
        }
        return this.registryName;
    }

    protected ResourceLocationAPI<?> getRegistryName(RegistryAccess access) {
        Registry registry = access.registry(Registries.BIOME).orElse(null);
        return WrapperHelper.wrapResourceLocation(Objects.nonNull(registry) ? registry.getKey((Object)((Biome)this.wrapped)) : null);
    }

    @Override
    public Set<String> getTagNames(WorldAPI<?> world) {
        LevelAccessor access = (LevelAccessor)world.unwrap();
        Registry registry = access.registryAccess().registry(Registries.BIOME).orElse(null);
        if (Objects.isNull(registry)) {
            return Collections.emptySet();
        }
        ResourceKey key = registry.getResourceKey((Object)((Biome)this.wrapped)).orElse(null);
        if (Objects.isNull(key)) {
            return Collections.emptySet();
        }
        return this.getTagNames((Holder<Biome>)((Holder)registry.getHolder(key).orElse(null)));
    }

    @Override
    protected Set<String> getTagNames(Holder<Biome> holder) {
        if (Objects.isNull(holder)) {
            return Collections.emptySet();
        }
        return holder.tags().map(tagKey -> tagKey.location().toString()).collect(Collectors.toSet());
    }

    @Override
    public float getTemperatureAt(BlockPosAPI<?> pos) {
        try {
            return ((Float)StaticComponentContainer.Methods.invokeDirect(this.wrapped, GET_TEMPERATURE, pos.getWrapped())).floatValue();
        }
        catch (Throwable t) {
            TILRef.logError("Failed to get temperature for biome {} at {}", this.wrapped, pos.getWrapped(), t);
            return ((Biome)this.wrapped).getBaseTemperature();
        }
    }

    @Override
    public void setRegistryName(ResourceLocationAPI<?> registryName) {
        this.setLocalRegistryName(registryName);
    }

    @Generated
    public void setAccess(RegistryAccess access) {
        this.access = access;
    }

    static {
        ClassHelper.checkBurningWaveInit();
        String string = CLIMATE_SETTINGS = NAMED_ENV ? "climateSettings" : "field_26393";
        GET_TEMPERATURE = NAMED_ENV ? "getTemperature" : (SRG_ENV ? "m_47505_" : "method_21740");
    }
}

