/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.common.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mods.thecomputerizer.theimpossiblelibrary.api.common.container.PlayerInventoryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectInstanceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.tag.CompoundTag1_20;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v20.text.Text1_20;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public abstract class Player1_20<P extends Player>
extends PlayerAPI<P, EntityType<?>> {
    protected Player1_20(Object player) {
        super((Player)player, ((Player)player).getType());
    }

    @Override
    public boolean canTarget() {
        return false;
    }

    @Override
    public Collection<EffectInstanceAPI<?>> getActiveEffects() {
        return ((Player)this.entity).getActiveEffects().stream().map(WrapperHelper::wrapEffectInstance).collect(Collectors.toList());
    }

    @Override
    public int getAir() {
        return ((Player)this.entity).getAirSupply();
    }

    @Override
    public EntityAPI<?, ?> getAttackTarget() {
        return null;
    }

    @Override
    public BlockPosAPI<?> getBedPos(DimensionAPI<?> dimension) {
        return null;
    }

    @Override
    public Box getBoundingBox() {
        return Objects.nonNull(this.entity) ? this.getBoundingBox(((Player)this.entity).getBoundingBox()) : null;
    }

    protected Box getBoundingBox(AABB box) {
        return new Box(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    @Override
    public CompoundTagAPI<?> getData() {
        CompoundTag tag = new CompoundTag();
        if (Objects.nonNull(this.entity)) {
            tag = new EntityDataAccessor((Entity)this.entity).getData();
        }
        return new CompoundTag1_20(tag);
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this.getWorld(), ((Player)this.entity).level().dimensionType());
    }

    @Override
    public float getHealth() {
        return ((Player)this.entity).getHealth();
    }

    @Override
    public PlayerInventoryAPI<?> getInventory() {
        return WrapperHelper.wrapPlayerInventory(((Player)this.entity).inventoryMenu);
    }

    @Override
    public ItemStackAPI<?> getMainHandStack() {
        return WrapperHelper.wrapItemStack(((Player)this.entity).getMainHandItem());
    }

    @Override
    public float getMaxHealth() {
        return ((Player)this.entity).getMaxHealth();
    }

    @Override
    public String getName() {
        return ((Player)this.entity).getName().getString();
    }

    @Override
    public ItemStackAPI<?> getOffHandStack() {
        return WrapperHelper.wrapItemStack(((Player)this.entity).getOffhandItem());
    }

    @Override
    public BlockPosAPI<?> getPos() {
        return WrapperHelper.wrapPosition(((Player)this.entity).blockPosition());
    }

    @Override
    public EntityAPI<?, ?> getRootVehicle() {
        return WrapperHelper.wrapEntity(((Player)this.entity).getRootVehicle());
    }

    @Override
    public UUID getUUID() {
        return ((Player)this.entity).getUUID();
    }

    @Override
    @Nullable
    public EntityAPI<?, ?> getVehicle() {
        Entity entity = ((Player)this.entity).getVehicle();
        return Objects.nonNull(entity) ? WrapperHelper.wrapEntity(entity) : null;
    }

    @Override
    public WorldAPI<?> getWorld() {
        return WrapperHelper.wrapWorld(((Player)this.entity).level());
    }

    @Override
    public boolean isAlive() {
        return ((Player)this.entity).isAlive();
    }

    @Override
    public boolean isAnimal() {
        return false;
    }

    @Override
    public boolean isFishing() {
        return Objects.nonNull(((Player)this.entity).fishing) && ((Player)this.entity).fishing.isInWaterOrBubble();
    }

    @Override
    public boolean isFlying() {
        return ((Player)this.entity).isFallFlying();
    }

    @Override
    public boolean isHostile() {
        return false;
    }

    @Override
    public boolean isLiving() {
        return true;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public boolean isOwnedBy(EntityAPI<?, ?> owner) {
        return false;
    }

    @Override
    public void sendMessage(TextAPI<?> text, @Nullable UUID uuid) {
        if (Objects.nonNull(this.entity) && text instanceof Text1_20) {
            ((Player)this.entity).sendSystemMessage((Component)text.getAsComponent());
        }
    }

    @Override
    public void sendStatusMessage(TextAPI<?> text, boolean actionBar) {
        if (Objects.nonNull(this.entity) && text instanceof Text1_20) {
            ((Player)this.entity).displayClientMessage((Component)text.getAsComponent(), actionBar);
        }
    }

    @Override
    public void setRegistryName(ResourceLocationAPI<?> registryName) {
        this.setLocalRegistryName(registryName);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        ((Player)this.entity).setPos(x, y, z);
    }

    @Override
    public double x() {
        return ((Player)this.entity).position().x;
    }

    @Override
    public double y() {
        return ((Player)this.entity).position().y;
    }

    @Override
    public double z() {
        return ((Player)this.entity).position().z;
    }
}

