/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client;

import java.io.File;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.font.FontAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;
import org.jetbrains.annotations.Nullable;

public abstract class MinecraftAPI<M>
extends AbstractWrapped<M> {
    protected final FontAPI<?> font;
    protected final RenderAPI renderer;

    protected MinecraftAPI(Object mc, FontAPI<?> font, RenderAPI renderer) {
        super(mc);
        this.font = font;
        this.renderer = renderer;
    }

    public abstract void addResourcePackFolder(File var1);

    @Nullable
    public abstract Object getCurrentScreen();

    public abstract int getDisplayHeight();

    public abstract int getDisplayWidth();

    public abstract int getGUIScale();

    @Nullable
    public abstract PlayerAPI<?, ?> getPlayer();

    @IndirectCallers
    @Nullable
    public abstract BlockEntityAPI<?, ?> getTargetBlockEntity();

    @IndirectCallers
    @Nullable
    public abstract EntityAPI<?, ?> getTargetEntity();

    public abstract MinecraftWindow getWindow();

    @Nullable
    public abstract WorldAPI<?> getWorld();

    public boolean hasPlayer() {
        return Objects.nonNull(this.getPlayer());
    }

    @IndirectCallers
    public boolean hasPlayerAndWorld() {
        return this.hasPlayer() && this.hasWorld();
    }

    @IndirectCallers
    public boolean hasScreen() {
        return false;
    }

    public boolean hasWorld() {
        return Objects.nonNull(this.getWorld());
    }

    @IndirectCallers
    public abstract <S> boolean isCurrentScreen(S var1);

    @IndirectCallers
    public abstract boolean isCurrentScreenAPI();

    public abstract boolean isDisplayFocused();

    public abstract boolean isFinishedLoading();

    public abstract boolean isFullScreen();

    public boolean isLoading() {
        return TILRef.getClientHandles().isLoading(this.wrapped);
    }

    public abstract boolean isPaused();

    @IndirectCallers
    public boolean isUnpausedAndFocused() {
        return this.isDisplayFocused() && !this.isPaused();
    }

    @IndirectCallers
    public abstract <T> Supplier<T> scheduleReturnable(Supplier<T> var1);

    @IndirectCallers
    public abstract void scheduleRunnable(Runnable var1);

    @IndirectCallers
    public void sendMessageToPlayer(TextAPI<?> text) {
        this.sendMessageToPlayer(text, null);
    }

    public void sendMessageToPlayer(TextAPI<?> text, @Nullable UUID uuid) {
        PlayerAPI<?, ?> player = this.getPlayer();
        if (Objects.nonNull(player)) {
            player.sendMessage(text, uuid);
        }
    }

    public void sendStatusMessageToPlayer(TextAPI<?> text, boolean actionBar) {
        PlayerAPI<?, ?> player = this.getPlayer();
        if (Objects.nonNull(player)) {
            player.sendStatusMessage(text, actionBar);
        }
    }

    @Generated
    public FontAPI<?> getFont() {
        return this.font;
    }

    @Generated
    public RenderAPI getRenderer() {
        return this.renderer;
    }
}

