/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Column;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.ITickableGeometry;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.ShapeHolder;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public abstract class AnchoredGeometry {
    private final List<ShapeHolder> freeShapeRenders = new ArrayList<ShapeHolder>();
    private final List<Column> columnRenders = new ArrayList<Column>();
    private Vector3 renderVec;

    public AnchoredGeometry(Vector3 renderVec) {
        this.renderVec = renderVec;
    }

    public void addColumn(Column column) {
        this.columnRenders.add(column);
    }

    public void addFreeShape(ShapeHolder holder) {
        this.freeShapeRenders.add(holder);
    }

    public void setRenderXZ(double x, double z) {
        this.renderVec = new Vector3(x, this.renderVec.dY(), z);
    }

    public abstract boolean canRender();

    public abstract Vector3 getRenderPos(float var1);

    public void render(RenderContext ctx, float partialTicks) {
        if (this.canRender()) {
            Vector3 renderAt = this.renderVec.sub(this.getRenderPos(partialTicks));
            Iterator<Column> columnItr = this.columnRenders.iterator();
            while (columnItr.hasNext()) {
                Column column = columnItr.next();
                if (column instanceof ITickableGeometry && !((ITickableGeometry)((Object)column)).isInitialized()) {
                    columnItr.remove();
                    continue;
                }
                column.render(ctx, renderAt);
            }
            Iterator<ShapeHolder> holderItr = this.freeShapeRenders.iterator();
            while (holderItr.hasNext()) {
                ShapeHolder holder = holderItr.next();
                if (holder instanceof ITickableGeometry && !((ITickableGeometry)((Object)holder)).isInitialized()) {
                    holderItr.remove();
                    continue;
                }
                holder.render(ctx, renderAt);
            }
        }
    }

    public boolean isEmpty() {
        return this.columnRenders.isEmpty() && this.freeShapeRenders.isEmpty();
    }

    @Generated
    public void setRenderVec(Vector3 renderVec) {
        this.renderVec = renderVec;
    }
}

