/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.client.geometry.Convex3D;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;

public class ShapeHolder {
    protected final Convex3D shape;
    private final List<ShapeHolder> childHolders;
    private boolean isMoving;
    protected Vector3 relativePosVec;
    private Vector3 dirVec;

    public ShapeHolder(Convex3D shape) {
        this.shape = shape;
        this.childHolders = new ArrayList<ShapeHolder>();
        this.relativePosVec = VectorHelper.zero3D();
    }

    public void addChild(Convex3D shape, Consumer<ShapeHolder> holderSettings) {
        ShapeHolder childHolder = new ShapeHolder(shape);
        holderSettings.accept(childHolder);
        this.addChild(childHolder);
    }

    public void addChild(ShapeHolder childHolder) {
        this.childHolders.add(childHolder);
    }

    public void startMoving() {
        this.isMoving = true;
    }

    public ShapeHolder setRelativePosition(Vector3 relativePos) {
        this.relativePosVec = relativePos;
        return this;
    }

    public void setRelativeBottom() {
        this.setRelativePosition(new Vector3(0.0, this.shape.getScaledHeight(), 0.0));
    }

    public ShapeHolder setDirection(Vector3 dirVec) {
        this.dirVec = dirVec;
        return this;
    }

    public ShapeHolder setRotations(double x, double y, double z) {
        this.shape.setRotationSpeed(x, y, z);
        return this;
    }

    public ShapeHolder setScale(float x, float y, float z) {
        this.shape.setScale(x, y, z);
        return this;
    }

    public ShapeHolder setColor(float ... colors) {
        this.shape.setColor(colors);
        return this;
    }

    public void stopMoving() {
        this.isMoving = false;
    }

    public Vector3 getRelativePosition() {
        return this.relativePosVec;
    }

    public void render(RenderContext ctx, Vector3 relativeCenter) {
        this.shape.render(ctx, relativeCenter.add(this.relativePosVec));
        if (this.isMoving) {
            this.setRelativePosition(this.relativePosVec.add(this.dirVec));
        }
        for (ShapeHolder child : this.childHolders) {
            child.render(ctx, relativeCenter);
        }
    }

    public void renderScaledRelative(RenderContext ctx, Vector3 relativeCenter, float scale) {
        this.shape.render(ctx, relativeCenter.add(this.relativePosVec.mulScalar(Float.valueOf(scale))));
        if (this.isMoving) {
            this.setRelativePosition(this.relativePosVec.add(this.dirVec));
        }
        for (ShapeHolder child : this.childHolders) {
            child.render(ctx, relativeCenter);
        }
    }
}

