/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.client.gui.widget;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.gui.MinecraftWindow;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.RenderContext;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;

public abstract class Widget {
    protected double height;
    protected Widget parent;
    protected boolean visible;
    protected double width;
    protected double x;
    protected double y;

    protected Widget() {
        this(null);
    }

    protected Widget(Widget parent) {
        this.parent = parent;
        this.visible = true;
    }

    public abstract Widget copy();

    protected void copyBasic(Widget other) {
        this.height = other.height;
        this.parent = other.parent;
        this.visible = other.visible;
        this.width = other.width;
        this.x = other.x;
        this.y = other.y;
    }

    public boolean canDraw() {
        return this.isVisible();
    }

    public abstract void draw(RenderContext var1, Vector3 var2, double var3, double var5);

    public double getBottom() {
        return this.getY() - this.getHeight() / 2.0;
    }

    public Vector3 getCenter() {
        return new Vector3(this.getX(), this.getY(), 0.0);
    }

    public Vector3 getCenter(double z) {
        return new Vector3(this.getX(), this.getY(), z);
    }

    public Vector3 getCenter(Vector3 center) {
        return new Vector3(this.getX() + center.dX(), this.getY() + center.dY(), center.dZ());
    }

    public double getLeft() {
        return this.getX() - this.getWidth() / 2.0;
    }

    public double getRight() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getTop() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public double getX() {
        return Objects.nonNull(this.parent) ? this.x + this.parent.getX() : this.x;
    }

    public double getY() {
        return Objects.nonNull(this.parent) ? this.y + this.parent.getY() : this.y;
    }

    public boolean isVisible() {
        return this.visible && (Objects.isNull(this.parent) || this.parent.isVisible());
    }

    public abstract void onResolutionUpdated(MinecraftWindow var1);

    public void onScreenClosed() {
    }

    public void onScreenOpened() {
    }

    @Generated
    public void setHeight(double height) {
        this.height = height;
    }

    @Generated
    public void setParent(Widget parent) {
        this.parent = parent;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setWidth(double width) {
        this.width = width;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public double getHeight() {
        return this.height;
    }

    @Generated
    public Widget getParent() {
        return this.parent;
    }

    @Generated
    public double getWidth() {
        return this.width;
    }
}

